<?php

use App\Settings;

function getSetting($name, $status = true){
    $value = Settings::where('name',$name)->first();

    if(!$status){
        return $value;
    }

    if($value){
        return $value->value;
    }

    return false;
}

/**
 * Get Kavenegar sender number from settings
 * Falls back to default if not set
 */
function getKavenegarSender() {
    try {
        $sender = getSetting('KavehnegarSender');
        if ($sender && !empty($sender)) {
            return $sender;
        }
    } catch (\Exception $e) {
        // Ignore
    }
    
    // Default fallback
    return '10004346';
}
