<?php

namespace App\Helpers\Payment\Banks;

use App\Settings;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;

class Zibal
{
    /**
     * @var \Illuminate\Database\Eloquent\HigherOrderBuilderProxy|mixed
     */
    private $Token;

    /**
     * @var string[]
     */
    private $headers = [
        'Accept: application/json',
        'charset: utf-8',
        'Content-Type: application/json',
    ];

    public function __construct() {
        $this->Token = Settings::query()
            ->where('name','VandarToken')
            ->first()->value;
    }

    /**
     * send request Payment towards zarinpal
     * @param $amount
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Http\RedirectResponse|\Illuminate\Routing\Redirector
     * @throws \Exception
     */
    public function request($amount, $CallbackURL, $params = null)
    {
        $VandarToken = Settings::where('name','VandarToken')->first()->value;
            $parameters = array(
                "api_key"=> $VandarToken,//required
                "callback_url"=> $CallbackURL,//required
                "amount"=> $amount*10,//required

                "factorNumber"=> time(),//optional
                "mobile_number"=> Auth::user()->mobile
            );

            $url = 'https://ipg.vandar.io/api/v3/send';
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($parameters));
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $response  = curl_exec($ch);
            curl_close($ch);
            $response = json_decode($response);


            if ($response->result == 1)
            {
                $startGateWayUrl = "https://ipg.vandar.io/v3/" . $response->token;
                header('location: '.$startGateWayUrl);
            }
            else{
                echo "errorCode: ".$response->result."<br>";
                echo "message: ".$response->message;
            }

        }
    }

    /**
     * active Payment done
     * @param $Authority
     * @param $amount
     * @return mixed
     * @throws \Exception
     */
    public function verify($trackId)
    {
        $parameters = [
            "merchant" => $this->Token,
            "trackId" => $trackId
        ];

        $request = Http::withHeaders($this->headers)
            ->post('https://gateway.zibal.ir/v1/verify', $parameters);
        $response = json_decode($request->getBody()->getContents(), true);
        if(isset($response['result']) && $response['result'] == 100){
            return $response;
        }
        return  [
            'status' => false,
            'message' => "پرداخت با شکست مواجه شد!"
        ];
    }
}
