<?php
namespace App\Http\Controllers\Admin;

use App\User;
use App\Orders;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Morilog\Jalali;
use DB;
use Session;
use Auth;
use App\Settings;

class DashboardController extends Controller
{
    public function index(){


        $result = (object)array();
        $result->WalletTotal = User::sum('wallet');
        $result->BuyTotal = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('type', '!=','sell')->count();
        $result->SellTotal = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('type', 'sell')->count();
        $result->OrderTotal = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->count();

        $result->UserTotal = User::count();
        $result->BuyAmountTotal = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('type', '!=','sell')->sum('amount');
        $result->SellAmountTotal = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('type', 'sell')->sum('amount');
        $result->OrderAmountTotal = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->sum('amount');

        $result->UserInvitation = User::whereNotNull('invitationID')->count();
        $result->TicketTotal = \App\Ticket::count();

        $result->CardBankTotal = \App\CardBank::count();
        $UsersActive = DB::select('select arzland_users.id from arzland_users,arzland_orders where arzland_users.id = arzland_orders.id_user Group By arzland_users.id');
        $result->UsersActive = count($UsersActive);
        $result->FinanceTotal = \App\UserFinance::count();
        $result->UserWallet = User::where('wallet','>',0)->count();

        $result->Today = self::GetDetailGeneral(date('Y-m-d 00:00:00'),date('Y-m-d 00:00:00',strtotime('+1 day')));
        $result->Yesterday = self::GetDetailGeneral(date('Y-m-d 00:00:00',strtotime('-1 day')),date('Y-m-d 00:00:00'));

        $Saturday = Jalali\Jalalian::forge('last saturday')->format('Y/m/d H:i:s');
        $SaturdayStart = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i:s', $Saturday);
        $Saturday = Jalali\Jalalian::forge('saturday')->addDays(7)->format('Y/m/d H:i:s');
        $SaturdayStop = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i:s', $Saturday);
        $result->Week = self::GetDetailGeneral($SaturdayStart,$SaturdayStop);

        $MonthStart = Jalali\Jalalian::forge('now')->format('Y/m/01 00:00:00');
        $MonthStart = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i:s', $MonthStart);
        $MonthStop = Jalali\Jalalian::forge('now')->addMonths(1)->format('Y/m/01 00:00:00');
        $MonthStop = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i:s', $MonthStop);
        $result->Month = self::GetDetailGeneral($MonthStart,$MonthStop);

        $YearStart = Jalali\Jalalian::forge('now')->format('Y/01/01 00:00:00');
        $YearStart = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i:s', $YearStart);
        $YearStop = Jalali\Jalalian::forge('now')->addYears(1)->format('Y/01/01 00:00:00');
        $YearStop = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i:s', $YearStop);
        $result->Year = self::GetDetailGeneral($YearStart,$YearStop);


        //currency
        //$Currencys = array('PSVouchers','PerfectMoney','PMvoucher','WebMoney');
        $Currencys = array();
        $cryptocurrency = \App\Cryptocurrency::all()->pluck('name')->toArray();
        $result->Currencys = array_merge($Currencys,$cryptocurrency);

        foreach($result->Currencys as $Currency){
            $result->$Currency = (object)array();
            $result->$Currency->Today = self::GetDetailCurrency($Currency,date('Y-m-d 00:00:00'),date('Y-m-d 00:00:00',strtotime('+1 day')));
            $result->$Currency->Yesterday = self::GetDetailCurrency($Currency,date('Y-m-d 00:00:00',strtotime('-1 day')),date('Y-m-d 00:00:00'));
            $result->$Currency->Week = self::GetDetailCurrency($Currency,$SaturdayStart,$SaturdayStop);
            $result->$Currency->Month = self::GetDetailCurrency($Currency,$MonthStart,$MonthStop);
            $result->$Currency->Year = self::GetDetailCurrency($Currency,$YearStart,$YearStop);
        }


        //ChartLine
        $Label_CL = array();
        $UserAdd_CL = array();
        $AmountSell = array();
        $AmountBuy = array();

        for($i=12;$i>=-1;$i--){
            // label
            $month = date('Y-m-d', strtotime( ($i*-1) .' month'));
            array_push($Label_CL,  Jalali\CalendarUtils::strftime('F(y)', strtotime($month)) );

            $MonthStart = Jalali\Jalalian::forge('now')->forge($i*-1 .'month')->format('Y/m/01 00:00:00');
            $MonthStart = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i:s', $MonthStart);

            $MonthStop = Jalali\Jalalian::forge($MonthStart)->addMonths(1)->format('Y/m/01 00:00:00');
            $MonthStop = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i:s', $MonthStop);

            $CountUser = User::where('created_at', '>=',$MonthStart)->where('created_at', '<=',$MonthStop)->count();
            array_push($UserAdd_CL,$CountUser );


            $Sell = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$MonthStart)->where('created_at', '<=',$MonthStop)->where('type', 'sell')->sum('amount');
            array_push($AmountSell, round($Sell/1000000,1) );

            $Buy = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$MonthStart)->where('created_at', '<=',$MonthStop)->where('type','!=', 'sell')->sum('amount');
            array_push($AmountBuy, round($Buy/1000000,1) );
        }
        $result->Label_CL = $Label_CL;
        $result->UserAdd_CL = $UserAdd_CL;
        $result->AmountSell = $AmountSell;
        $result->AmountBuy = $AmountBuy;

        //ChartPie
        $result->PieCurrencyOrders = Orders::select('orders_model')->selectRaw('sum(amount) as amount')->where('status','!=','معلق')->where('status','!=','معلق,عودت')->groupBy('orders_model')->get();
        $result->PieCurrencyVia = Orders::select('via')->selectRaw('count(*) as count')->where('status','!=','معلق')->where('status','!=','معلق,عودت')->groupBy('via')->get();
        $result->PieCurrencyViaUsers = User::select('register_via as via')->selectRaw('count(*) as count')->groupBy('register_via')->get();

        //return response()->json($result->PieCurrencyVia);


        //return response()->json($result);
        return view('admin.dashboard',['result'=>$result]);
    }

    public function GetDetailGeneral($DateStart,$dateStop){
        $result = (object)array();
        $result->CountOrders = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->count();
        $result->AmountOrders = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->sum('amount');
        $result->CountOrdersSell = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->where('type', 'sell')->count();
        $result->AmountOrdersSell = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->where('type', 'sell')->sum('amount');
        $result->CountOrdersBuy = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->where('type','!=', 'sell')->count();
        $result->AmountOrdersBuy = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->where('type','!=', 'sell')->sum('amount');
        $result->CountUser = User::where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->count();

        $AmountMaxSell = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->where('type', 'sell')->orderBy('amount','desc')->first();
        $result->AmountMaxSell = isset($AmountMaxSell) ? $AmountMaxSell->amount : 0;
        $AmountMaxBuy = Orders::where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->where('type','!=', 'sell')->orderBy('amount','desc')->first();
        $result->AmountMaxBuy = isset($AmountMaxBuy) ? $AmountMaxBuy->amount : 0;
        return $result;
    }
    public function GetDetailCurrency($Currency,$DateStart,$dateStop){
        $result = (object)array();
        $result->CountOrders = Orders::where('orders_model',$Currency)->where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->count();
        $result->AmountOrders = Orders::where('orders_model',$Currency)->where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->sum('amount');
        $result->CountOrdersBuy = Orders::where('orders_model',$Currency)->where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->where('type','!=', 'sell')->count();
        $result->CountOrdersSell = Orders::where('orders_model',$Currency)->where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->where('type', 'sell')->count();
        $result->AmountOrdersBuy = Orders::where('orders_model',$Currency)->where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->where('type','!=', 'sell')->sum('amount');
        $result->AmountOrdersSell = Orders::where('orders_model',$Currency)->where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->where('type', 'sell')->sum('amount');

        $AmountMaxSell = Orders::where('orders_model',$Currency)->where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->where('type', 'sell')->orderBy('amount','desc')->first();
        $result->AmountMaxSell = isset($AmountMaxSell) ? $AmountMaxSell->amount : 0;
        $result->IDMaxSell = isset($AmountMaxSell) ? $AmountMaxSell->id : 0;

        $AmountMaxBuy = Orders::where('orders_model',$Currency)->where('status','!=','معلق')->where('status','!=','معلق,عودت')->where('created_at', '>=',$DateStart)->where('created_at', '<=',$dateStop)->where('type','!=', 'sell')->orderBy('amount','desc')->first();
        $result->AmountMaxBuy = isset($AmountMaxBuy) ? $AmountMaxBuy->amount : 0;
        $result->IDMaxBuy = isset($AmountMaxBuy) ? $AmountMaxBuy->id : '';

        $Currencys = array('PSVouchers','PerfectMoney','PMvoucher','WebMoney', 'skrill', 'paypal');
        if(in_array($Currency,$Currencys)) {
            $tabel = 'arzland_orders_' . strtolower($Currency);
            $dollarBuy = DB::select('select sum(amount_dollar) as amount_dollar from ' . $tabel . ',arzland_orders where ' . $tabel . '.id_order = arzland_orders.id
                                            and arzland_orders.type != "sell" and created_at >= ? and created_at <=?', [$DateStart, $dateStop]);
            $result->dollarBuy = round($dollarBuy[0]->amount_dollar, 6);

            $dollarSell = DB::select('select sum(amount_dollar) as amount_dollar from ' . $tabel . ',arzland_orders where ' . $tabel . '.id_order = arzland_orders.id
                                            and arzland_orders.type = "sell" and created_at >= ? and created_at <=?', [$DateStart, $dateStop]);
            $result->dollarSell = round($dollarSell[0]->amount_dollar, 6);
        }else{
            $dollarBuy = DB::select('select sum(amount_coin) as amount_dollar from arzland_orders_cryptocurrency,arzland_orders where arzland_orders_cryptocurrency.id_order = arzland_orders.id
                                            and arzland_orders.type != "sell" and coin=? and created_at >= ? and created_at <=? ', [$Currency,$DateStart, $dateStop]);
            $result->dollarBuy = round($dollarBuy[0]->amount_dollar, 6);

            $dollarSell = DB::select('select sum(amount_coin) as amount_dollar from arzland_orders_cryptocurrency,arzland_orders where arzland_orders_cryptocurrency.id_order = arzland_orders.id
                                            and arzland_orders.type = "sell" and coin=? and created_at >= ? and created_at <=?', [$Currency,$DateStart, $dateStop]);
            $result->dollarSell = round($dollarSell[0]->amount_dollar, 6);
        }

        return $result;
    }

    public function check_stock(){
        $Controller = 'App\Http\Controllers\User\DashboardController';
        return  app($Controller)->check_stock();
    }

    protected function perfectmoney_balances()
    {
        $AccountID = getSetting('perfectmoney_AccountID');
        $Password = getSetting('perfectmoney_Password');
        $ssl_fix = ['ssl' => ['verify_peer' => false, 'verify_peer_name' => false]];
        // trying to open URL to process PerfectMoney Spend request
        $url = file_get_contents('https://perfectmoney.is/acct/balance.asp?AccountID=' . $AccountID . '&PassPhrase=' . $Password , false, stream_context_create($ssl_fix));
        if(!$url){
            return ['status' => 'error', 'message' => 'Connection error'];
        }
        // searching for hidden fields
        if(!preg_match_all("/<input name='(.*)' type='hidden' value='(.*)'>/", $url, $result, PREG_SET_ORDER))
        {
            return ['status' => 'error', 'message' => 'Invalid output'];
        }
        // putting data to array (return error, if have any)
        $data = [];
        foreach($result as $item)
        {
            if($item[1] == 'ERROR')
            {
                return ['status' => 'error', 'message' => $item[2]];
            }
            else
            {
                $data['data'][$item[1]] = $item[2];
            }
        }

        $data['status'] = 'success';

        return $data;

    }

}

