<?php

namespace App\Http\Controllers\Admin;

use App\DigitalMoney;
use App\Http\Controllers\Controller;
use App\OrderDigitalMoney;
use App\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class DigitalMoneyController extends Controller
{
    public function index(Request $request)
    {
        if ($request->get('type', false) === 'insert')
            return $this->new($request);

        if ($request->get('type', false) === 'delete')
            return $this->delete($request);

        if ($request->get('type', false) == 'update')
            return $this->status($request);

        if ($request->get('currency_id', false))
            return $this->edit($request);

        return view('admin.currency.currency-list', [
            'digital' => DigitalMoney::all()
        ]);
    }

    public function orderCurrency(Request $request)
    {
        if ($request->get('type', false))
            return $this->buyّFromCustomer($request);

        $order_digital_money = OrderDigitalMoney::query()->with(['digitalMoney' => function ($query) {
            $query->select(['id', 'name_fa', 'logo']);
        }, 'user'=> function ($query) {
            $query->select(['id', 'name', 'family']);
        }])
            ->orderByDesc('created_at')
            ->paginate(25);

        return view('admin.currency.order', ['orders' => $order_digital_money]);
    }


    public function new ($request) {
        $result = [];
        DB::beginTransaction();
        try {
            $digital_money = new DigitalMoney();
            $digital_money->name = $request->get('name');
            $digital_money->name_fa = $request->get('name_fa');
            $digital_money->quantity = $request->get('quantity');
            $digital_money->buy_money = str_replace(',', '.', $request->get('buy_money'));
            $digital_money->sell_money = str_replace(',', '.', $request->get('sell_money'));
            $digital_money->approved = $request->get('status');
            $digital_money->wallet = $request->get('wallet');
            $digital_money->description = $request->get('description');
            $path = '/app-assets/images/currency/';
            $logo_name = strtolower($request->get('name')) . '.svg';
            try {
                $request->file('logo')->move(LARAVEL_PUBLIC_DIR . $path, $logo_name);
            }catch (\Exception){
              return response()->json([
                        'status' => false,
                        'message' => ' لوگو پول دیجیتال مورد نظر شما ذخیره نشد لطفا دوباره تلاش کنید. '
                ]);
            }
            $digital_money->logo = $path . $logo_name;
            $digital_money->save();

           $result = [
                'status' => true,
                'message' => 'پول دیجیتال مورد نظر شما ثبت شد'
            ];

            DB::commit();

        }catch (\Exception $e) {
            DB::rollBack();
            return response()->json($result . $e);
        }
        return response()->json($result);
    }

    public function edit ($request) {
        $digital_money = DigitalMoney::find($request->get('currency_id'));
        if ($digital_money) {
            $digital_money->name = $request->get('name');
            $digital_money->name_fa = $request->get('name_fa');
            $digital_money->quantity = $request->get('quantity');
            $digital_money->wallet = $request->get('wallet');
            $digital_money->buy_money = $request->get('buy_money');
            $digital_money->sell_money = $request->get('sell_money');
            $digital_money->description = $request->get('description');
            if ($request->file('logo', false)) {
                $path = '/app-assets/images/currency/';
                $logo_name = strtolower($request->get('name')) . '.svg';
                try {
                    $request->file('logo')->move(LARAVEL_PUBLIC_DIR . $path, $logo_name);
                }catch (\Exception){
                    return response()->json([
                        'status' => false,
                        'message' => ' لوگو پول دیجیتال مورد نظر شما ذخیره نشد لطفا دوباره تلاش کنید. '
                    ]);
                }
                $digital_money->logo = $path . $logo_name;
            }
            $digital_money->save();
            return response()->json(
                [
                    'status' => true,
                    'message' => 'پول دیجیتال مورد نظر شما ویرایش شد'
                ]
            );
        }
        return response()->json(
            [
                'status' => true,
                'message' => ' در ویرایش پول دیجیتال مورد نظر شما مشکلی پیش آمد '
            ]
        );
    }

    public function delete ($request) {
        $delete = DigitalMoney::query()
            ->where('id', '=', $request->get('id'))
            ->delete();
        if ($delete) {
            return response()->json(
                [
                    'status' => true,
                    'message' => 'پول دیجیتال مورد نظر حذف شد. '
                ]
            );
        }
        return response()->json(
            [
                'status' => false,
                'message' => 'پول دیجیتال مورد نظر حذف نشد. دوباره تلاش کنید'
            ]
        );
    }

    public function status ($request) {
        $digital_money = DigitalMoney::query()
            ->where('id', '=', $request->get('id'))
            ->update(['approved' => $request->get('status')]);
        if ($digital_money) {
            return response()->json(
                [
                    'status' => true,
                    'message' => ' عملیات مورد نظر شما انجام شد '
                ]
            );
        }
        return response()->json(
            [
                'status' => false,
                'message' => 'عملیات مورد نظر شما انجام نشد '
            ]
        );
    }

    public function buyّFromCustomer($request) {
        $order_digital_money = OrderDigitalMoney::query()
            ->where('id', '=', $request->get('id'))
            ->where('status', '=', 'pending')
            ->first();
        $digital_money = DigitalMoney::find($order_digital_money->digital_money_id );
        if ($order_digital_money->payment_type === 'wallet') {
            $user = User::find($order_digital_money->user_id);
            try {
                $user->wallet = $user->wallet + $order_digital_money->final_price;
                if ($user->save()){
                    $digital_money->quantity = $digital_money->quantity + $order_digital_money->quantity;
                    $digital_money->save();
                    $order_digital_money->status = 'confirm';
                    $order_digital_money->admin_note = $request->get('admin_note');
                    $order_digital_money->save();
                }
            }catch (\Exception $e) {
                return response()->json([
                    'status' => true,
                    'message' => 'مشکلی پیش آمد در تایید خرید از مشتری دوباره تلاش کنید.'. $e
                ]);
            }
            return response()->json([
                'status' => true,
                'message' => 'خرید مشتر تایید شد.'
            ]);
        }
        try {
            $order_digital_money->status = 'confirm';
            $order_digital_money->save();
            $digital_money->quantity = $digital_money->quantity + $order_digital_money->quantity;
            $digital_money->save();
        }catch (\Exception $e) {
            return response()->json([
                'status' => true,
                'message' => 'مشکلی پیش آمد در تایید خرید از مشتری دوباره تلاش کنید.' . $e
            ]);
        }
        return response()->json([
            'status' => true,
            'message' => 'خرید از مشتری تایید شد.'
        ]);
    }

}
