<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\FinotechSendMoney;
use SoulDoit\DataTable\SSP;
use Morilog\Jalali;

class FinotechSend extends Controller
{
    public function index(){
        return view('admin.finotech-sendmoney');
    }

    public function ListSend(Request $request)
    {

        $functions = new \App\functions;
        if (isset($request->date_start)) {
            $request->date_start = $functions->toLatin($request->date_start);
            $request->date_start = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i', $request->date_start);
        }

        if (isset($request->date_stop)) {
            $request->date_stop = $functions->toLatin($request->date_stop);
            $request->date_stop = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i', $request->date_stop);
        }

        $dt = [
            ['db' => 'id', 'dt' => 0],

            ['db' => 'user.family', 'dt' => 22],
            ['db' => 'id_order', 'dt' => 44],

            ['db' => 'user.name', 'dt' => 1],
            ['db' => 'users_cardbank.shaba', 'dt' => 2],
            ['db' => 'id_finance', 'dt' => 3, 'formatter' => function ($value, $model) {
                if(isset($model->id_order))
                    return '<a href="'.asset('').env('PanelPrefix').'/orders/'.$model->id_order.'">سفارش</a>';
                elseif(isset($value))
                    return 'درخواست برداشت'.' <a href="#" data-toggle="modal" data-target="#Info" onclick="Info('.$value.')">#'.$value.'</a>';

            }],
            ['db' => 'amount', 'dt' => 4, 'formatter' => function ($value, $model) {
                return number_format($value);
            }],
            ['db' => 'finotech_send_money.created_at', 'dt' => 5, 'formatter' => function ($value, $model) {
                return  Jalali\CalendarUtils::strftime('d F Y - H:i', strtotime($value));;
            }]
        ];


        $my_ssp = (new SSP('\App\FinotechSendMoney', $dt))->where(function ($query) {

            if (isset(request()->date_start)) {
                $query->where('finotech_send_money.created_at', '>', request()->date_start);
            }

            if (isset(request()->date_stop)) {
                $query->where('finotech_send_money.created_at', '<', request()->date_stop);
            }


            if (isset(request()->amount_start)) {
                $amount_start = str_replace(',','',request()->amount_start);
                $query->where('finotech_send_money.amount', '>=', $amount_start);
            }

            if (isset(request()->amount_stop)) {
                $amount_stop = str_replace(',','',request()->amount_stop);
                $query->where('finotech_send_money.amount', '<=', $amount_stop);
            }


        });

        //if (isset(request()->bank_name) && request()->bank_name != '')
            $my_ssp->leftJoin('users_cardbank', 'finotech_send_money.id_cardbank','users_cardbank.id');

        $my_ssp->leftJoin('users AS user', 'finotech_send_money.id_user','user.id');

        return response()->json($my_ssp->getDtArr());
    }

}
