<?php

namespace App\Http\Controllers\Admin;

use App\Orders;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Morilog\Jalali;
use DB;
use Session;
use Auth;
use App\UserInvitation;
use SoulDoit\DataTable\SSP;


class InvitationController extends Controller
{
    public function index(){
        $result = array();

        $invitationUsers = User::select('id','name','family','mobile','code_meli','auth_img_confirm','selfie_img_confirm','wallet','created_at')
            ->whereNotNull('invitationID')
            ->orderBy('id','desc')
            ->get();
        foreach($invitationUsers as $user){
            $user->date =  Jalali\CalendarUtils::strftime('d F Y', strtotime($user->created_at));
            $user->order = \App\Orders::where('id_user',$user->id)->where('type','!=','sell')->whereNotNull('payment')->count();
        }
        $result['invitationUser'] = $invitationUsers;
        $result['orders'] = UserInvitation::count();
        $result['amount'] = UserInvitation::sum('amount');

        $functions = new \App\functions;
        $invitations = \App\UserInvitation::select('users_invitation.id','users_invitation.amount','users_invitation.id_user','users_invitation.created_at','users_invitation.updated_at','users.name','users.family','orders.amount As user_amount','orders.orders_model')
            ->leftJoin('users', 'users_invitation.id_invitation_user', '=', 'users.id')
            ->leftJoin('orders', 'users_invitation.id_order', '=', 'orders.id')
            ->latest('updated_at')
            ->paginate(10);
        foreach ($invitations as $invitation) {
            $invitation->created_at = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($invitation->created_at));
            $invitation->updated_at = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($invitation->updated_at));
        }

        return view('admin.invitation', compact(['result', 'invitations']));
    }

    public function list_finance(Request $request)
    {

        $functions = new \App\functions;
        if (isset($request->date_start)) {
            $request->date_start = $functions->toLatin($request->date_start);
            $request->date_start = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i', $request->date_start);
        }

        if (isset($request->date_stop)) {
            $request->date_stop = $functions->toLatin($request->date_stop);
            $request->date_stop = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i', $request->date_stop);
        }

        $dt = [
            ['db' => 'id', 'dt' => 0],

            ['db' => 'invitation.family', 'dt' => 22],
            ['db' => 'invitation.name', 'dt' => 1],
            ['db' => 'id_order', 'dt' => 2, 'formatter' => function ($value, $model) {
                $functions = new \App\functions;
                $detail = $functions->get_order_detail($value);
                $Amount =  $detail->amount_dollar ? $detail->amount_dollar : '';
                $Amount .= $detail->amount_dollar ? $detail->dollar : '-----';
                return $Amount;
            }],
            ['db' => 'orders.amount', 'dt' => 3, 'formatter' => function ($value, $model) {
                return number_format($value);
            }],

            ['db' => 'user.family', 'dt' => 44],
            ['db' => 'user.name', 'dt' => 4],
            ['db' => 'users_invitation.amount', 'dt' => 5, 'formatter' => function ($value, $model) {
                return number_format($value);;
            }],
            ['db' => 'users_invitation.created_at', 'dt' => 6, 'formatter' => function ($value, $model) {
                return  Jalali\CalendarUtils::strftime('d F Y - H:i', strtotime($value));;
            }],
        ];


        $my_ssp = (new SSP('\App\UserInvitation', $dt))->where(function ($query) {

            if (isset(request()->date_start)) {
                $query->where('users_invitation.created_at', '>', request()->date_start);
            }

            if (isset(request()->date_stop)) {
                $query->where('users_invitation.created_at', '<', request()->date_stop);
            }

        });
        $my_ssp->leftJoin('users AS user', 'users_invitation.id_user','user.id');
        $my_ssp->leftJoin('users AS invitation', 'users_invitation.id_invitation_user','invitation.id');
        $my_ssp->leftJoin('orders', 'users_invitation.id_order','orders.id');
        return response()->json($my_ssp->getDtArr());
    }
}
