<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class DiagnosticController extends Controller
{
    public function testAPIs()
    {
        $results = [];
        
        // Test CoinEx
        $results['coinex'] = $this->testAPI('https://api.coinex.com/v1/market/ticker/all', 'CoinEx');
        
        // Test Binance
        $results['binance'] = $this->testAPI('https://api.binance.com/api/v3/ticker/price?symbol=BTCUSDT', 'Binance');
        
        // Test Nobitex
        $results['nobitex'] = $this->testAPI('https://api.nobitex.ir/market/stats', 'Nobitex');
        
        // Test Tetherland
        $results['tetherland'] = $this->testAPI('https://api.tetherland.com/currencies', 'Tetherland');
        
        // Test CoinGecko
        $results['coingecko'] = $this->testAPI('https://api.coingecko.com/api/v3/ping', 'CoinGecko');
        
        return response()->json([
            'status' => 'success',
            'results' => $results,
            'summary' => [
                'total' => count($results),
                'working' => count(array_filter($results, function($r) { return $r['success']; })),
                'failed' => count(array_filter($results, function($r) { return !$r['success']; }))
            ]
        ]);
    }
    
    private function testAPI($url, $name)
    {
        $start = microtime(true);
        
        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 10);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $error = curl_error($ch);
            $info = curl_getinfo($ch);
            curl_close($ch);
            
            $duration = round((microtime(true) - $start) * 1000, 2);
            
            $success = ($httpCode === 200 && $response !== false);
            
            return [
                'name' => $name,
                'url' => $url,
                'success' => $success,
                'http_code' => $httpCode,
                'duration_ms' => $duration,
                'response_size' => strlen($response),
                'error' => $error ?: null,
                'ip' => $info['primary_ip'] ?? null
            ];
            
        } catch (\Exception $e) {
            return [
                'name' => $name,
                'url' => $url,
                'success' => false,
                'error' => $e->getMessage(),
                'duration_ms' => round((microtime(true) - $start) * 1000, 2)
            ];
        }
    }
}
