<?php

namespace App;

use App\Casts\dateToPersian;
use Illuminate\Database\Eloquent\Model;

class OrderDigitalMoney extends Model
{
    protected $table = 'orders_digital_money';

    public function digitalMoney () {
        return $this->belongsTo(DigitalMoney::class, 'digital_money_id');
    }

    public function user () {
        return $this->belongsTo(User::class, 'user_id');
    }

    protected $casts = [
       'created_at' => dateToPersian::class,
        'updated_at' => dateToPersian::class
    ];
}
