<?php

namespace App\Providers;

use App\DigitalMoney;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Validator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
        require_once dirname(__DIR__) . '/GlobalFunctions.php';
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Override Kavenegar config with DB setting
        try {
            $kavenegarKey = getSetting('KavehnegarKey');
            if ($kavenegarKey) {
                config(['kavenegar.apikey' => $kavenegarKey]);
            }
        } catch (\Exception $e) {
            // Ignore errors if DB is not ready
        }

        Validator::extend('mobile', function ($attribute, $value, $parameters, $validator) {
            $inputs = $validator->getData();
            if(substr( $inputs[$attribute],0,2) == '09')
                return true;
            else
                return false;
        });

        Validator::extend('phone', function ($attribute, $value, $parameters, $validator) {
            $inputs = $validator->getData();
            if(substr( $inputs[$attribute],0,2) != '09')
                return true;
            else
                return false;
        });

        Validator::extend('farsi', function ($attribute, $value, $parameters, $validator) {
            $inputs = $validator->getData();
            $farsi_Char="/^[a-zA-Z0-9]+$/";
            if(preg_match($farsi_Char,$inputs[$attribute]) | preg_match($farsi_Char,$inputs[$attribute]))
                return false;
            else
                return true;
        });

        View::composer('user.layouts.menu', function ($view) {
            $menu = DigitalMoney::query()->select(['name', 'name_fa'])->get();
            $view->with(['menu' => $menu]);
        });
    }
}
