<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class TradingPair extends Model
{
    protected $fillable = [
        'market',
        'base_currency',
        'quote_currency',
        'is_active',
        'min_amount',
        'min_total',
        'maker_fee',
        'taker_fee',
        'price_precision',
        'amount_precision',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'min_amount' => 'decimal:8',
        'min_total' => 'decimal:8',
        'maker_fee' => 'decimal:4',
        'taker_fee' => 'decimal:4',
        'price_precision' => 'integer',
        'amount_precision' => 'integer',
    ];

    /**
     * Get active trading pairs
     */
    public static function getActive()
    {
        return self::where('is_active', true)->get();
    }

    /**
     * Check if market is active
     */
    public function isActive()
    {
        return $this->is_active;
    }

    /**
     * Format price according to precision
     */
    public function formatPrice($price)
    {
        return number_format($price, $this->price_precision, '.', '');
    }

    /**
     * Format amount according to precision
     */
    public function formatAmount($amount)
    {
        return number_format($amount, $this->amount_precision, '.', '');
    }
}
