<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('title', '255')->nullable();
            $table->mediumText('description')->nullable();
            $table->unsignedInteger('category_id');
            $table->string('image', '255')->nullable();
            $table->unsignedInteger('quantity')->nullable();
            $table->decimal('buy_price', 9,0)->nullable();
            $table->decimal('product_price', 9,0)->nullable();
            $table->boolean('free_delivery')->default(0);
            $table->boolean('approved')->default(0);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('products');
    }
}
