<?php
$jsonPath = __DIR__ . '/prices.json';

echo "<h1>Prices JSON Debug</h1>";

if (file_exists($jsonPath)) {
    echo "<p>File exists.</p>";
    echo "<p>Last Modified: " . date("Y-m-d H:i:s", filemtime($jsonPath)) . "</p>";
    echo "<p>Current Time: " . date("Y-m-d H:i:s") . "</p>";
    echo "<p>Size: " . filesize($jsonPath) . " bytes</p>";
    
    $content = file_get_contents($jsonPath);
    $data = json_decode($content, true);
    
    if ($data) {
        echo "<h2>Content Preview (First 3 items):</h2>";
        echo "<pre>";
        print_r(array_slice($data, 0, 3));
        echo "</pre>";
        
        if (isset($data['BTC'])) {
            echo "<h2>BTC Price:</h2>";
            echo "<pre>";
            print_r($data['BTC']);
            echo "</pre>";
        }
    } else {
        echo "<p>Error decoding JSON.</p>";
    }
} else {
    echo "<p>File does NOT exist.</p>";
}
