<?php
require __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

use App\Services\CoinPriceService;
use Illuminate\Support\Facades\Cache;

echo "<h1>Crypto Price Debugger</h1>";

$service = new CoinPriceService();
$prices = $service->getAllPrices();

echo "<h2>Cache Key: " . CoinPriceService::CACHE_KEY . "</h2>";
echo "<h2>Cached Data:</h2>";
echo "<pre>";
print_r($prices);
echo "</pre>";

echo "<h2>Direct Cache Check:</h2>";
$cached = Cache::get(CoinPriceService::CACHE_KEY);
echo "<pre>";
print_r($cached);
echo "</pre>";
