@extends('admin.layouts.master')
@section('title', 'پرداخت گروهی')
@section('css')
    <link rel="stylesheet" type="text/css"
          href="{{asset('')}}app-assets/vendors/css/tables/datatable/datatables.min.css">
    <style>
        .selection-multiple-rows tbody.text-center tr.selected{
            background-color: rgb(122, 210, 116) !important;
        }
    </style>
@stop

@section('content')
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before" style="background:#1C2135"></div>
        <div class="content-header row">
        </div>
        <div class="content-body">

            <div class="row">
                <div class="card mb-4 w-100">
                    <div class="card-body">
                        <table class="table table-striped table-bordered alt-pagination selection-multiple-rows dataex-fixh-basic w-100"
                               id="table_category">
                            <thead class='iransensbold'>
                            <tr>
                                <th class="text-center w-1"></th>
                                <th class="text-center w-1">#</th>
                                <th class="text-center">نام کاربر</th>
                                <th class="text-center">مبلغ</th>
                                <th class="text-center">موجودی</th>
                                <th class="text-center">تاریخ و ساعت ثبت</th>
                                <th class="text-center">شرح</th>
                                <th class="text-center">وضعیت</th>
                                <th class="text-center">جزئیات</th>
                            </tr>
                            </thead>
                            <tbody  class="text-center">
                            @foreach($result['finances'] as $finance)
                                <tr class="selected">
                                    <td>{{$finance->id}}</td>
                                    <td></td>
                                    <td>{{$finance->user->name .' '.$finance->user->family}}<br>{{$finance->user->mobile}}</td>
                                    <td>{{number_format($finance->amount). ' تومان'}}</td>
                                    <td>{{number_format($finance->stock). ' تومان'}}</td>
                                    <td>{{$finance->date}}</td>
                                    <td>{{$finance->description}}</td>
                                    <td>
                                        @if($finance->status =='در دست اقدام')
                                            <span class="badge badge-pill badge-warning m-1 font-weight-light">{{$finance->status}}</span>
                                        @endif
                                    </td>
                                    <td><button type="button" class="btn btn-outline-info btn-sm" onclick="Info({{$finance->id}})"  data-toggle="modal" data-target="#Info">Info</button></td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>



        </div>
    </div>
</div>



    <!-- Modal -->
    <div class="modal fade" id="Info" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">اطلاعات حساب</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="text-center"><span class="spinner-glow spinner-glow-info"></span></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">بستن</button>
                </div>
            </div>
        </div>
    </div>
@stop

@section('js')
    <script src="{{asset('')}}js/tables/datatable/datatables.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/digitbox.min.js"></script>
@stop

@section('script')
    <script>

        function Info(id){
            $('#Info .modal-body').load("{{asset('').env('PanelPrefix')}}/finances/"+id).fadeIn();
        }
        $('#Info').on('hidden.bs.modal', function () {
            $('#Info .modal-body').html('<div class="text-center"><span class="spinner-glow spinner-glow-info"></span></div>');
        })

        $('.alt-pagination').DataTable({
            "pagingType": "full_numbers",
            "scrollX": true,
            "language": {
                "url": "{{asset('')}}js/tables/datatable/datatable-Persian.json"
            },
            "columnDefs": [
                {
                    "targets": 1,
                    "searchable": false,
                    "orderable": true,
                    "data": null,
                    "render": function (data, type, full, meta) {
                        return meta.settings._iDisplayStart + meta.row + 1;
                    }
                },
                { 'visible': false, 'targets': [0] }
            ],
            paging: false,
            dom: "<'top'><'row'<'col-md-5 col-12 mt-1'B><'col-md-7 col-12 d-flex ltr-dir'<'mx-1 mt-1'l><'rtl-dir'f>>><'bottom'>rt<'row'<'col-md-5 col-12'i><'col-md-7 col-12'p>><'clear'>",
            buttons: [
                {
                    extend: 'print',
                    text: '<i class="ft-printer"></i> Print',
                    className: 'btn btn-outline-secondary',
                    title: '',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                },
                {
                    extend: 'excel',
                    text: '<i class="ft-save"></i> Exel',
                    className: 'btn btn-outline-secondary',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                },
                {
                    text: '<i class="ft-check"></i> تایید و پرداخت همه',
                    className: 'btn btn-outline-warning',
                    action: function ( e, dt, node, config ) {
                        configfinances();
                    }
                }
            ],
        });

        var multipleRowsTable = $('.alt-pagination').DataTable();
        $('.selection-deletion-row tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                tableselectionDelete.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }
        });

        $('.selection-multiple-rows tbody').on('click', 'tr', function() {
            $(this).toggleClass('selected');
        });

        function configfinances(){

            var oData = multipleRowsTable.rows('.selected').data();
            var IDs = [];
            for (var i=0; i < oData.length ;i++){
                IDs.push( oData[i][0]);
            }

            swal({
                title: "از تغییر وضعیت همه اطمینان دارید؟",
                text: "قابل برگشت و ویرایش نیست",
                type: "info",
                input: 'select',
                inputOptions: {
                    'شبا': 'شبا',
                    'کارت': 'کارت به کارت',
                    'واریزحساب': 'واریز به حساب',
                },
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#009904",
                cancelButtonText: "نه",
                preConfirm: (value) => {
                    return $.ajax({
                        url: "{{asset('').env('PanelPrefix')}}/actions/finance/all-confirm",
                        type: 'post',
                        data: {_token: "{{ csrf_token() }}",via:value,IDs:JSON.stringify(IDs)},
                    });
                }
            }).then((data) => {
                if(data.value.status==true){
                    swal({
                        title:'انجام شد!',
                        type: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.reload();
                    });
                }
                else{
                    swal("خطا",  data.value.messege  , "error");
                }
            });
        }
    </script>
@stop
