@extends('admin.layouts.master')
@section('title', 'کیف پول های در انتظار تایید')
@section('css')
    <link rel="stylesheet" type="text/css"
          href="{{asset('')}}app-assets/vendors/css/tables/datatable/datatables.min.css">
@stop

@section('content')

    <div class="row">
        <div class="card mb-4 w-100">
            <div class="card-body">
                <div class="card-title mb-0">کیف پول های در انتظار تایید</div>
                <p class="mb-4">برای حذف یا تایید و عدم تایید کیف پول، بر روی لینک کلیک کنید تا به قسمت کیف پول در پروفایل کاربر هدایت شوید.</p>

                <table class="table table-striped table-bordered alt-pagination selection-deletion-row dataex-fixh-basic w-100"
                       id="table_category">
                    <thead class='iransensbold'>
                    <tr>
                        <th class="text-center">#</th>
                        <th class="text-center">نام کاربر</th>
                        <th class="text-center">نام ارز</th>
                        <th class="text-center">آدرس کیف پول</th>
                        <th class="text-center">تاریخ و ساعت ثبت</th>
                        <th class="text-center">وضعیت</th>
                        <th class="text-center">جزئیات</th>
                    </tr>
                    </thead>
                    <tbody  class="text-center">
                    </tbody>
                </table>

            </div>
        </div>
    </div>

@stop

@section('js')
    <script src="{{asset('')}}app-assets/vendors/js/tables/datatable/datatables.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/digitbox.min.js"></script>
@stop

@section('script')
    <script>

        $('.alt-pagination').DataTable({
            "pagingType": "full_numbers",
            "scrollX": true,
            "language": {
                "url": "{{asset('')}}app-assets/vendors/js/datatable-Persian.json",
            },
            "ajax": '{{asset('').env('PanelPrefix')}}/actions/wallet/list',
            "columns": [
                { "data": "1" },
                { "data": "2" },
                { "data": "3" },
                { "data": "4" },
                { "data": "5" },
                { "data": "6" },
                { "data": "7" },
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "searchable": false,
                    "orderable": true,
                    "data": null,
                    "render": function (data, type, full, meta) {
                        return meta.settings._iDisplayStart + meta.row + 1;
                    }
                }
            ],
            "displayLength": 25,
            dom: "<'top'><'row'<'col-md-5 col-12 mt-1'B><'col-md-7 col-12 d-flex ltr-dir'<'mx-1 mt-1'l><'rtl-dir'f>>><'bottom'>rt<'row'<'col-md-5 col-12'i><'col-md-7 col-12'p>><'clear'>",
            buttons: [
                {
                    extend: 'print',
                    text: '<i class="mdi mdi-printer text-dark"> پرینت</i>',
                    className: 'btn btn-light',
                    title: '',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                },
                {
                    extend: 'excel',
                    text: '<i class="mdi mdi-file-excel text-dark"> اکسل</i>',
                    className: 'btn btn-light',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                }
            ],
            "fnDrawCallback": function(oSettings) {
                page = $('.alt-pagination').DataTable().page.info()['page'];
                if (page ==0 && $('.alt-pagination tr').length < 25) {
                    $('.dataTables_paginate,.dataTables_info').hide();

                }else
                    $('.dataTables_paginate,.dataTables_info').show();
            }
        });

        var tableselectionDelete = $('.alt-pagination').DataTable();
        $('.selection-deletion-row tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                tableselectionDelete.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }
        });


    </script>
@stop
