@extends('admin.layouts.master')
@section('title', 'کاربران')

@section('content')

    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">ادمین‌ها</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title mb-0">لیست ادمین‌های سایت</div>
                    <div>
                        <button type="button" class="btn btn-light mb-3" data-bs-toggle="modal" data-bs-target=".bs-admin-modal-lg"><i class="mdi mdi-account-plus me-1"></i>اضافه کردن ادمین</button>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap" id="myTable">
                        <thead class="table-light">
                        <tr>
                            <th>شناسه</th>
                            <th>نام و فامیل</th>
                            <th>ایمیل</th>
                            <th>موبایل</th>
                            <th>عضویت</th>
                            <th>وضعیت</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($admins as $admin)
                            <tr>
                                <td>{{$admin->id}}</td>
                                <td>{{$admin->name}}</td>
                                <td>{{$admin->email}}</td>
                                <td>{{$admin->mobile}}</td>
                                <td>{{$admin->created_at}}</td>
                                <td>
                                    @if($admin->access == 1)
                                        <span class="badge badge-soft-success">فعال</span>
                                    @else
                                        <span class="badge badge-soft-warning">غیرفعال</span>
                                    @endif
                                </td>
                                <td>
                                    @if($admin->role == 'admin')
                                        حذف غیرفعال
                                    @else
                                        <button type="button" onclick="RemoveAdmin({{$admin->id}});" class="btn action-icon text-danger"> <i class="mdi mdi-trash-can font-size-18"></i></button>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>{{$admins->links()}}
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade bs-admin-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myLargeModalLabel">اضافه کردن ادمین جدید</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form autocomplete="off" method="post" class="needs-validation" novalidate action="" enctype="multipart/form-data">
                        @csrf
                        <div class="row col-md-6 col-12 m-md-auto m-0 p-0">
                            <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                <label for="Name">نام و نام خانوادگی</label>
                                <input type="text" class="form-control" name="name" id="name" required>
                                <div class="invalid-feedback">نام و نام خانوادگی را وارد کنید</div>
                            </div>
                            <div class="col-md-6 p-0 ps-md-1 form-group mb-3">
                                <label for="firstName1">موبایل</label>
                                <input type="text" class="form-control" name="mobile" maxlength="11" id="mobile" required>
                                <div class="invalid-feedback">موبایل را وارد کنید</div>
                            </div>
                            <div class="col-md-12 p-0 form-group mb-3">
                                <label>ایمیل</label>
                                <input type="text" class="form-control text-center" name="email" id="email" required>
                                <div class="invalid-feedback">ایمیل را وارد کنید</div>
                            </div>
                            <div class="col-md-12 p-0 form-group mb-3">
                                <label>رمز عبور</label>
                                <input type="password" class="form-control text-center" name="password" id="password" required>
                                <div class="invalid-feedback">رمز عبور را وارد کنید</div>
                            </div>
                            <div class="mb-2">
                                <label class="switch switch-success">
                                    <input type="hidden" value="0" name="access_orders">
                                    <input type="checkbox" value="1" name="access_orders">
                                    <span class="ms-1">دسترسی به بخش سفارشات</span>
                                    <span class="slider"></span>
                                </label>
                            </div>
                            <div class="mb-2">
                                <label class="switch switch-success">
                                    <input type="hidden" value="0" name="access_ticket">
                                    <input type="checkbox" value="1" name="access_ticket">
                                    <span class="ms-1">دسترسی به بخش تیکت‌‌های کاربران</span>
                                    <span class="slider"></span>
                                </label>
                            </div>
                            <div class="mb-2">
                                <label class="switch switch-success">
                                    <input type="hidden" value="0" name="access_users">
                                    <input type="checkbox" value="1" name="access_users">
                                    <span class="ms-1">دسترسی به بخش کاربران</span>
                                    <span class="slider"></span>
                                </label>
                            </div>
                            <div class="mb-2">
                                <label class="switch switch-success">
                                    <input type="hidden" value="0" name="access_finance">
                                    <input type="checkbox" value="1" name="access_finance">
                                    <span class="ms-1">دسترسی به بخش مالی</span>
                                    <span class="slider"></span>
                                </label>
                            </div>
                            <div class="mb-2">
                                <label class="switch switch-success">
                                    <input type="hidden" value="0" name="access_notification">
                                    <input type="checkbox" value="1" name="access_notification">
                                    <span class="ms-1">دسترسی به بخش اطلاعیه‌ها</span>
                                    <span class="slider"></span>
                                </label>
                            </div>
                            <div class="mb-2">
                                <label class="switch switch-success">
                                    <input type="hidden" value="0" name="access_settings">
                                    <input type="checkbox" value="1" name="access_settings">
                                    <span class="ms-1">دسترسی به بخش تنظیمات</span>
                                    <span class="slider"></span>
                                </label>
                            </div>
                            <div class="col-md-4 m-auto">
                                <button type="submit" class="btn btn-primary btn-block">ثبت درخواست
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@stop

@section('script')

    <script>
        $(document).ready(function () {
            $('form').ajaxForm({
                complete: function (data) {
                    data = data.responseJSON;
                    $('form').removeClass('disable-block');
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                            onClose: () => {
                                location.href = "{{asset('').env('PanelPrefix')}}/admins";
                            }
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                        $('.progress').fadeOut();
                    }
                    $('form button').removeAttr('disabled');
                }
            });
        });

        function RemoveAdmin(adminId){
            swal.fire({
                title: "از حدف اطمینان دارید؟",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#0c69c2",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.ajax({
                        url: "{{asset('').env('PanelPrefix')}}/admins/" + adminId + "/remove",
                        type: 'POST',
                        data: {_token: "{{ csrf_token() }}"},
                    });
                }
            }).then((data) => {
                if(data.value.status==true){
                    swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: 'ادمین با موفقیت حذف شد!',
                        onClose: () => {
                            location.href = "{{asset('').env('PanelPrefix')}}/admins";
                        }
                    });
                }
                else{
                    swal.fire({
                        icon: 'success',
                        title: "انجام شد!",
                        html: data.message,
                        confirmButtonText: "تایید",
                    })
                    $('.progress').fadeOut();
                }
            });
        }
    </script>
@stop
