<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
<!-- BEGIN: Head-->
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="description" content="">
    <title>@yield('title')</title>
    <link rel="shortcut icon" type="image/x-icon" href="{{asset('images/logo/favicon.svg')}}">
    <link href="https://fonts.googleapis.com/css?family=Muli:300,300i,400,400i,600,600i,700,700i%7CComfortaa:300,400,700" rel="stylesheet">

    <!-- Bootstrap Css -->
    <link href="{{ asset('css/bootstrap-rtl.min.css') }}" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <link href="{{ asset('/assets/libs/sweetalert2/sweetalert2.min.css') }}" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <link href="{{ asset('libs/toastr.min.css') }}" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="{{ asset('css/icons.min.css') }}" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="{{ asset('css/app-rtl.min.css') }}" id="app-style" rel="stylesheet" type="text/css" />
    <!-- Fonts Css-->
    <link href="{{ asset('css/font_iransans.css') }}" id="app-style" rel="stylesheet" type="text/css" />
</head>

<body class="auth-body-bg" style="font-family: IRANSans !important;">

<div>
    <div class="container-fluid p-0">
        @yield('content')
    </div>
</div>

<!-- JAVASCRIPT -->
<script src="{{ asset('js/jquery.min.js') }}" type="text/javascript"></script>
<script src="{{ asset('js/bootstrap.bundle.min.js') }}" type="text/javascript"></script>
<script src="{{ asset('js/metisMenu.min.js') }}" type="text/javascript"></script>
<script src="{{ asset('js/simplebar.min.js') }}" type="text/javascript"></script>
<script src="{{ asset('js/waves.min.js') }}" type="text/javascript"></script>
<script src="{{ asset('js/sweetalert2.min.js') }}" type="text/javascript"></script>
<script src="{{ asset('js/jquery.form.min.js') }}" type="text/javascript"></script>
<script src="{{ asset('libs/jquery.blockUI.js') }}"></script>
<script src="{{ asset('libs/toastr.min.js') }}"></script>

<!-- App js -->
<script src="{{ asset('js/app.js') }}"></script>
<script src="{{ asset('js/arzland.js') }}"></script>
@yield('js')
@yield('script')

@if(Session::has('Success'))
    <script>
        if(!$(".alert-card").length)
            toastr.success("{{ Session::get('Success') }}", "انجام شد!", {
                positionClass: "toast-top-center",
                progressBar: !0,
                timeOut:6000,closeButton:!0
            })
    </script>
@endif
@if(Session::has('Error'))
    <script>
        if(!$(".alert-card").length)
            toastr.error("{{ Session::get('Error') }}", "خطا!", {
                positionClass: "toast-top-center",
                progressBar: !0,
                timeOut:10000,closeButton:!0
            })
    </script>
@endif
@if(Session::has('Info'))
    <script>
        if(!$(".alert-card").length)
            toastr.info("{{ Session::get('Info') }}", "در دست بررسی!", {
                positionClass: "toast-top-center",
                opacity:1,
                progressBar: !0,
                timeOut:6000,closeButton:!0
            })
    </script>
@endif

</body>
</html>
