@extends('admin.layouts.master')
@section('title', 'محصولات پول الکترونیک')
@section('css')
    <style>
        .image-input {
            position:relative;
            display:inline-block;
            border-radius:.42rem;
            background-repeat:no-repeat;
            background-size:cover
        }
        .image-input.image-input-outline .image-input-wrapper {
            box-shadow:0 .5rem 1.5rem .5rem rgba(0,0,0,.075)
        }
        .image-input .image-input-wrapper {
            border-radius:2.42rem;
            background-repeat:no-repeat;
            background-size:cover
        }
        .image-input .image-input-wrapper img {
            border-radius:2.42rem
        }
        .btn.btn-white.btn-shadow {
            box-shadow:0 9px 16px 0 rgba(24,28,50,.25)!important
        }
        .btn.btn-icon.btn-circle {
            border-radius:50%
        }
        .btn.btn-icon.btn-xs {
            height:24px;
            width:24px;
            display:flex;
            justify-content:center;
            align-items:center;
            background:#fff
        }
        .btn:not(:disabled):not(.disabled) {
            cursor:pointer
        }
        .image-input [data-action=change] {
            cursor:pointer;
            position:absolute;
            left:-10px;
            top:-4px
        }
        .image-input [data-action=cancel],
        .image-input [data-action=remove] {
            position:absolute;
            left:-10px;
            bottom:4px
        }
        .image-input [data-action=change] input {
            width:0!important;
            height:0!important;
            overflow:hidden
        }
    </style>
@stop
@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">محصولات پول الکترونیک</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title">ارزها</div>
                    <div>
                        <a class="btn btn-light" data-bs-toggle="modal" data-bs-target=".new-currency"><i class="mdi mdi-cart-arrow-right me-1"></i>اضافه کردن ارز جدید</a>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap">
                        <thead class="table-light">
                            <tr>
                                <th>لوگو ارز</th>
                                <th>نام ارز</th>
                                <th>قیمت خرید</th>
                                <th>قیمت فروش</th>
                                <th>موجودی</th>
                                <th>وضعیت</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                        @foreach($digital as $item)
                            <tr>
                                <td><img src="{{asset($item->logo)}}" alt="product-img" title="product-img" class="avatar-md" /></td>
                                <td><h5 class="font-size-14 text-truncate">{{$item->name_fa}}</h5></td>
                                <td>{{$item->buy_money}}<small class="ms-1">تومان</small></td>
                                <td>{{$item->sell_money}}<small class="ms-1">تومان</small></td>
                                <td>{{$item->quantity}}</td>
                                @if($item->approved)
                                    <td class="text-success">روشن</td>
                                @else
                                    <td class="text-danger">خاموش</td>
                                @endif
                                <td>
                                    <div class="d-flex gap-3">
                                        <button  class="btn btn-primary text-success" data-bs-toggle="modal" data-bs-target=".currency-{{$item->id}}-edit"><i class="mdi mdi-pencil font-size-18"></i></button >
                                        @if($item->approved)
                                            <button onclick="activeCurrency('?type=update&status=0&id={{$item->id}}')" type="button" class="btn btn-warning">خاموش</button>
                                        @else
                                            <button onclick="activeCurrency('?type=update&status=1&id={{$item->id}}')" type="button" class="btn btn-success">روشن</button>
                                        @endif
                                        <button onclick="activeCurrency('?type=delete&id={{$item->id}}')" type="button" class="btn btn-danger"><i class="mdi mdi-delete font-size-18"></i></button>
                                    </div>
                                </td>
                            </tr>
                            <div class="modal fade currency-{{$item->id}}-edit" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h4 class="mb-sm-0 font-size-18">ویرایش کردن پول الکترونیک</h4>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="card">
                                                    <div class="card-body">
                                                        <form autocomplete="off" id="edit" method="POST" action="?currency_id={{$item->id}}" enctype="multipart/form-data">
                                                            @csrf
                                                            <div class="row">
                                                                <div class="col-md-6 mb-3">
                                                                    <label class="form-label">نام انگلیسی ارز</label>
                                                                    <input type="text" class="form-control" id="edit_name" name="name" value="{{$item->name}}">
                                                                </div>
                                                                <div class="col-md-6 mb-3">
                                                                    <label class="form-label">نام فارسی ارز</label>
                                                                    <input type="text" class="form-control" id="edit_name_fa" name="name_fa" value="{{$item->name_fa}}">
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6 mb-3">
                                                                    <label class="form-label">آدرس کیف پول</label>
                                                                    <input type="text" class="form-control" id="wallet" name="wallet" value="{{$item->wallet}}">
                                                                </div>
                                                                <div class="col-md-6 mb-3">
                                                                    <label class="form-label">موجودی</label>
                                                                    <input type="text" class="form-control" id="edit_quantity" name="quantity" value="{{$item->quantity}}">
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6 mb-3">
                                                                    <label class="form-label">قیمت خرید ارز (صرافی به کاربر)</label>
                                                                    <input type="text" class="form-control" id="edit_buy_money" name="buy_money" value="{{$item->buy_money}}">
                                                                </div>
                                                                <div class="col-md-6 mb-3">
                                                                    <label class="form-label">قیمت فروش ارز (کاربر به صرافی)</label>
                                                                    <input type="text" class="form-control" id="edit_sell_money" name="sell_money" value="{{$item->sell_money}}">
                                                                </div>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="form-label">توضیحات ارز (در صفحه خرید و فروش قرار خواهد گرفت)</label>
                                                                <textarea rows="4" class="form-control" name="description">{{$item->description}}</textarea>
                                                            </div>
                                                            <hr class="my-5">
                                                            <div class="row mb-4">
                                                                <label for="horizontal-password-input" class="col-sm-3 col-form-label mb-3">تصویر آیکون ارز</label>
                                                                <div class="col-sm-9">
                                                                    <div class="image-input image-input-outline image-input-changed">
                                                                        <div class="image-input-wrapper bg-light">
                                                                            <img id="picture" src="{{ asset('images/product/defult.png') }}" width="320px" />
                                                                        </div>
                                                                        <label class="btn btn-xs btn-icon btn-circle btn-white btn-shadow" data-action="change" data-toggle="tooltip" title="" data-original-title="تغییر آواتار">
                                                                            <i class="fa fa-pen icon-sm text-muted"></i>
                                                                            <input type="file" name="logo">
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <hr class="my-5">
                                                            <div class="my-4 text-center">
                                                                <button type="submit" class="btn btn-primary">اضافه کردن محصول</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade new-currency" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="mb-sm-0 font-size-18">اضافه کردن پول الکترونیک</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between mb-4">
                                    <div>جهت اضافه کردن پول الکترونیک در سایت، اطلاعات زیر را به دقت پر کنید.</div>
                                </div>
                                <form autocomplete="off" id="formId" method="POST" action="?type=insert" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">نام انگلیسی ارز</label>
                                            <input type="text" id="name" class="form-control" name="name" onkeyup="success(this)">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">نام فارسی ارز</label>
                                            <input type="text" id="name_fa" class="form-control" name="name_fa" onkeyup="success(this)">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">آدرس کیف پول</label>
                                            <input type="text" id="wallet" class="form-control" name="wallet" onkeyup="success(this)">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">موجودی</label>
                                            <input type="text" class="form-control" id="quantity" name="quantity" onkeyup="success(this)">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">قیمت خرید ارز (صرافی به کاربر)</label>
                                            <input type="text" class="form-control" id="buy_money" name="buy_money" onkeyup="success(this)">
                                        </div>
                                        <div class="col-md-6 mb-3">
                                            <label class="form-label">قیمت فروش ارز (کاربر به صرافی)</label>
                                            <input type="text" class="form-control" id="sell_money" name="sell_money" onkeyup="success(this)">
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">توضیحات ارز (در صفحه خرید و فروش قرار خواهد گرفت)</label>
                                        <textarea rows="4" class="form-control" id="description" name="description" onkeyup="success(this)"></textarea>
                                    </div>
                                    <hr class="my-5">
                                    <div class="row mb-4">
                                        <label for="horizontal-password-input" class="col-sm-3 col-form-label mb-3">تصویر آیکون ارز</label>
                                        <div class="col-sm-9">
                                            <div class="image-input image-input-outline image-input-changed">
                                                <div class="image-input-wrapper bg-light" id="logo">
                                                    <img id="picture" src="{{ asset('images/product/defult.png') }}" width="320px" />
                                                </div>
                                                <label class="btn btn-xs btn-icon btn-circle btn-white btn-shadow" data-action="change" data-toggle="tooltip" title="" data-original-title="تغییر آواتار">
                                                    <i class="fa fa-pen icon-sm text-muted"></i>
                                                    <input type="file" name="logo" id="logo">
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="my-5">
                                    <div class="mb-3">
                                        <div class="col-md-6">
                                            <input type="checkbox" value="1" name="status" checked>
                                            <label class="form-label">وضعیت فعال بودن خرید و فروش</label>
                                        </div>
                                    </div>
                                    <div class="my-4 text-center">
                                        <button type="submit" class="btn btn-primary">اضافه کردن محصول</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
@section('script')
    <script>
        $(document).ready(function () {
            $('.image-input input').change(function() {
                var prev = $(this).parent().parent().find('img#picture');
                var reader = new FileReader();
                reader.onload = function (e) {
                    prev.attr('src', e.target.result);
                }
                reader.readAsDataURL(this.files[0]);
            });

            $('form').submit(function (e) {
                e.preventDefault();
                const form = $(this);
                let validation = true;
                $( '#' + form.attr('id') + ' input').each(function(){
                        var input = $(this);
                        if(input.val() === '') {
                            validation = false;
                            document.getElementById(input.attr('id')).classList.add('border-danger')
                        }
                    }
                );
                if (validation) {
                    $.ajax({
                        type: form.attr('method'),
                        url: form.attr('action'),
                        processData: false,
                        contentType: false,
                        data: new FormData(document.getElementById(form.attr('id'))),
                        beforeSend: function () {
                            loading();
                        },
                        success: function (data) {
                            if (data.message) {
                                swal.fire({
                                    icon: 'success',
                                    title: "انجام شد",
                                    html: data.message,
                                    confirmButtonText: "تایید",
                                }).then(function () {
                                    location.reload();
                                });
                            }
                        },
                        error: function (data) {
                            swal.fire({
                                icon: 'error',
                                title: "توجه",
                                html: data.message,
                                confirmButtonText: "تایید",
                            }).then(function () {
                                location.reload();
                            })
                        },
                    });
                }
            })

        });

        function success(e) {
            if(e.getAttribute('id') !== 'description' && e.getAttribute('id') !== 'name_fa' && e.getAttribute('id') !== 'name' && e.getAttribute('id') !== 'wallet') {
                e.value = e.value.replace(/[^0-9\.]/g,'');
            }
            if (e.getAttribute('id') === 'buy_money' || e.getAttribute('id') === 'sell_money') {
                if(e.value)
                    e.value = parseInt(e.value).toLocaleString('en-US')
            }
            const element = document.getElementById(e.getAttribute('id'));
            element.classList.remove('border-danger');
            element.classList.add('border-success');
        }

        function activeCurrency(url) {
            $.ajax({
                type: 'GET',
                url: url,
                beforeSend: function () {
                    loading();
                },
                success: function (data) {
                    if (data.message) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            location.reload();
                        });
                    }
                },
                error: function (data) {
                    swal.fire({
                        icon: 'error',
                        title: "توجه",
                        html: data.message,
                        confirmButtonText: "تایید",
                    }).then(function () {
                        location.reload();
                    })
                },
            });
        }
    </script>
@stop
