@extends('admin.layouts.master')
@section('title', 'واریز اتوماتیک')
@section('css')
    <link rel="stylesheet" type="text/css"
          href="{{asset('')}}app-assets/vendors/css/tables/datatable/datatables.min.css">
    <link rel="stylesheet" href="{{asset('')}}app-assets/css/plugins/persian-datepicker.min.css">
@stop

@section('content')

<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before" style="background:#1C2135"></div>
        <div class="content-header row">
        </div>
        <div class="content-body">
            <div class="row">
                <div class="col-12">
                    <div class="card mb-4 w-100">
                        <div class="card-body">
                            <div class="card-title mb-0">تراکنش های واریز اتوماتیک از فینوتک</div>
                            <p class="mb-4">تمام واریز های اتوماتیک از فینوتک را مشاهده میکنید</p>
                            <div class="row">

                                <div class="col-md-2 form-group mb-md-0 offset-md-4">
                                    <label class="ul-form__label">از تاریخ</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control round text-center font-small-3 px-0" id="date_start" placeholder="تاریخ">
                                        <div class="input-group-append cursor-pointer" id="date1">
                                            <span class="input-group-text badge-primary round px-1"><i class="feather icon-calendar"></i></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-2 form-group mb-md-0">
                                    <label class="ul-form__label">تا تاریخ</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control round text-center font-small-3 px-0" id="date_stop" placeholder="تاریخ">
                                        <div class="input-group-append cursor-pointer" id="date2">
                                            <span class="input-group-text badge-primary round px-1" id="basic-addon2"><i class="feather icon-calendar"></i></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="clearfix w-100"></div>
                                <div class="col-md-2 form-group mb-md-0 mt-2 offset-md-3">
                                    <label>مبلغ از</label>
                                    <input type="text" class="form-control round text-center text-13 ltr-dir" id="amount_start" placeholder="مبلغ از">
                                </div>
                                <div class="col-md-2 form-group mb-md-0 mt-2">
                                    <label>تا مبلغ</label>
                                    <input type="text" class="form-control round text-center text-13 ltr-dir" id="amount_stop" placeholder="تا مبلغ">
                                </div>
                                <div class="col-md-2 mt-md-2 ">
                                    <label for="picker1"></label>
                                    <button class="btn btn-primary btn-round btn-block" onclick="search()">فیلتر</button>
                                </div>
                            </div>



                            <hr width="30%">
                            <table class="table table-striped table-bordered alt-pagination selection-deletion-row dataex-fixh-basic w-100"
                                   id="table_category">
                                <thead class='iransensbold'>
                                <tr>
                                    <th class="text-center">#</th>
                                    <th class="text-center">نام کاربر</th>
                                    <th class="text-center">شماره شبا</th>
                                    <th class="text-center ">نوع</th>
                                    <th class="text-center">مبلغ</th>
                                    <th class="text-center">تاریخ و ساعت واریز</th>
                                </tr>
                                </thead>
                                <tbody  class="text-center">
                                </tbody>
                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>



        <!-- Modal -->
        <div class="modal fade" id="Info" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">اطلاعات تراکنش</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center">
                            <div class="spinner-grow" style="width: 5rem; height: 5rem;" role="status">
                                <span class="sr-only">Loading...</span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">بستن</button>
                    </div>
                </div>
            </div>
        </div>


@stop
@section('js')
    <script src="{{asset('')}}js/tables/datatable/datatables.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/persian-date.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/persian-datepicker.min.js" type="text/javascript"></script>
@stop
@section('script')
    <script>
        var url =$('meta[name=url]').attr("content");

        $('#amount_start,#amount_stop').digitbox({separator:',', grouping:1, truevalue:1});


        $('#date1').persianDatepicker({
            altField: '#date_start',
            altFormat: 'YYYY/MM/DD HH:mm',
            initialValue: false,
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            timePicker: {
                enabled: true,
                second:{
                    enabled: false,
                }
            }
        });

        $('#date2').persianDatepicker({
            altField: '#date_stop',
            altFormat: 'YYYY/MM/DD HH:mm',
            initialValue: false,
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            timePicker: {
                enabled: true,
                second:{
                    enabled: false,
                }
            }
        });


        $('.alt-pagination').DataTable({
            "pagingType": "full_numbers",
            "scrollX": true,
            "language": {
                "url": "{{asset('')}}app-assets/vendors/js/datatable-Persian.json",
            },
            "ajax": url + '/finotech-send-money/list',
            "order": [[ "5", 'desc' ]],
            "processing": true,
            "serverSide": true,
            "columns": [
                { "data": "0" },
                { "data": function ( data) {return data['1']+' '+data['22']}},
                { "data": "2" },
                { "data": "3" },
                { "data": "4" },
                { "data": "5" },
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "searchable": false,
                    "orderable": true,
                    "data": null,
                    "render": function (data, type, full, meta) {
                        return meta.settings._iDisplayStart + meta.row + 1;
                    }
                }
            ],
            "displayLength": 25,
            dom: "<'top'><'row'<'col-md-6 col-12 mt-1'B><'d-flex col-md-6 col-12 '<'w-100'f> l>><'bottom'>rt<'row'<'col-md-5 col-12'i><'col-md-7 col-12'p>><'clear'>",
            buttons: [
                {
                    extend: 'print',
                    text: '<span class="feather icon-printer"></span> Print',
                    className: 'btn btn-outline-primary round ',
                    title: '',
                    exportOptions: {
                        columns: [0,2,3,4,5,6, {'data': 'batch_notes', "render": function ( data, type, row, meta ) { return data },}]
                    }
                },
                {
                    extend: 'excelHtml5',
                    text: '<span class="feather icon-save"></span> Exel',
                    className: 'btn btn-outline-primary round ',
                    exportOptions: {
                        columns: [0,2,3,4,5,6, {'data': 'batch_notes', "render": function ( data, type, row, meta ) { return data },}]
                    }
                },
            ]
        });

        var tableselectionDelete = $('.alt-pagination').DataTable();
        $('.selection-deletion-row tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                tableselectionDelete.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }
        });

        function search(){
            var tbl = $('.alt-pagination').DataTable();
            tbl.ajax.url(url + "/finotech-send-money/list?date_start="+ $("#date_start").val()
                + "&date_stop="+ $("#date_stop").val() + "&amount_start="+ $("#amount_start").val()+ "&amount_stop="+ $("#amount_stop").val()).load();
        }



        function Info(id){
            $('#Info .modal-body').load(url + "/finances/"+id+'/?'+ new Date().getTime()).fadeIn();
        }
        $('#Info').on('hidden.bs.modal', function () {
            $('#Info .modal-body').html('<div class="text-center"><span class="spinner-glow spinner-glow-info"></span></div>');
        })

    </script>
@stop
