@extends('admin.layouts.master')
@section('title', 'معرفی و درآمد')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">بازاریابی</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-3">
            <div class="card mini-stats-wid">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3 align-self-center">
                            <i class="mdi mdi-account-plus h2 text-success mb-0"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="text-muted mb-2">تعداد کاربران معرفی شده</p>
                            <h5 class="mb-0">{{ count($result['invitationUser']) }}</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-3">
            <div class="card mini-stats-wid">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3 align-self-center">
                            <i class="mdi mdi-order-bool-ascending h2 text-warning mb-0"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="text-muted mb-2"> تعداد کل سفارشات پورسانتی</p>
                            <h5 class="mb-0">{{ $result['orders'] }}</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-3">
            <div class="card mini-stats-wid">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3 align-self-center">
                            <i class="mdi mdi-cash h2 text-info mb-0"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="text-muted mb-2"> مبلغ کل پروسانت</p>
                            <h5 class="mb-0">{{ number_format($result['amount']) }}</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-3">
            <div class="card mini-stats-wid">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3 align-self-center">
                            <i class="mdi mdi-cash-refund h2 text-info mb-0"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="text-muted mb-2"> میانگین پورسانت هر سفارش</p>
                            <h5 class="mb-0">{{$result['amount'] ? number_format($result['amount'] / $result['orders']) : 0}}</h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title mb-0">تیکت‌ها کاربران</div>
                </div>
                <ul class="nav nav-tabs nav-tabs-custom nav-justified" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#home1" role="tab">
                            <span>لیست کاربران معرفی شده</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#profile1" role="tab">
                            <span>لیست واریزی های پورسانت به کیف پول</span>
                        </a>
                    </li>
                </ul>
                <div class="tab-content p-3 text-muted">
                    <div class="tab-pane active" id="home1" role="tabpanel">
                        <div class="table-responsive mt-3">
                            <div class="col-md-12">
                                <div class="row justify-content-between">
                                    <div class="col-md-3">
                                        <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                                    </div>
                                    <div class="col-md-3 d-flex">
                                        <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                                        <button class="btn btn-success mb-3"><i class="dripicons-information font-size-14 d-flex"></i></button>
                                    </div>
                                </div>
                            </div>

                            <table class="table align-middle mb-0 table-nowrap" id="myTable">
                                <thead class="table-light">
                                <tr>
                                    <th>شناسه</th>
                                    <th>نام و فامیل</th>
                                    <th>کدملی</th>
                                    <th>موبایل</th>
                                    <th>عضویت</th>
                                    <th>موجودی</th>
                                    <th>وضعیت</th>
                                </tr>
                                </thead>
                                <tbody>
{{--                                @php(dd($result['invitationUser']))--}}
                                @if(count($result)>0)
                                    @foreach($result['invitationUser'] as $item)
                                        <tr>
                                            <td>{{ $item->id }}</td>
                                            <td>{{ $item->name . ' ' . $item->family }}</td>
                                            <td>{{ $item->code_meli }}</td>
                                            <td>{{ $item->mobile }}</td>
                                            <td>{{ $item->created_at }}</td>
                                            <td>{{ number_format($item->wallet) }}</td>
                                            <td>
                                                @if($item->auth_img_confirm == 1 & $item->selfie_img_confirm == 1)
                                                    <span class="badge badge-soft-success">تایید شده</span>
                                                @else
                                                    <span class="badge badge-soft-warning">تایید نشده</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td class="text-center" colspan="7">هیچ داده ای در جدول وجود ندارد</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>{{--{{$tickets->links()}}--}}
                        </div>
                    </div>
                    <div class="tab-pane" id="profile1" role="tabpanel">
                        <div class="table-responsive mt-3">
                            <div class="col-md-12">
                                <div class="row justify-content-between">
                                    <div class="col-md-3">
                                        <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                                    </div>
                                    <div class="col-md-3 d-flex">
                                        <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                                        <button class="btn btn-success mb-3"><i class="dripicons-information font-size-14 d-flex"></i></button>
                                    </div>
                                </div>
                            </div>

                            <table class="table align-middle mb-0 table-nowrap" id="myTable">
                                <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>نام سفارش دهنده</th>
                                    <th>نوع سفارش</th>
                                    <th>مبلغ سفارش</th>
                                    <th>مبلغ پورسانت</th>
                                    <th>تاریخ</th>
                                </tr>
                                </thead>
                                <tbody>
                                {{--@php(dd($invitations))--}}
                                @if(count($invitations)>0)
                                    @foreach($invitations as $invitation)
                                        <tr>
                                            <td>{{ $invitation->id }}</td>
                                            <td>{{ $invitation->name . ' ' . $invitation->family }}</td>
                                            <td>{{ $invitation->orders_model }}</td>
                                            <td>{{ number_format($invitation->user_amount) }}</td>
                                            <td>{{ number_format($invitation->amount) }}</td>
                                            <td>{{ $invitation->created_at }}</td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td class="text-center" colspan="7">هیچ داده ای در جدول وجود ندارد</td>
                                    </tr>
                                @endif
                                </tbody>
                            </table>{{--{{$tickets->links()}}--}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
