@extends('admin.layouts.master')
@section('title', 'فروشگاه')

@section('content')
    <div id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">لیست سفارشات</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="card-title mb-3">سفارشات</div>
                        <div class="row justify-content-between">
                            <div class="col-md-3">
                                <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table align-middle table-nowrap table-check">
                                <thead class="table-light">
                                <tr>
                                    <th class="align-middle">شناسه</th>
                                    <th class="align-middle">نام خریدار</th>
                                    <th class="align-middle">تاریخ</th>
                                    <th class="align-middle">مبلغ پرداختی</th>
                                    <th class="align-middle">وضعیت سفارش</th>
                                    <th class="align-middle">روش پرداخت</th>
                                    <th class="align-middle">مشاهده جزییات</th>
                                </tr>
                                </thead>
                                <tbody>
                                    @if( isset($orders))
                                        @foreach( $orders as $order )
                                            <tr>
                                                <td><span class="text-body fw-bold">{{ $order->id }}</span></td>
                                                <td><a href="{{ asset('').env('PanelPrefix') }}/users/{{ $order->user->id }}">{{ $order->user->name . ' ' . $order->user->family }}</a></td>
                                                <td>{{ $order->date }}</td>
                                                <td>{{ number_format($order->final_price) }}<small class="ms-1">تومان</small></td>
                                                <td>
                                                    @if( $order->status == 'payment-confirm' )
                                                        <span class="badge badge-pill badge-soft-success font-size-12">پرداخت موفق</span>
                                                    @elseif( $order->status == 'payment-pending' )
                                                        <span class="badge badge-pill badge-soft-warning font-size-12">در انتظار پرداخت</span>
                                                    @elseif( $order->status == 'payment-cancel' )
                                                        <span class="badge badge-pill badge-soft-danger font-size-12">پرداخت ناموفق</span>
                                                    @elseif( $order->status == 'done' )
                                                        <span class="badge badge-pill badge-soft-success font-size-12">تکمیل شده</span>
                                                    @elseif( $order->status == 'cart' )
                                                        <span class="badge badge-pill badge-soft-warning font-size-12">سبد خرید</span>
                                                    @elseif( $order->status == 'canceled' )
                                                        <span class="badge badge-pill badge-soft-danger font-size-12">لغو شده</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if( $order->payment_method == 'wallet' )
                                                        <span>کیف پول</span>
                                                    @endif
                                                </td>
                                                <td>
                                                    <!-- Button trigger modal -->
                                                    <button v-on:click="getDetails({{ $order->id }})" type="button" class="btn btn-primary btn-sm btn-rounded">
                                                        مشاهده
                                                    </button>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                            {{ $orders->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal fade orderdetailsModal" tabindex="-1" role="dialog" aria-labelledby="orderdetailsModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id=orderdetailsModalLabel">جزییات سفارش</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p class="mb-2">شناسه سفارش: <span class="text-primary">@{{ order.id }}</span></p>
                        <p class="mb-2">سفارش دهنده:
                            <span class="text-primary">
                                <a :href="href">
                                    @{{ order.userName + ' ' + order.userFamily }}
                                </a>
                            </span>
                        </p>
                        <p class="mb-2">تاریخ: <span>@{{ order.date }}</span></p>
                        <p class="mb-2">وضعیت سفارش:
                            <span v-if="order.status === 'payment-confirm'" class="badge bg-success">پرداخت موفق</span>
                            <span v-if="order.status === 'payment-pending'" class="badge bg-warning">در انتظار پرداخت</span>
                            <span v-if="order.status === 'payment-cancel'" class="badge bg-danger">پرداخت ناموفق</span>
                            <span v-if="order.status === 'done'" class="badge bg-success">تکمیل شده</span>
                            <span v-if="order.status === 'cart'" class="badge bg-warning">سبد خرید</span>
                            <span v-if="order.status === 'canceled'" class="badge bg-danger">لغوشده</span>
                        </p>
                        <p class="mb-4">روش پرداخت:
                            <span v-if="order.payment_method === 'wallet'">کیف پول</span>
                        </p>

                        <div class="table-responsive mb-3">
                            <table class="table align-middle table-nowrap">
                                <thead>
                                <tr>
                                    <th scope="col">محصول</th>
                                    <th scope="col">نام محصول</th>
                                    <th scope="col">قیمت</th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <th scope="row">
                                            <div>
                                                <img :src="image" alt="pic" class="avatar-sm">
                                            </div>
                                        </th>
                                        <td>
                                            <div>
                                                <h5 class="text-truncate font-size-14">@{{ order.productTitle }}</h5>
                                            </div>
                                        </td>
                                        <td>@{{ order.price }}<small class="ms-1">تومان</small></td>
                                    </tr>
                                    <tr>
                                        <td colspan="2">
                                            <h6 class="m-0 text-right">هزینه ارسال:</h6>
                                        </td>
                                        <td>
                                            <span v-if="order.delivery_price == 0">رایگان</span>
                                            <span v-if="order.delivery_price != 0">@{{ order.delivery_price }}</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2">
                                            <h6 class="m-0 text-right">مجموع:</h6>
                                        </td>
                                        <td>@{{ order.final_price }}<small class="ms-1">تومان</small></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-1">
                            <label class="mb-1 font-weight-bold">توضیحات شما برای کاربر</label>
                            <p class="text-muted mb-2">شما می توانید اطلاعات مورد نیاز برای محصول مانند کد لایسنس و یا کدرهگیری پست محصول را برای کاربر در قسمت پایین بنویسید تا کاربر از بخش سفارشات مشاهده کند.</p>
                            <textarea v-model="note" name="note" class="form-control" rows="3" :disabled="status != 'payment-confirm'"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer" v-if="status == 'payment-confirm'">
                        <button v-on:click="submitNote(note)" type="submit" class="btn btn-success" data-bs-dismiss="modal" :disabled="note == ''">تکمیل سفارش</button>
                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">بستن</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('script')
    <script src="{{ asset('js/vue.min.js') }}"></script>
    <script>
        const vue = new Vue({
            el: '#app',
            data: {
                order: {},
                href: '',
                image: '',
                note: '',
                status: ''
            },
            methods: {
                getDetails: function (orderId) {
                    fetch("{{ asset('').env('PanelPrefix') }}/shop-orders/" + orderId, {
                        method: 'GET'
                    })
                    .then(res => {
                        return res.json();
                    })
                    .then(data => {
                        this.order = data.data;
                        $('.orderdetailsModal').modal('toggle');
                        this.href   = "{{ asset('').env('PanelPrefix') }}/users/" + this.order.userId;
                        this.image  = "{{ asset('') }}" + this.order.productImage;
                        this.note   = this.order.admin_note == null ? '' : this.order.admin_note;
                        this.status = this.order.status;
                    })
                },
                submitNote: function (note) {
                    fetch("{{ asset('').env('PanelPrefix') }}/shop-orders/note?id=" + this.order.id + '&note=' + this.note, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'Accept': 'application/json',
                            'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        },
                    })
                    .then(res => {
                        return res.json();
                    }).then((res) => {
                        if (res.status) {
                            swal.fire({
                                icon: 'success',
                                title: "انجام شد",
                                html: res.message,
                                confirmButtonText: "تایید",
                                onClose: () => {
                                    location.href = "{{ asset('').env('PanelPrefix') }}/shop-orders";
                                }
                            });
                        }else {
                            swal.fire({
                                icon: 'error',
                                title: "توجه",
                                html: res.message,
                                confirmButtonText: "تایید",
                            })
                            $('.progress').fadeOut();
                        }
                    })
                }
            }
        })
    </script>
@stop
