@extends('admin.orders.single')

@section('orders_model')
    <img src="{{asset('')}}app-assets/images/currency/PSVOUCHERS.png"
         style="position: absolute;width: 13%;left: 0;top: 20px;">
    <hr width="60%">
    <p>فهرست محصولات / خدمات درخواستی</p>
    <div class="table-responsive">
        <table class="table table-bordered">
            <thead class="">

            <tr>
                <th class="text-center">#</th>
                <th class="text-center w-60">شرح</th>
                <th class="text-center">مقدار / تعداد</th>
                <th class="text-center">قیمت واحد</th>
                <th class="text-center">مبلغ کل</th>
            </tr>
            </thead>
            <tbody class="text-center">
            <tr>
                <td scope="row" class="sans-serif">1</td>
                <td>{{$result->order->detail->type .' '. $result->order->detail->title}}</td>
                <td>{{$result->order->detail->amount_dollar}}{{$result->order->detail->dollar}} </td>
                <td>{{number_format($result->orders_model->price_dollar)}}</td>
                <td>{{number_format($result->orders_model->amount_rial)}}</td>
            </tr>
            <tr class="border-0">
                <th class="border-0"></th>
            </tr>
            <tr>
                <td class="border-0"></td>
                <th class="w-60">کد ووچرز</th>
                <td colspan="4" class="@if(isset($result->orders_model->vouchercode))sans-serif @endif cursor-pointer"
                    data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                    <i class="ft-copy"></i>
                    <span>{{$result->orders_model->vouchercode  ?? 'هنوز پرداخت کاربر تایید نشده است'}}</span>
                </td>
            </tr>
            @if(isset($result->order->payment_tracking))
                <tr>
                    <td class="border-0"></td>
                    <th scope="row">کد پیگیری درگاه پرداخت</th>
                    <td colspan="4" class="sans-serif">
                        <span>{{$result->order->payment_tracking}}</span>
                    </td>
                </tr>
            @endif
            </tbody>
        </table>
    </div>


    <!-- Modal -->
    <div class="modal fade" id="transfer_dollar" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">تایید پرداخت و انتقال ارز به کاربر</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>مقدار ارز در فیلد آخر به صورت اتوماتیک کد ووچرش ایجاد میشود و در صفحه سفارش شما و کاربر قابل مشاهده است.</p>
                    <form id="PSVouchers" autocomplete="off" method="post" class="needs-validation" novalidate>
                        @csrf

                        <div class="row col-md-12 col-12 m-md-auto m-0 p-0">
                            <div class="col-md-6 p-0 pr-md-1 form-group">
                                <label for="firstName1">قیمت هر ارز هنگام ثبت سفارش</label>
                                <input type="text" class="form-control round text-center ltr-dir"
                                       value="{{number_format($result->orders_model->price_dollar)}}" disabled>
                            </div>
                            <div class="col-md-6 p-0 pr-md-1 form-group">
                                <label for="total_amount">کل مبلغ پرداختی</label>
                                <input type="text" class="form-control round text-center ltr-dir" name="total_amount" id="total_amount"
                                       placeholder="مبلغ کل پرداختی" value="{{number_format($result->order->amount)}}"
                                       required>
                                <div class="invalid-feedback">کل مبلغ پرداختی را درج کنید</div>
                            </div>
                            <div class="col-md-12 p-0 pr-md-1 form-group">
                                <label for="amount_dollar">ارز معادل مبلغ پرداخت جهت انتقال</label>
                                <input type="text" class="form-control round text-center ltr-dir" name="amount_dollar" id="amount_dollar"
                                       placeholder="ارز معادل مبلغ پرداخت" value="{{$result->order->detail->amount_dollar}}" required>
                                <div class="invalid-feedback">ارز معادل مبلغ پرداخت را درج کنید</div>
                            </div>


                            <div class="col-md-5 m-auto">
                                <button type="button" onclick="transfer_dollar()" class="btn btn-primary round btn-block">ثبت درخواست</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@stop

@section('script')
    <script>
        $('#total_amount').digitbox({grouping:1, separator:',', truevalue:1});

        $('#total_amount,#amount_dollar').keyup(function() {
            var price_dollar = {{$result->orders_model->price_dollar}};
            if($(this).attr('name')=='total_amount' ){
                var total_amount = $('#total_amount').val().split(',').join('');
                $('#amount_dollar').val(total_amount / price_dollar);

            }else if($(this).attr('name')=='amount_dollar' ){
                var amount_dollar = $('#amount_dollar').val();
                $('#total_amount').val(amount_dollar * price_dollar);
            }
        });

        function transfer_dollar() {
            swal({
                title: "از تایید و انتقال ارز اطمینان دارید؟",
                text:'تغییر وضعیت بعد از تایید دیگر امکان پذیر نیست',
                type: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor: "#04d216",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.ajax({
                        url: "{{asset('').env('PanelPrefix')}}/orders/{{$result->order->id}}/PSVouchersTransfer",
                        type: 'put',
                        data: $("#PSVouchers").serialize(),
                    });
                }
            }).then((data) => {
                if (data.value.status == true) {
                    swal({
                        title: 'انجام شد!',
                        type: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.reload();
                    });
                } else {
                    swal("خطا", data.value.messege, "error");
                }
            });
        }
    </script>

    @parent
@stop
