@extends('admin.layouts.master')
@section('title', 'حساب کاربری')
@section('css')

@stop

@section('content')
    <div class="row">
        <div class="card mb-4 col-12">
            <div class="card-body">
                <div class="card-title mb-0">ویرایش مشخصات کاربری ادمین</div>

                <form  autocomplete="off" method="post" class="needs-validation" novalidate action="">
                    @csrf
                    <div class="row col-md-8 col-12 m-md-auto m-0 p-0">
                        <div class="col-md-6">
                            <div class="col-md-12 p-0 pl-md-1 form-group mb-3">
                                <label for="firstName1">نام</label>
                                <input type="text" class="form-control round text-center" value="{{Auth::user()->name}}" name="name" id="name" placeholder="نام خود را درج کنید" required>
                                <div class="invalid-feedback">نام خود را درج کنید</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="col-md-12 p-0 pl-md-1 form-group mb-3">
                                <label>ایمیل</label>
                                <input type="email" class="form-control round text-center ltr-dir" value="{{Auth::user()->email}}" name="email" id="email" placeholder="ایمیل را درج کنید" required>
                                <div class="invalid-feedback">ایمیل را درج کنید</div>
                            </div>
                        </div>

                        <div class="col-md-12 p-0 pl-md-1 form-group mb-3">
                            <label>موبایل</label>
                            <input type="text" class="form-control round number text-center ltr-dir" value="{{Auth::user()->mobile}}" name="mobile" id="mobile" placeholder="موبایل را درج کنید" required>
                            <div class="invalid-feedback">موبایل را درج کنید</div>
                        </div>

                        <div class="col-md-12 p-0 pl-md-1 form-group mb-3">
                            <label>رمز عبور<span class="text11">(در صورت تمایل به تغییر)</span></label>
                            <input type="password" class="form-control round text-center ltr-dir" minlength="6" name="password" id="password" placeholder="رمز عبور">
                            <div class="invalid-feedback">حداقل تعداد کاراکتر پسورد 6 عدد میباشد</div>
                        </div>

                        <div class="col-md-12 p-0 pl-md-1 form-group mb-3">
                            <label>تکرار رمز عبور</label>
                            <input type="password" class="form-control round text-center ltr-dir" minlength="6" name="re_password" id="re_password" placeholder="تکرار رمز عبور">
                            <div class="invalid-feedback">حداقل تعداد کاراکتر پسورد 6 عدد میباشد</div>
                        </div>

                        <div class="text-center my-4">
                            <button type="submit" class="btn btn-primary round btn-block">ثبت درخواست</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@stop


@section('js')

@stop

@section('script')
    <script>



        $(document).ready(function () {

            $('form').ajaxForm({
                beforeSend: function () {
                    loading();
                },
                complete: function (data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                            onClose: () => {
                                if($('#password').val()!="")
                                    document.getElementById('logout-form').submit();
                                else
                                    location.reload();
                            }
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    unloading();
                }
            });
        });



    </script>
@stop
