<div class="row">
    <div class="col-lg-4 col-md-12 col-12">
        <div class="card o-hidden">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th scope="col">عنوان</th>
                            <th scope="col">مقدار</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <th scope="row">تعداد سفارشات</th>
                            <td>{{$result->CountOrders}}</td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ سفارشات</th>
                            <td>{{number_format($result->AmountOrders)}}</td>
                        </tr>
                        <tr>
                            <th scope="row">تعداد فروش</th>
                            <td>{{($result->CountOrdersSell)}}</td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ فروش</th>
                            <td>{{number_format($result->AmountOrdersSell)}}</td>
                        </tr>
                        <tr>
                            <th scope="row">تعداد خرید</th>
                            <td>{{($result->CountOrdersBuy)}}</td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ خرید</th>
                            <td>{{number_format($result->AmountOrdersBuy)}}</td>
                        </tr>
                        <tr>
                            <th scope="row">کاربر جدید</th>
                            <td>{{($result->CountUser)}}</td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ بیشترین فروش</th>
                            <td>{{number_format($result->AmountMaxSell)}}</td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ بیشترین خرید</th>
                            <td>{{number_format($result->AmountMaxBuy)}}</td>
                        </tr>
                        <tr>
                            <th scope="row">تعداد معرفی ها</th>
                            <td>{{isset($result->UserInvitation) ? $result->UserInvitation : 0}}</td>
                        </tr>
                        <tr>
                            <th scope="row">تعداد کارت های ثبت شده</th>
                            <td>{{isset($result->CardBank) ? $result->CardBank : 0}}</td>
                        </tr>
                        <tr>
                            <th scope="row">تیکت های ایجاد شده</th>
                            <td>{{isset($result->Ticket) ? $result->Ticket : 0}}</td>
                        </tr>
                        <tr>
                            <th scope="row">تراکنش های کیف پول</th>
                            <td>{{isset($result->Finance) ? $result->Finance : 0}}</td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ و تعداد برداشت از کیف پول</th>
                            <td>({{isset($result->FinanceIncCount) ? $result->FinanceIncCount : 0}})
                                - {{isset($result->FinanceIncAmount) ? number_format($result->FinanceIncAmount): 0}}</td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ و تعداد واریز به کیف پول</th>
                            <td>({{isset($result->FinanceDecCount) ? $result->FinanceDecCount : 0}})
                                - {{isset($result->FinanceDecAmount) ? number_format($result->FinanceDecAmount): 0}}</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>


    <div class="col-lg-8 col-md-12 col-12">
        <div class="card o-hidden">
            <div class="card-body">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    @php $i = 0; $j = rand(0,1) @endphp
                    @foreach($result->Currencys as $Currency)
                        <li class="nav-item">
                            <a class="nav-link @if($i==$j)active @endif" style="padding: 10px" id="{{$Currency}}-tab"
                               data-bs-toggle="tab" href="#{{$Currency}}" role="tab" aria-controls="{{$Currency}}"
                               aria-selected="true">
                                <img src="{{asset('')}}app-assets/images/currency/{{$Currency}}.svg" style="width: 35px;">
                            </a>
                        </li>
                        @php $i++; @endphp
                    @endforeach
                </ul>
                <div class="tab-content pb-0" id="myTabContent">
                    @php $i = 0; @endphp
                    @foreach($result->Currencys as $Currency)
                        <div class="tab-pane fade show @if($i==$j)active @endif" id="{{$Currency}}" role="tabpanel"
                             aria-labelledby="{{$Currency}}-tab">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                    <tr>
                                        <th scope="col"> ارز: {{$Currency}}

                                        </th>
                                        <th scope="col">تعداد سفارشات</th>
                                        <th scope="col">مبلغ سفارشات</th>
                                        <th scope="col">تعداد خریدها</th>
                                        <th scope="col">تعداد فروش ها</th>
                                        <th scope="col">مبلغ کل خریدها</th>
                                        <th scope="col">مبلغ کل فروش ها</th>
                                        <th scope="col">بیشترین خرید</th>
                                        <th scope="col">بیشترین فروش</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <th scope="row">مقدار</th>
                                        <td>{{$result->$Currency->CountOrders}}</td>
                                        <td>{{$result->$Currency->AmountOrders}}</td>
                                        <td>{{$result->$Currency->CountOrdersBuy}}</td>
                                        <td>{{($result->$Currency->CountOrdersSell)}}</td>
                                        <td>{{number_format($result->$Currency->AmountOrdersBuy)}}
                                            (${{$result->$Currency->dollarBuy}})
                                        </td>
                                        <td>{{number_format($result->$Currency->AmountOrdersSell)}}
                                            (${{$result->$Currency->dollarSell}})
                                        </td>
                                        <td>
                                            <a href="{{asset('').env('PanelPrefix')}}/orders/{{$result->$Currency->IDMaxBuy}}">{{number_format($result->$Currency->AmountMaxBuy)}}</a>
                                        </td>
                                        <td>
                                            <a href="{{asset('').env('PanelPrefix')}}/orders/{{$result->$Currency->IDMaxSell}}">{{number_format($result->$Currency->AmountMaxSell)}}</a>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>


                            </div>
                        </div>
                        @php $i++; @endphp
                    @endforeach

                </div>

            </div>
        </div>

        <div class="card o-hidden">
            <div class="card-body">
                <div class="card-title">نمودار وضعیت سیستم</div>
                <div class="height-400">
                    <canvas id="area-chart"></canvas>
                </div>
            </div>
        </div>

    </div>


    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <div class="card-title">نمودار ارز ها</div>
                <div class="height-300">
                    <canvas id="polar-chart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <div class="card-title">نمودار طریقه سفارش</div>
                <div class="height-300">
                    <canvas id="stackedPie"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    $('[data-toggle="tooltip"]').tooltip();


            var o = $("#area-chart");
            new Chart(o, {
                    type: "line", options: {
                        responsive: !0, maintainAspectRatio: !1,
                        legend: {
                            position: "bottom",
                            labels: {
                                fontSize: 14,
                                fontFamily: 'Vazir-FD',
                            }
                        }
                        , hover: {
                            mode: "label"
                        }
                        , scales: {
                            xAxes: [{
                                display: !0, gridLines: {
                                    color: "#f3f3f3", drawTicks: !0
                                }
                                , scaleLabel: {
                                    display: !1, labelString: "ماه", fontFamily: 'Vazir-FD'
                                },
                                ticks: {
                                    fontFamily: 'Vazir-FD',

                                }
                            }
                            ], yAxes: [{
                                display: !0, gridLines: {
                                    color: "#f3f3f3", drawTicks: !1
                                }
                                , scaleLabel: {
                                    display: !0, labelString: "مقدار", fontFamily: 'Vazir-FD'
                                }
                            }
                            ]
                        }
                        , title: {
                            display: !1, text: "نمودار خط Chart.js - افسانه"
                        },
                        tooltips: {
                            titleFontFamily: 'Vazir-FD',
                            bodyFontFamily: 'Vazir-FD',
                            titleMarginBottom: 10,
                            titleSpacing: 10
                        }
                    }
                    , data: {
                        labels: [@foreach($result->Label_CL as $label) "{{$label}}", @endforeach],
                        datasets: [{
                            label: "کاربر جدید",
                            data: [@foreach($result->UserAdd_CL as $value) {{$value}} , @endforeach]
                            ,
                            backgroundColor: "rgba(209,212,219,.4)",
                            borderColor: "transparent",
                            pointBorderColor: "#D1D4DB",
                            pointBackgroundColor: "#FFF",
                            pointBorderWidth: 2,
                            pointHoverBorderWidth: 2,
                            pointRadius: 4
                        }
                            , {
                                label: "مبلغ خرید(میلیون تومان)",
                                data: [@foreach($result->AmountBuy as $value) {{$value}} , @endforeach]
                                ,
                                backgroundColor: "rgba(255,113,103,0.6)",
                                borderColor: "transparent",
                                pointBorderColor: "#e01b07",
                                pointBackgroundColor: "#FFF",
                                pointBorderWidth: 2,
                                pointHoverBorderWidth: 2,
                                pointRadius: 4
                            }
                            , {
                                label: "مبلغ فروش(میلیون تومان)",
                                data: [@foreach($result->AmountSell as $value) {{$value}} , @endforeach]
                                ,
                                backgroundColor: "rgba(0,43,255,0.6)",
                                borderColor: "transparent",
                                pointBorderColor: "#5175E0",
                                pointBackgroundColor: "#FFF",
                                pointBorderWidth: 2,
                                pointHoverBorderWidth: 2,
                                pointRadius: 4
                            }

                        ]
                    }
                }
            )

            var a = $("#polar-chart");
            new Chart(a, {
                    type: "pie",
                    options: {

                        responsive: !0, maintainAspectRatio: !1, responsiveAnimationDuration: 500,
                        legend: {
                            position: "right",
                            labels: {
                                fontSize: 14,
                                fontFamily: 'Vazir-FD',
                            }
                        },
                        tooltips: {
                            titleFontFamily: 'Vazir-FD',
                            bodyFontFamily: 'Vazir-FD',
                            titleMarginBottom: 10,
                            titleSpacing: 10
                        }
                    }
                    , data: {
                        labels: [@foreach($result->PieCurrencyOrders as $Chart) "{{$Chart->orders_model}}", @endforeach],
                        datasets: [{
                            data: [@foreach($result->PieCurrencyOrders as $Chart)  {{$Chart->amount}} , @endforeach],

                            backgroundColor: ["#fe9403", "#252525", "#009ddf", "#e6381c", "#aa1a03", "#fecc00", '#00cebe', '#7f2371', '#53ae94', '#106db3'],
                        }
                        ]
                    }
                }
            )

            var a = $("#stackedPie");
            new Chart(a, {
                    type: "polarArea", options: {
                        responsive: !0, maintainAspectRatio: !1, responsiveAnimationDuration: 500, legend: {
                            position: "top"
                        }
                        , title: {
                            display: !1, text: "Chart.js نمودار منطقه قطبی"
                        }
                        , scale: {
                            ticks: {
                                beginAtZero: !0
                            }
                            , reverse: !1
                        }
                        , animation: {
                            animateRotate: !1
                        }
                    }
                    , data: {
                        labels: [@foreach($result->PieCurrencyVia as $Chart) "{{$Chart->via}}", @endforeach], datasets: [{
                            data: [@foreach($result->PieCurrencyVia as $Chart){{$Chart->count}} , @endforeach],
                            backgroundColor: ["#639", "#63845", "#ebcb37", "#a1b968", "#0d94bc", "#135bba"]
                        }
                        ]
                    }
                }
            )

</script>
