@extends('admin.layouts.master')
@section('title', 'تنظیمات')
@section('css')
@stop

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">تنظیمات درگاه‌های پرداخت</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <ul class="nav nav-tabs nav-tabs-custom nav-justified" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#home1" role="tab">
                            <span>تنظیمات عمومی</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#profile1" role="tab">
                            <span>تنظیمات اختصاصی</span>
                        </a>
                    </li>
                </ul>
                <div class="mb-4">
                    <form autocomplete="off" method="post" class="needs-validation" novalidate action="">
                        @csrf
                        <div class="tab-content p-3 text-muted">
                            <div class="tab-pane active" id="home1" role="tabpanel">
                                <div class="col-md-9 mx-auto my-4">
                                    <div class="row">
                                        <div class="col-md-6 col-12 form-group mb-3">
                                            <label for="picker1">درگاه پرداخت</label>
                                            <select class="text-center form-control" name="payment_gateway" id="payment_gateway" required>
                                                <option value='pay'@if($result->payment_gateway =='pay') selected @endif>پی آی آر</option>
                                                <option value='idpay'@if($result->payment_gateway =='idpay') selected @endif>آی دی پی</option>
                                                <option value='zarinpal'@if($result->payment_gateway =='zarinpal') selected @endif>زرین پال</option>
                                                <option value='zibal'@if($result->payment_gateway =='zibal') selected @endif>زیبال</option>
                                                <option value='vandar'@if($result->payment_gateway =='vandar') selected @endif>وندار</option>
                                            </select>
                                            <div class="invalid-feedback">درگاه پرداخت را انتخاب کنید</div>
                                        </div>
                                        <div class="col-md-6 form-group mb-3">
                                            <label>حداقل مجاز خرید</label>
                                            <input type="text" name="min_buy" id="min_buy"
                                                   class="form-control  text-center ltr-dir comma"
                                                   placeholder="حداقل مجاز خرید" required value="{{number_format($result->min_buy)}}"/>
                                            <div class="invalid-feedback">حداقل مجاز خرید را درج کنید</div>
                                        </div>
                                        <div class="col-md-12 col-12 form-group mb-3">
                                            <label>مقدار خرید روزانه در هنگام ثبت نام</label>
                                            <input type="text" name="daily_buy_register" id="daily_buy_register"
                                                   class="form-control  text-center ltr-dir comma"
                                                   placeholder="مقدار خرید" required value="{{$result->daily_buy_register??''}}"/>
                                            <div class="invalid-feedback">مقدار خرید را درج کنید</div>
                                        </div>
                                        <div class="col-md-12 form-group mb-3">
                                            <label>حداقل مقدار برداشت کیف پول</label>
                                            <input type="text" name="Withdraw_value_min" id="Withdraw_value_min"
                                                   class="form-control  text-center ltr-dir comma"
                                                   placeholder="مبلغ به تومان" required value="{{number_format($result->Withdraw_value_min??'0')}}" />
                                            <div class="invalid-feedback">مبلغ را درج کنید</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="profile1" role="tabpanel">
                                <div class="col-md-8 my-4 mx-auto">
                                    <label>توکن آی دی پی</label>
                                    <div class="form-group mb-3">
                                        <div class="input-group">
                                            <span class="input-group-text" id="option-date"><img src="{{ asset('images/brands/idpay.svg') }}" width="25px"></span>
                                            <input type="text" name="IdpayToken" id="IdpayToken"
                                                   class="form-control text-center ltr-dir"
                                                   placeholder="Idpay Token" required value="{{$result->IdpayToken??''}}"/>
                                            <div class="invalid-feedback">توکن را درج کنید</div>
                                        </div>
                                    </div>
                                    <label>توکن pay.ir</label>
                                    <div class="form-group mb-3">
                                        <div class="input-group">
                                            <span class="input-group-text" id="option-date"><img src="{{ asset('images/brands/payir.svg') }}" width="25px"></span>
                                            <input type="text" name="PayIrToken" id="PayIrToken"
                                                   class="form-control text-center ltr-dir"
                                                   placeholder="PayIr Token" required value="{{$result->PayIrToken??''}}"/>
                                            <div class="invalid-feedback">توکن را درج کنید</div>
                                        </div>
                                    </div>
                                    <label>توکن زرین پال</label>
                                    <div class="col-md-12 form-group mb-3">
                                        <div class="input-group">
                                            <span class="input-group-text" id="option-date"><img src="{{ asset('images/brands/zarinpal.svg') }}" width="25px"></span>
                                            <input type="text" name="ZarinpalToken" id="ZarinpalToken"
                                                   class="form-control  text-center ltr-dir"
                                                   placeholder="Zarinpal Token" required value="{{$result->ZarinpalToken??''}}"/>
                                            <div class="invalid-feedback">توکن را درج کنید</div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 form-group mb-3">
                                        <label>توکن زیبال</label>
                                        <div class="input-group">
                                            <span class="input-group-text" id="option-date"><img src="{{ asset('images/brands/zibal.svg') }}" width="25px"></span>
                                            <input type="text" name="ZibalToken" id="ZibalToken"
                                                   class="form-control  text-center ltr-dir"
                                                   placeholder="Zibal Token" required value="{{$result->ZibalToken ?? ''}}"/>
                                            <div class="invalid-feedback">توکن را درج کنید</div>
                                        </div>
                                    </div>
                                    <div class="col-md-12 form-group mb-3">
                                        <label>توکن وندار</label>
                                        <div class="input-group">
                                            <span class="input-group-text" id="option-date"><img src="{{ asset('images/brands/vandar.png') }}" width="25px"></span>
                                            <input type="text" name="VandarToken" id="VandarToken"
                                                   class="form-control  text-center ltr-dir"
                                                   placeholder="Vandar Token" required value="{{$result->VandarToken ?? ''}}"/>
                                            <div class="invalid-feedback">توکن را درج کنید</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="text-center">
                            <button type="submit" class="btn btn-primary btn-block btn " id="ScrollButton">ثبت تغییرات</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@stop

@section('script')
    <script>
        $(document).ready(function () {
            $('form').ajaxForm({
                beforeSend: function () {
                    loading();
                },
                complete: function (data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            location.reload();
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    unloading();
                }
            });
        });
    </script>
@stop
