<form id="cardbank_edit" autocomplete="off" method="post" action="{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/cardbank/{{$result->card->id}}/edit" class="mt-2 needs-validation col-md-12 mx-auto" novalidate >
    @csrf
    <div class="row col-12 m-md-auto m-0 p-0">
        <div class="col-md-6 form-group mb-3">
            <label>نام صاحب حساب</label>
            <input type="text" class="form-control round text-center" value="{{$result->card->account_owner}}" name="name_family" placeholder="نام و نام خانوادگی صاحب حساب" required>
            <div class="invalid-feedback">نام صاحب حساب درج شود</div>
        </div>
        <div class="col-md-6 form-group mb-3">
            <label>نام بانک</label>
            <select name="bank_name" id="bank_name_edit" required class="form-control round text-center">
                <option value="" disabled hidden selected>انتخاب کنید</option>
                <option value="بانک ملی">بانک ملی</option>
                <option value="بانک ملت">بانک ملت</option>
                <option value="بانک مسکن">بانک مسکن</option>
                <option value="بانک آینده">بانک آینده</option>
                <option value="بانک صادرات">بانک صادرات</option>
                <option value="بانک کشاورزی">بانک کشاورزی</option>
                <option value="بانک سامان">بانک سامان</option>
                <!--<option value="بانک پارسیان">بانک پارسیان</option>-->
                <option value="بانک پاسارگاد">بانک پاسارگاد</option>
                <option value="بانک دی">بانک دی</option>
                <option value="بانک رسالت">بانک رسالت</option>
                <option value="بانک شهر">بانک شهر</option>
                <option value="بانک سرمایه">بانک سرمایه</option>
                <option value="بانک اقتصاد نوین">بانک اقتصاد نوین</option>
                <option value="بانک انصار">بانک انصار</option>
                <option value="بانک تجارت">بانک تجارت</option>
                <option value="بانک ایران زمین">بانک ایران زمین</option>
                <option value="سایر">سایر</option>
            </select>
            <div class="invalid-feedback"> بانک را انتخاب کنید</div>
        </div>
        <div class="col-md-6 form-group mb-3">
            <label>شماره کارت</label>
            <input type="text" class="form-control round text-center numbers ltr-dir" value="{{$result->card->card_number}}" name="card_number" maxlength="16" minlength="16" placeholder="شماره کارت" required>
            <div class="invalid-feedback">شماره کارت بصورت صحیح درج شود</div>
        </div>
        <div class="col-md-6 form-group mb-3">
            <label>شماره حساب</label>
            <input type="text" class="form-control round text-center numbers ltr-dir" value="{{$result->card->account_number}}" name="account_number" maxlength="16" minlength="9" placeholder="شماره حساب">
            <div class="invalid-feedback">شماره حساب درج شود</div>
        </div>
        <div class="col-md-12 text-left form-group mb-3">
            <label>شماره شبا بدون IR</label>
            <input type="text" class="form-control round text-center numbers ltr-dir" value="{{$result->card->shaba}}" name="iban" maxlength="30" minlength="10" placeholder="شماره شبا بدون IR" >
            <div class="invalid-feedback">شماره شبا درج شود</div>
        </div>

        <div class="text-center my-3">
            <button type="submit" class="btn btn-primary round btn-block">ویرایش کارت</button>
        </div>


    </div>
</form>

<script>


    $('#bank_name_edit').val("{{$result->card->bank_name}}");

    $(document).ready(function () {
        var bar = $('#cardbank_edit .progress-bar');
        var percent = $('#cardbank_edit .progress-bar');
        $('form#cardbank_edit').ajaxForm({
            beforeSend: function () {
                loading();
            },
            uploadProgress: function (event, position, total, percentComplete) {
                $('#cardbank_edit .progress').fadeIn();
                var percentVal = '0%';
                bar.width(percentVal);
                percent.html(percentVal);
                if($('#card_image_edit').get(0).files.length !=0 || $('#card_image_edit').get(0).files.length !=0){
                    var percentVal = percentComplete + '%';
                    bar.width(percentVal);
                    percent.html(percentVal);
                }
            },
            complete: function (data) {
                data = data.responseJSON;
                if (data.status == true) {
                    Swal.fire({
                        icon: 'success',
                        title: "انجام شد",
                        html: data.message,
                        confirmButtonText: "تایید",
                    }).then(function () {
                        $('#EditCardModal').modal('hide');
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: "خطا",
                        html: data.message,
                        confirmButtonText: "تایید",
                    })
                }
                unloading();
            }
        });
    });

</script>
