@extends('user.layouts.master')
@section('title', 'نتیجه تراکنش')
@section('css')

@stop

@section('content')

<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-body">
            <div class="row mb-4">
                <div class="col-md-12 mb-4 mx-auto">
                    <div class="card o-hidden">
                        @if($result->status == true)
                            <div class="card-body text-center box-payment border-{{$result->color ?? 'success'}}">

                                <img src="{{asset('')}}app-assets/images/icons/success.png" width="130px">
                                @if(isset($result->fish) && $result->fish == true)
                                    <h3 class="mt-2 col-md-8 mx-auto">فیش پرداختی شما با موفقیت ثبت شد و سفارش در دست بررسی پرداخت و اقدام میباشد و بعد از بررسی سفارش شما انجام میشود!</h3>
                                @else
                                    <h2 class="mt-2 col-md-8 mx-auto">{!!$result->message ?? 'با موفقیت انجام شد!' !!}</h2>
                                @endif

                                @if(isset($result->sell) && $result->sell == true)
                                    @if(isset($result->wallet))
                                        @if(isset($result->walletMessage))
                                            {!!$result->walletMessage !!}
                                        @else
                                            <p>مبلغ {{number_format($result->amount)}} تومان با موفقیت به کیف پول شما اضافه شد.</p>
                                        @endif
                                    @else
                                        <p class="col-md-8 mx-auto">مبلغ {{number_format($result->amount)}} تومان با موفقیت ثبت گردید و بعد از تایید تا چند ساعت دیگر به حساب شما واریز میگردد و در بخش سفارشات قابل پیگیری است.</p>
                                    @endif
                                @endif
                                <div class="table-responsive">
                                    <table class="table table-bordered col-md-8 mx-auto mt-3">
                                        <tbody>
                                        @foreach($result->rowData as $rowData)
                                            <tr>
                                                <th scope="row">{{$rowData->name}}</th>
                                                <td class="sans-serif sans-serif text-center cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                                    <i class="feather icon-copy"></i>  <span dir="ltr">{{$rowData->value}}</span>
                                                </td>
                                            </tr>
                                        @endforeach

                                        @if(isset($result->RefID))
                                        <tr>
                                            <th scope="row">کد پیگیری خرید</th>
                                            <td class="sans-serif text-center cursor-pointer">
                                                <span>{{$result->RefID}}</span>
                                            </td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <th scope="row">تاریخ</th>
                                            <td class="text-center">
                                                <span>{{$result->date}}</span>
                                            </td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="btn-payment">
                                    <a class="btn btn-primary round" href="{{asset('')}}">داشبورد</a>
                                    <a class="btn btn-primary round" href="{{asset('')}}history/orders">سفارشات</a>
                                </div>

                            </div>
                        @elseif($result->status == false)
                            <div class="card-body text-center box-payment">
                                <img src="{{asset('')}}app-assets/images/icons/error.png" width="130px">
                                <h3 class="mt-3 col-md-8 mx-auto">{!!$result->message!!}</h3>
                                <div class="btn-payment">
                                    <a class="btn btn-primary round" href="{{asset('')}}">داشبورد</a>
                                    <a class="btn btn-primary round" href="{{asset('')}}ticket">پشتیبانی</a>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

@stop

@section('js')
@stop

@section('script')
@stop
