@extends('user.layouts.master')
@section('title', 'فروشگاه محصولات')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">سفارش پول دیجیتال</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title mb-0">لیست سفارشات</div>
                </div>
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#all" role="tab">
                            <span>همه سفارشات</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#completed" role="tab">
                            <span>تکمیل شده</span>
                        </a>
                    </li>
                </ul>

                <div class="tab-content p-3 text-muted">
                    <div class="tab-pane active" id="all" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0 table-nowrap" id="myTable">
                                <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>نام محصول</th>
                                    <th>قیمت خرید</th>
                                    <th>وضعیت</th>
                                    <th>تاریخ سفارش</th>
                                    <th>مشاهده جزییات</th>
                                </tr>
                                </thead>
                                <tbody>
                                    @if( isset($orders) )
                                        @foreach( $orders as $order )
                                            <tr>
                                                <td>{{ $order->id }}</td>
                                                <td>{{ $order->product_title }}</td>
                                                <td>{{ number_format($order->final_price) }}<small class="ms-1">تومان</small></td>
                                                <td>
                                                    @if( $order->status == 'payment-confirm' )
                                                        <span class="badge badge-pill badge-soft-success font-size-12">پرداخت موفق</span>
                                                    @elseif( $order->status == 'payment-pending' )
                                                        <span class="badge badge-pill badge-soft-warning font-size-12">در انتظار پرداخت</span>
                                                    @elseif( $order->status == 'payment-cancel' )
                                                        <span class="badge badge-pill badge-soft-danger font-size-12">پرداخت ناموفق</span>
                                                    @elseif( $order->status == 'done' )
                                                        <span class="badge badge-pill badge-soft-success font-size-12">تکمیل شده</span>
                                                    @elseif( $order->status == 'cart' )
                                                        <span class="badge badge-pill badge-soft-warning font-size-12">سبد خرید</span>
                                                    @elseif( $order->status == 'canceled' )
                                                        <span class="badge badge-pill badge-soft-danger font-size-12">لغو شده</span>
                                                    @endif
                                                </td>
                                                <td>{{ $order->date }}</td>
                                                <td>
                                                    <a class="btn btn-primary btn-sm btn-rounded" href="@if( $order->status == 'cart') {{ asset('') }}cart @else {{ asset('') }}product-orders/{{ $order->id }} @endif">مشاهده</a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                            {{ $orders->fragment('all')->links() }}
                        </div>
                    </div>
                    <div class="tab-pane" id="completed" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0 table-nowrap" id="myTable">
                                <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>تصویرمحصول</th>
                                    <th>نام محصول</th>
                                    <th>قیمت خرید</th>
                                    <th>وضعیت</th>
                                    <th>تاریخ سفارش</th>
                                    <th>مشاهده جزییات</th>
                                </tr>
                                </thead>
                                <tbody>
                                    @if( isset($completedOrders) )
                                        @foreach( $completedOrders as $order)
                                            <tr>
                                                <td>{{ $order->id }}</td>
                                                <td>
                                                    <img width="70px" src="{{ asset($order->product->image) }}" />
                                                </td>
                                                <td>{{ $order->product->title }}</td>
                                                <td>{{ number_format($order->final_price) }}<small class="ms-1">تومان</small></td>
                                                <td>
                                                    @if( $order->status == 'done' )
                                                        <span class="badge badge-pill badge-soft-success font-size-12">تکمیل شده</span>
                                                    @endif
                                                </td>
                                                <td>{{ $order->date }}</td>
                                                <td>
                                                    <a class="btn btn-primary btn-sm btn-rounded" href="/product-orders/{{ $order->id }}">مشاهده</a>
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif
                                </tbody>
                            </table>
                            {{ $completedOrders->fragment('completed')->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('script')
    <script>
        $(document).ready(function() {

            var url = document.location.toString();
            if (url.match('#')) {
                $('.nav-tabs a[href="#' + url.split('#')[1] + '"]')[0].click();
            }

            //To make sure that the page always goes to the top
            setTimeout(function () {
                window.scrollTo(0, 0);
            },200);

        });
    </script>
@stop
