@extends('user.layouts.master')
@section('title', 'لیست واریز کیف پول شما')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">تاریخچه برداشت کیف پول</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{asset('')}}">داشبورد</a></li>
                        <li class="breadcrumb-item active">لیست برداشت کیف پول شما</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-4">
                        <div class="card-title mb-0">لیست واریز کیف پول شما</div>
                    </div>
                    <div class="table-responsive">
                        <table class="table align-middle mb-0 table-nowrap" id="myTable">
                            <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>نوع عملیات</th>
                                <th>مبلغ</th>
                                <th>تاریخ و ساعت ثبت</th>
                                <th>توضیحات</th>
                                <th>وضعیت</th>
                            </tr>
                            </thead>
                            <tbody>
                            @php $i = 1; @endphp
                            @foreach($Finances as $Finance)
                                @if($Finance->type == 'برداشت')
                                    <tr>
                                        <td>{{ $i }}</td>
                                        <td>{{ $Finance->type }}</td>
                                        <td>{{ number_format($Finance->amount) }} <small> تومان</small></td>
                                        <td>{{ $Finance->created_at }}</td>
                                        <td>{{ $Finance->description }}</td>
                                        <td>
                                            @if($Finance->status =='در دست اقدام')
                                                <span class="badge badge-pill bg-warning m-1 font-weight-light">در دست اقدام</span>
                                            @elseif($Finance->status =='معلق,پرداخت شده' || $Finance->status =='معلق,عودت')
                                                <span class="badge badge-pill bg-dark m-1">معلق</span>
                                            @elseif($Finance->status =='رد شده')
                                                <span class="badge badge-pill bg-danger m-1">رد شده</span>
                                            @elseif($Finance->status =='ناموفق')
                                                <span class="badge badge-pill bg-danger m-1">ناموفق</span>
                                            @else
                                                <span class="badge badge-pill bg-success m-1">{{ $Finance->status }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @php $i++; @endphp
                                @endif
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
