@extends('user.layouts.master')
@section('title', 'جزئیات سفارش '.$result->order->detail->type .' '. $result->order->detail->title)
@section('css')
@stop

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">جزییات سفارش {{$result->order->detail->type .' '. $result->order->detail->title}}</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ asset('') }}orders">سفارشات</a></li>
                        <li class="breadcrumb-item active">فاکتور</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card border @if($result->order->status == 'پرداخت شده' || $result->order->status == 'انجام شده'  || $result->order->status == 'منتقل شده') border-success @elseif($result->order->status == 'رد شده') border-danger @elseif($result->order->status == 'در دست اقدام') border-info @else border-warning @endif">
                <div class="card-body">
                    <div class="invoice-title">
                        <h4 class="float-end font-size-16">شماره سفارش # {{$result->order->id}}</h4>
                        <div class="mb-4">
                            <img src="{{ asset('images/logo/logo-dark.svg') }}" alt="logo" height="20"/>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <p class="text-center">اطلاعاتی که در این صفحه میبینید متعلق به این سفارش می باشد</p>
                        <div class="col-sm-12">
                            <div class="my-2">
                                <strong>تاریخ ثبت:</strong>
                                {{$result->order->date}}
                            </div>
                            <div class="my-2">
                                <strong>مبلغ سفارش:</strong>
                                {{number_format($result->order->amount)}} تومان
                            </div>
                            <div class="my-2">
                                <strong>مبلغ پرداخت شده:</strong>
                                {{number_format($result->order->payment)}} تومان
                            </div>
                            <div class="my-2">
                                <strong>وضعیت:</strong>
                                @if($result->order->status == 'پرداخت شده' || $result->order->status == 'انجام شده'|| $result->order->status == 'منتقل شده')
                                    <span class="badge badge-pill bg-success font-weight-light">{{$result->order->status}}</span>
                                @elseif($result->order->status == 'رد شده')
                                    <span class="badge badge-pill bg-danger font-weight-light">{{$result->order->status}}</span>
                                @elseif($result->order->status == 'در دست اقدام')
                                    <span class="badge badge-pill bg-success font-weight-light">پرداخت شده</span>
                                    <span class="badge badge-pill bg-info font-weight-light">{{$result->order->status}}</span>
                                @elseif($result->order->status == 'در حال انتقال ارز')
                                    <span class="badge badge-pill bg-success font-weight-light">پرداخت شده</span>
                                    <span class="badge badge-pill bg-warning font-weight-light">{{$result->order->status}}</span>
                                @else
                                    <span class="badge badge-pill bg-warning font-weight-light">{{$result->order->status}}</span>
                                @endif
                            </div>
                            @if($result->order->type == 'sell')
                                <div class="my-2">
                                    <strong>پرداخت از طریق:</strong>
                                    @if(isset($result->order->id_cardbank))
                                        شماره کارت  <span dir="ltr">{{substr_replace($result->order->cardbank->card_number, str_repeat("*", 6), 6, 6)}}</span>
                                    @else
                                        کیف پول شما در {{ getSetting('app_name_farsi') }}
                                    @endif
                                </div>
                            @else
                                <div class="my-2">
                                    <strong>پرداخت از طریق:</strong>
                                    {{$result->order->payment_gateway}}
                                </div>
                            @endif
                            @if(isset($result->order->description))
                                <div class="my-2">
                                    <strong>توضیحات سفارش:</strong>
                                    {{$result->order->description}}
                                </div>
                            @endif
                            @if(isset($result->ticket))
                                @if($result->ticket->seen_user == 1)
                                    <div class="alert alert-card alert-blue" role="alert">
                                        <strong class="text-capitalize">نکته!</strong> تیکتی در مورد این سفارش ایجاد شده است و جهت پیگیری سفارش و مشاهده تیکت به بخش تیکت ها مراجعه نمایید. <a href="{{asset('')}}ticket/{{$result->ticket->id}}" class="amber"><i class="ft-link"></i> لینک تیکت </a>
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">×</span>
                                        </button>
                                    </div>
                                @else
                                    <div class="alert alert-card alert-warning" role="alert">
                                        <strong class="text-capitalize">نکته!</strong> تیکتی در مورد این سفارش ایجاد شده است که هنوز ندیده اید و لطفا جهت پیگیری سفارش و مشاهده تیکت به بخش تیکت ها مراجعه نمایید. <a href="{{asset('')}}ticket/{{$result->ticket->id}}" class="typo_link text-primary"><i class="ft-link"></i> لینک تیکت </a>
                                    </div>
                                @endif
                            @endif

                            <div class="my-4">
                                <span class="mb-3">مشخصات خریدار:</span>
                                <div class="table-responsive">
                                    <table class="table align-middle table-nowrap table-hover">
                                        <thead class="table-light">
                                        <tr>
                                            <th scope="col" style="width: 70px;">#</th>
                                            <th scope="col">نام و نام خانوادگی</th>
                                            <th scope="col">شماره تماس</th>
                                            <th scope="col">ایمیل</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>
                                                <div class="avatar-xs">
                                                    <img src="{{ asset('images/users/user.png') }}" width="30px">
                                                </div>
                                            </td>
                                            <td>
                                                <h5 class="font-size-14 mb-1">{{$result->user->name .' '.$result->user->family}}</h5>
                                            </td>
                                            <td>{{$result->user->mobile}}</td>
                                            <td>{{$result->user->email??'ثبت نشده است'}}</td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="py-2 mt-3">
                        <h3 class="font-size-15 fw-bold">جزئیات سفارش</h3>
                    </div>
                    @yield('orders_model')
                    <div class="d-print-none">
                        <div class="float-end">
                            <a href="javascript:window.print()" class="btn btn-success waves-effect waves-light me-1"><i class="fa fa-print"></i></a>
                            <a href="{{ asset('') }}history/orders" class="btn btn-light w-md waves-effect waves-light">بازگشت به سفارشات</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

