@extends('user.layouts.master')
@section('title', 'تیکت: '.$ticket->title)

@section('content')

    <div class="w-100 user-chat">
        <div class="card">
            <div class="p-4 border-bottom ">
                <div class="row">
                    <div class="col-md-4 col-9">
                        <h5 class="font-size-15 mb-1">عنوان تیکت: {{$ticket->title}}</h5>
                        <p class="text-muted mb-0"><i class="mdi mdi-circle text-success align-middle me-1"></i> آنلاین</p>
                    </div>
                    <div class="col-md-8 col-3">
                        <ul class="list-inline user-chat-nav text-end mb-0">
                            <li class="list-inline-item">
                                <button class="btn btn-light dropdown-toggle" type="button" data-bs-toggle="modal" data-bs-target="#myModal">
                                    <i class="bx bx-info-circle me-sm-1"></i><span class="d-none d-sm-inline-block"> اطلاعات تیکت</span>
                                </button>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div>
                <div class="chat-conversation p-3" id="chat">
                    <ul class="list-unstyled mb-0" id="chat-list" dxata-simplebarxx style="max-height: 486px;">
                        <li>
                            <div class="chat-day-title">
                                <span class="title">تاریخچه ی گفتگو</span>
                            </div>
                        </li>
                        @foreach($ticket_message as $message)
                            @if($message->author=='admin')
                                <li class="right">
                                    <div class="conversation-list">
                                        <div class="ctext-wrap">
                                            <div class="conversation-name mb-3">پشتیبان</div>
                                            <p>
                                                {!! nl2br($message->message) !!}
                                            </p>
                                            <p class="chat-time mb-0"><i class="bx bx-time-five align-middle me-1"></i>{{$message->time}}</p>
                                        </div>
                                    </div>
                                </li>
                                @if($message->file_link)
                                <li class="right">
                                    <div class="conversation-list">
                                        <div class="ctext-wrap">
                                            <a href="{{asset('')}}{{$message->file_link}}"><span>دانلود فایل ضمیمه</span></a>
                                        </div>
                                    </div>
                                </li>
                                @endif
                            @else
                                <li>
                                    <div class="conversation-list">
                                        <div class="ctext-wrap">
                                            <div class="conversation-name mb-3">{{Auth::user()->name .' '.Auth::user()->family }}</div>
                                            <p>
                                                {!! nl2br($message->message) !!}
                                            </p>
                                            <p class="chat-time mb-0"><i class="bx bx-time-five align-middle me-1"></i>{{$message->time}}</p>
                                        </div>
                                    </div>
                                </li>
                                @if($message->file_link)
                                    <li>
                                        <div class="conversation-list">
                                            <div class="ctext-wrap">
                                                <a href="{{asset('')}}{{$message->file_link}}" target="_blank"><i class="bx bx-cloud-download align-middle me-1"></i><span>دانلود فایل ضمیمه</span></a>
                                            </div>
                                        </div>
                                    </li>
                                @endif
                            @endif
                        @endforeach
                    </ul>
                </div>
                <div class="p-3 chat-input-section">
                    <form autocomplete="off" method="post" class="chat-app-input needs-validation @if($ticket->status==3) d-none @endif" novalidate action="" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <div class="col">
                                <div class="position-relative">
                                    <textarea class="form-control chat-input" rows="3" placeholder="متن پاسخ تیکت ..." name="message" id="message" required></textarea>
                                </div>
                            </div>
                            {{--<div class="chat-input-links" id="tooltip-container">
                                <lable>انتخاب فایل</lable>
                                <ul class="list-inline mb-0">
                                    <input type="file" class="custom-file-input" name="file" id="file" accept="image/*,.doc,.docx,.pdf,application/zip,.rar">
                                </ul>
                            </div>--}}
                            <div class="col-auto">
                                <button type="submit" class="btn btn-primary btn-rounded chat-send w-md waves-effect waves-light"><span class="d-none d-sm-inline-block me-2">ارسال</span> <i class="mdi mdi-send"></i></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!--  Ticket Information -->
    <div id="myModal" class="modal fade" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel">اطلاعات تیکت</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-muted text-center">
                        <p class="mb-2">تاریخ ایجاد</p>
                        <h6>{{$ticket->created}}</h6>
                        <p class="mt-4 mb-0">وضعیت تیکت
                        @if($ticket->status == 0)
                            <span class="badge badge-soft-warning">منتظر پاسخ</span>
                        @elseif($ticket->status == 1)
                            <span class="badge badge-soft-success">پاسخ داده شده</span>
                        @else
                            <span class="badge badge-soft-danger">بسته</span>
                            @endif
                        </p>
                    </div>
                    <div class="table-responsive mt-4">
                        <table class="table align-middle mb-0">
                            <tbody>
                            <tr>
                                <td>
                                    <p class="text-muted mb-0">آخرین بروزرسانی</p>
                                </td>
                                <td>
                                    <div id="radialchart-1" class="apex-charts"></div>
                                </td>
                                <td>
                                    <h6 class="mb-0">{{$ticket->updated}}</h6>
                                </td>
                            </tr>
                            @if(isset($order))
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">مربوط به سفارش</p>
                                    </td>
                                    <td>
                                        <div id="radialchart-1" class="apex-charts"></div>
                                    </td>
                                    <td>
                                        <a href="{{asset('')}}orders/{{$order->id}}">
                                            <h6 class="mb-0">{{$order->title}}</h6>
                                        </a>
                                    </td>
                                </tr>
                            @endif
                            <tr>
                                <td>
                                    <p class="text-muted mb-0">تعداد پیام‌ها</p>
                                </td>
                                <td>
                                    <div id="radialchart-1" class="apex-charts"></div>
                                </td>
                                <td>
                                    <h6 class="mb-0">{{count($ticket_message)}}</h6>
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('script')
<script>


    $(document).ready(function () {
        var el = new SimpleBar(document.getElementById('chat-list'), { autoHide: false });
        el.getScrollElement().scrollTo(0, el.getScrollElement().scrollHeight);
        console.log(el.getScrollElement().scrollHeight);
        // bind 'myForm' and provide a simple callback function
        var bar = $('.progress-bar');
        var percent = $('.progress-bar');

        $('form').ajaxForm({
            beforeSend: function (xhr, opts) {
                if($('#file').val()!=""){
                    var file = $('#file')[0].files[0];
                    if(file.size>=5300000) {
                        swal.fire({
                            type: 'warning',
                            title: "توجه",
                            html: 'حداکثر مجاز حجم فایل 5 مگابایت است.',
                            confirmButtonText: "تایید",
                        });
						xhr.abort();
                        return false
                    }
                }
                loading();
                $('form button').attr('disabled','disabled');
                $('form').addClass('disable-block');

                if($('#file').val()!="")
                    $('.progress').fadeIn();

                var percentVal = '0%';
                bar.css('width',percentVal+'%');
                percent.html(percentVal);

            },
            uploadProgress: function (event, position, total, percentComplete) {
                var percentVal = percentComplete-3 + '%';
                bar.width(percentVal);
                percent.html(percentVal);
            },
            complete: function (data) {
                bar.css('width','100%');
                percent.html(100);

                data = data.responseJSON;
                $('form').removeClass('disable-block');
                if (data.status == true) {
                    swal.fire({
                        type: 'success',
                        title: "انجام شد",
                        html: data.message,
                        confirmButtonText: "تایید",
                        onClose: () => {
                            location.reload();
                        }
                    });
                } else {
                    swal.fire({
                        type: 'error',
                        title: "توجه",
                        html: data.message,
                        confirmButtonText: "تایید",
                    })
                    $('.progress').fadeOut();
                }
                $('form button').removeAttr('disabled');
                unloading();
            }
        });
    });
</script>
@stop
