    <div class="row">
        <div class="col-md-12 text-left text-primary">
            <b><i class="ft-hash"></i> شماره تراکنش:</b>
            #{{($result->finance->id)}}
        </div>

        <div class="col-md-12 text-left mt-1">
            <b><i class="ft-airplay"></i> وضعیت:</b>
            @if($result->finance->status =='در دست اقدام')
            <span class="badge badge-pill badge-warning mx-1 font-weight-light">در دست اقدام</span>
            @elseif($result->finance->status =='رد شده')
            <span class="badge badge-pill badge-danger mx-1 font-weight-light">رد شده</span>
            @elseif($result->finance->status =='معلق,پرداخت شده' || $result->finance->status =='معلق,عودت')
            <span class="badge badge-pill badge-dark px-4 m-1 font-weight-light">معلق</span>
            <span class="badge badge-pill badge-success mx-1 font-weight-light">{{substr($result->finance->status, strpos($result->finance->status, ",") + 1)}}</span>
            @else
            <span class="badge badge-pill badge-success mx-1 font-weight-light">{{$result->finance->status}}</span>
            @endif
        </div>
        <div class="col-md-12 text-left mt-1">
            <b><i class="ft-cpu"></i> مبلغ:</b>
            {{number_format($result->finance->amount)}} تومان
        </div>
        <div class="col-md-12 text-left mt-1">
            <b><i class="ft-activity"></i> موجودی بعد از این تراکنش:</b>
            {{number_format($result->finance->stock)}} تومان
        </div>
    </div>

    <hr width="20%">

    <div class="row">
        <div class="col-md-6">
            <h5>مشخصات مشتری: </h5>
            <p class="mb-1">{{$result->user->name .' '.$result->user->family}}</p>
            <p class="">{{$result->user->address}}</p>
        </div>
        <div class="col-md-6">
            <h5>اطلاعات تماس مشتری: </h5>
            <p class="mb-1">موبایل: {{$result->user->mobile}}</p>
        </div>
    </div>
    <hr width="40%">
    <div class="row">
        <div class="col-md-12 text-left">
            <h5>توضیحات: </h5>
            <p class="mb-1">{{$result->finance->description}}</p>
        </div>
    </div>


    <hr width="70%">
    @if($result->finance->status=='معلق,پرداخت شده')
        <p class="text-center">
        این تراکنش به علت اینکه از کارتی غیر از کارت های تایید شده، پرداخت شده است به کیف پول شما افزوده نشده و جهت پیگیری مبلغ واریز شده به تیکتی که اتوماتیک ایجاد شده است مراجعه نمایید.
        </p>
    @elseif($result->finance->status=='معلق,عودت')
        <p class="text-center">
        این تراکنش به علت اینکه از کارتی غیر از کارت های تایید شده، پرداخت شده است به کیف پول شما افزوده نشده و اکنون توسط ادمین <b>مبلغ تراکنش به کیف پول شما با موفقیت اضافه شد.</b>
        </p>
    @elseif($result->finance->status=='در دست اقدام' | $result->finance->status=='رد شده')
        <div class="row text-left">
            <div class="col-md-4">
                <p class="font-weight-bold">شماره کارت انتخابی:</p>
            </div>
            <div class="col-md-8 text-center">
                <p>{{$result->cardbank->card_number}}</p>
            </div>
        </div>
    @endif





