
// ===================================
// Trading Platform Routes (CoinEx Integration)
// ===================================

// Trading Page
Route::get('/trading/{market?}', 'User\TradingController@index')->name('trading')->middleware('auth');

// Real-time Data API
Route::group(['prefix' => 'api/realtime', 'namespace' => 'Api'], function() {
    Route::get('/ticker/{market}', 'TradingDataController@getTicker');
    Route::get('/orderbook/{market}', 'TradingDataController@getOrderBook');
    Route::get('/tickers', 'TradingDataController@getAllTickers');
    Route::get('/summary/{market}', 'TradingDataController@getMarketSummary');
    Route::get('/stream/{market}', 'TradingDataController@streamTicker'); // SSE
});

// Trading API Endpoints
Route::group(['prefix' => 'api/trading', 'namespace' => 'User', 'middleware' => 'auth'], function() {
    // Order Management
    Route::post('/order/limit', 'TradingController@placeLimitOrder');
    Route::post('/order/market', 'TradingController@placeMarketOrder');
    Route::post('/order/cancel', 'TradingController@cancelOrder');
    
    // Data Retrieval
    Route::get('/orderbook/{market}', 'TradingController@getOrderBook');
    Route::get('/my-orders', 'TradingController@getMyOrders');
    Route::get('/my-trades', 'TradingController@getMyTrades');
});

// Crypto Wallet Management
Route::group(['prefix' => 'crypto-wallet', 'namespace' => 'User', 'middleware' => 'auth'], function() {
    Route::get('/', 'CryptoWalletController@index')->name('crypto.wallet');
    Route::get('/balances', 'CryptoWalletController@getBalances');
    Route::get('/balance/{currency}', 'CryptoWalletController@getBalance');
    Route::post('/sync', 'CryptoWalletController@syncBalances');
});
