<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="rtl">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('images/logo/SVGFLAT.svg')); ?>">
    <link rel="manifest" href="<?php echo e(asset('')); ?>js/manifest.json">
    <meta name="_token" content="<?php echo e(csrf_token()); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="url" content="<?php echo e(asset('')); ?>">
    <link href="https://fonts.googleapis.com/css?family=Muli:300,300i,400,400i,600,600i,700,700i%7CComfortaa:300,400,700"
          rel="stylesheet">

    <!-- Bootstrap Css -->
    <?php if(getSetting('user_theme_color') == 'light'): ?>
        <link href="<?php echo e(asset('css/bootstrap-rtl.min.css')); ?>" id="bootstrap-style" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset('css/app-rtl.min.css')); ?>" id="app-style" rel="stylesheet" type="text/css" />
    <?php elseif(getSetting('user_theme_color') == 'dark'): ?>
        <link href="<?php echo e(asset('assets/css/bootstrap-dark-rtl.min.css')); ?>" id="bootstrap-style" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(asset('assets/css/app-dark-rtl.min.css')); ?>" id="app-style" rel="stylesheet" type="text/css" />
    <?php endif; ?>
    <link href="<?php echo e(asset('/assets/libs/sweetalert2/sweetalert2.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="<?php echo e(asset('css/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- Fonts Css-->
    <link href="<?php echo e(asset('css/font_iransans.css')); ?>" rel="stylesheet" type="text/css" />

    <?php echo $__env->yieldContent('css'); ?>
</head>

<body data-sidebar="dark" style="font-family: IRANSans !important;">
    <div id="layout-wrapper">
        <header id="page-topbar">
            <div class="navbar-header">
                <div class="d-flex">
                    <div class="navbar-brand-box">
                        <a href="<?php echo e(asset('')); ?>" class="logo logo-dark">
                            <span class="logo-sm">
                                <img src="<?php echo e(asset('images/logo/logo-dark.svg')); ?>" alt="" height="40">
                            </span>
                            <span class="logo-lg">
                                <img src="<?php echo e(asset('images/logo/logo-dark.svg')); ?>" alt="" height="40">
                            </span>
                        </a>
                        <a href="<?php echo e(asset('')); ?>" class="logo logo-light">
                            <span class="logo-sm">
                                <img src="<?php echo e(asset('images/logo/logo-dark.svg')); ?>" alt="" height="40">
                            </span>
                            <span class="logo-lg">
                                <img src="<?php echo e(asset('images/logo/logo-dark.svg')); ?>" alt="" height="40">
                            </span>
                        </a>
                    </div>
                    <button type="button" class="btn btn-sm px-3 font-size-16 header-item waves-effect" id="vertical-menu-btn">
                        <i class="fa fa-fw fa-bars"></i>
                    </button>
                    <form class="app-search d-none d-lg-block">
                        <div class="position-relative">
                            <input type="text" class="form-control" placeholder="جست و جو کنید ...">
                            <span class="bx bx-search-alt"></span>
                        </div>
                    </form>
                </div>
                <div class="d-flex">
                    <div class="dropdown d-inline-block d-lg-none ms-2">
                        <button type="button" class="btn header-item noti-icon waves-effect" id="page-header-search-dropdown"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="mdi mdi-magnify"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0"
                             aria-labelledby="page-header-search-dropdown">

                            <form class="p-3">
                                <div class="form-group m-0">
                                    <div class="input-group">
                                        <input type="text" class="form-control" placeholder="جست و جو کنید ..." aria-label="Recipient's username">
                                        <div class="input-group-append">
                                            <button class="btn btn-primary" type="submit"><i class="mdi mdi-magnify"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="dropdown d-none d-lg-inline-block ms-1">
                        <button type="button" class="btn header-item noti-icon waves-effect"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="bx bx-customize"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                            <div class="px-lg-2">
                                <div class="row g-0">
                                    <div class="col">
                                        <a class="dropdown-icon-item" href="<?php echo e(getSetting('social_network_twitter')); ?>" target="_blank">
                                            <img src="<?php echo e(asset('images/brands/twitter.svg')); ?>" alt="twitter">
                                            <span>توییتر</span>
                                        </a>
                                    </div>
                                    <div class="col">
                                        <a class="dropdown-icon-item" href="<?php echo e(getSetting('social_network_instagram')); ?>" target="_blank">
                                            <img src="<?php echo e(asset('images/brands/instagram.svg')); ?>" alt="instagram">
                                            <span>اینستاگرام</span>
                                        </a>
                                    </div>
                                    <div class="col">
                                        <a class="dropdown-icon-item" href="<?php echo e(getSetting('social_network_telegram')); ?>" target="_blank">
                                            <img src="<?php echo e(asset('images/brands/telegram.svg')); ?>" alt="telegram">
                                            <span>تلگرام</span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="dropdown d-none d-lg-inline-block ms-1">
                        <button type="button" class="btn header-item noti-icon waves-effect" data-toggle="fullscreen">
                            <i class="bx bx-fullscreen"></i>
                        </button>
                    </div>
                    <div class="dropdown d-inline-block">
                        <button type="button" class="btn header-item noti-icon waves-effect" id="page-header-notifications-dropdown"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="bx bx-bell bx-tada"></i>

                            <?php if(($SumNotification = config('notification.CountInvitationFinance') + config('notification.CountInvitation') + config('notification.CountWallet') + config('notification.CountTicket') + config('notification.CountOrdersSellPaymentCard')) > 0): ?>
                            <span class="badge bg-danger rounded-pill">
                                <?php echo e($SumNotification); ?>

                            </span>
                            <?php endif; ?>
                        </button>
                        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0"
                             aria-labelledby="page-header-notifications-dropdown">
                            <div class="p-3">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h6 class="m-0">اطلاعیه‌ها</h6>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <ul class="py-0 list-unstyled">
                                    <li class="w-100">
                                        <?php if($SumNotification == 0): ?>
                                            <div class="media">
                                                <div class="media-body">
                                                    <h6 class="media-heading text-center text-muted mb-0">
                                                        اطلاعیه ای موجود نیست!
                                                    </h6>
                                                </div>
                                            </div>
                                        <?php else: ?>

                                            <?php if(config('notification.CountTicket')>0): ?>
                                                <a href="<?php echo e(asset('')); ?>ticket" class="text-reset notification-item" data-sort='<?php echo e(config('notification.SortTicket')); ?>'>
                                                    <div class="d-flex">
                                                        <div class="avatar-xs me-3">
                                                                <span class="avatar-title bg-success rounded-circle font-size-16">
                                                                    <i class="bx bx-message"></i>
                                                                </span>
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <h6 class="mb-1">
                                                                <span class="badge bg-warning float-right">
                                                                    <?php echo e(config('notification.CountTicket')); ?>

                                                                </span>
                                                                تیکت خوانده نشده
                                                            </h6>
                                                            <div class="font-size-12 text-muted">
                                                                <p class="mb-1" key="t-grammer"><?php echo e(config('notification.SubjectTicket')); ?></p>
                                                                <p class="mb-0"><i class="mdi mdi-clock-outline"></i> <span key="t-min-ago"><?php echo e(config('notification.TimeTicket')); ?></span></p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </a>
                                            <?php endif; ?>

                                            <?php if(config('notification.CountOrdersSellPaymentCard')>0): ?>
                                                <a href="<?php echo e(asset('')); ?>history/orders" data-sort='<?php echo e(config('notification.SortOrdersSellPaymentCard')); ?>'>
                                                    <div class="media w-100">
                                                        <div class="media-left align-self-center">
                                                            <i class="icon-check success font-medium-4 mt-2"></i>
                                                        </div>
                                                        <div class="media-body">
                                                            <h6 class="media-heading success mb-0">
                                                                <span class="badge badge-pill badge-sm badge-success badge-glow float-right">
                                                                    <?php echo e(config('notification.CountOrdersSellPaymentCard')); ?>

                                                                </span>
                                                                تایید سفارش
                                                            </h6>
                                                            <p class="notification-text font-small-3 text-muted mb-0">
                                                                <?php echo e(config('notification.SubjectOrdersSellPaymentCard')); ?>

                                                            </p>
                                                            <small class="float-right">
                                                                <time class="media-meta text-muted">
                                                                    <?php echo e(config('notification.TimeOrdersSellPaymentCard')); ?>

                                                                </time>
                                                            </small>
                                                        </div>
                                                    </div>
                                                </a>
                                            <?php endif; ?>

                                            <?php if(config('notification.CountWallet')>0): ?>
                                                <a href="<?php echo e(asset('')); ?>wallet" data-sort='<?php echo e(config('notification.SortWallet')); ?>'>
                                                    <div class="media w-100">
                                                        <div class="media-left align-self-center">
                                                            <i class="icon-credit-card success font-medium-4 mt-2"></i>
                                                        </div>
                                                        <div class="media-body">
                                                            <h6 class="media-heading success mb-0">
                                                                <span class="badge badge-pill badge-sm badge-success badge-glow float-right">
                                                                    <?php echo e(config('notification.CountWallet')); ?>

                                                                </span>
                                                                واریز انجام شد
                                                            </h6>
                                                            <p class="notification-text font-small-3 text-muted mb-0">
                                                                <?php echo e(config('notification.SubjectWallet')); ?>

                                                            </p>
                                                            <small class="float-right">
                                                                <time class="media-meta text-muted">
                                                                    <?php echo e(config('notification.TimeWallet')); ?>

                                                                </time>
                                                            </small>
                                                        </div>
                                                    </div>
                                                </a>
                                            <?php endif; ?>

                                            <?php if(config('notification.CountInvitation')>0): ?>
                                                <a href="<?php echo e(asset('')); ?>invitation" data-sort='<?php echo e(config('notification.SortInvitation')); ?>'>
                                                    <div class="media w-100">
                                                        <div class="media-left align-self-center">
                                                            <i class="icon-user-follow primary font-medium-4 mt-2"></i>
                                                        </div>
                                                        <div class="media-body">
                                                            <h6 class="media-heading primary mb-0">
                                                                <span class="badge badge-pill badge-sm badge-primary badge-glow float-right">
                                                                    <?php echo e(config('notification.CountInvitation')); ?>

                                                                </span>
                                                                معرفی دوست شما
                                                            </h6>
                                                            <p class="notification-text font-small-3 text-muted mb-0">
                                                                <?php echo e(config('notification.SubjectInvitation')); ?>

                                                            </p>
                                                            <small class="float-right">
                                                                <time class="media-meta text-muted">
                                                                    <?php echo e(config('notification.TimeInvitation')); ?>

                                                                </time>
                                                            </small>
                                                        </div>
                                                    </div>
                                                </a>
                                            <?php endif; ?>

                                            <?php if(config('notification.CountInvitationFinance')>0): ?>
                                                <a href="<?php echo e(asset('')); ?>invitation" data-sort='<?php echo e(config('notification.SortInvitationFinance')); ?>'>
                                                    <div class="media w-100">
                                                        <div class="media-left align-self-center">
                                                            <i class="icon-wallet danger font-medium-4 mt-2"></i>
                                                        </div>
                                                        <div class="media-body">
                                                            <h6 class="media-heading danger mb-0">
                                                                    <span class="badge badge-pill badge-sm badge-danger badge-glow float-right">
                                                                        <?php echo e(config('notification.CountInvitationFinance')); ?>

                                                                    </span>
                                                                پورسانت خرید دوستتان
                                                            </h6>
                                                            <p class="notification-text font-small-3 text-muted mb-0">
                                                                <?php echo e(config('notification.SubjectInvitationFinance')); ?>

                                                            </p>
                                                            <small class="float-right">
                                                                <time class="media-meta text-muted">
                                                                    <?php echo e(config('notification.TimeInvitationFinance')); ?>

                                                                </time>
                                                            </small>
                                                        </div>
                                                    </div>
                                                </a>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="dropdown d-inline-block">
                        <button type="button" class="btn header-item waves-effect" id="page-header-user-dropdown"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <img class="rounded-circle header-profile-user" src="<?php echo e(asset('images/users/user.png')); ?>"
                                 alt="Header Avatar">
                            <span class="d-none d-xl-inline-block ms-1" key="t-henry"><?php echo e(Auth::user()->name); ?></span>
                            <i class="mdi mdi-chevron-down d-none d-xl-inline-block"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-end">
                            <!-- item-->
                            <a class="dropdown-item" href="<?php echo e(asset('')); ?>profile">
                                <i class="bx bx-user font-size-16 align-middle me-1"></i>
                                <span key="t-profile">پروفایل</span>
                            </a>
                            <a class="dropdown-item d-block" href="<?php echo e(asset('')); ?>profile/password">
                                <i class="bx bx-wrench font-size-16 align-middle me-1"></i>
                                <span key="t-settings">کلمه عبور</span>
                            </a>
                            <a class="dropdown-item" href="<?php echo e(asset('')); ?>profile/two-factor-authentication">
                                <i class="bx bx-lock-open font-size-16 align-middle me-1"></i>
                                <span>ورود دو مرحله‌ای</span>
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item text-danger" href="#" onclick="event.preventDefault();document.getElementById('logout-form').submit();">
                                <i class="bx bx-power-off font-size-16 align-middle me-1 text-danger"></i>
                                <span key="t-logout">خروج</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <?php echo $__env->make('user.layouts.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- BEGIN: Content-->
        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
        <!-- END: Content-->

        <?php echo $__env->make('user.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php if(config('popup')!=''): ?>
            <div class="modal fade" id="popup" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel"></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body text-left">
                            <?php echo config('popup'); ?>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-light" data-bs-dismiss="modal">بستن</button>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <form id="logout-form" action="<?php echo e(url('logout')); ?>" method="POST" style="display: none;">
            <?php echo e(csrf_field()); ?>

        </form>

        <!-- JAVASCRIPT -->
        <script src="<?php echo e(asset('js/jquery.min.js')); ?>" type="text/javascript"></script>
        <script src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>" type="text/javascript"></script>
        <script src="<?php echo e(asset('js/metisMenu.min.js')); ?>" type="text/javascript"></script>
        <script src="<?php echo e(asset('js/simplebar.min.js')); ?>" type="text/javascript"></script>
        <script src="<?php echo e(asset('js/waves.min.js')); ?>" type="text/javascript"></script>
        <script src="<?php echo e(asset('js/sweetalert2.min.js')); ?>" type="text/javascript"></script>
        <script src="<?php echo e(asset('js/jquery.form.min.js')); ?>" type="text/javascript"></script>

        <!-- App js -->
        <script src="<?php echo e(asset('js/app.js')); ?>"></script>
        <script src="<?php echo e(asset('js/arzland.js')); ?>"></script>
        <?php echo $__env->yieldContent('js'); ?>
        <?php echo $__env->yieldContent('script'); ?>

        <?php if(Session::has('Success')): ?>
            <script>
                toastr.success("<?php echo e(Session::get('Success')); ?>", "انجام شد!", {
                    positionClass: "toast-bottom-center",
                    progressBar: !0,
                })
            </script>
        <?php endif; ?>
        <?php if(Session::has('Error')): ?>
            <script>
                toastr.error("<?php echo e(Session::get('Error')); ?>", "خطا!", {
                    positionClass: "toast-bottom-center",
                    progressBar: !0,
                })
            </script>
        <?php endif; ?>
        <script type="text/javascript">

            $(window).on("load", function () {
                $("#loader").fadeOut();
                $("#preloader").delay(500).fadeOut("slow");
            });

            <?php if(config('popup')!=''): ?>
            setTimeout(function () {
                $('#popup').modal('show');
            }, 1500)
            <?php endif; ?>

        </script>
    </div>
</body>
</html>
<?php /**PATH /Users/webcore-heydari/Downloads/platform/resources/views/user/layouts/master.blade.php ENDPATH**/ ?>