<?php $__env->startSection('title', 'پنل کاربری ادمین'); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('')); ?>app-assets/vendors/css/charts/chartist.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('')); ?>app-assets/vendors/css/charts/chartist-plugin-tooltip.css">

    <style>
        .height-500 {
            height: 500px !important;
        }
        .height-400 {
            height: 400px !important;
        }
        .height-300 {
            height: 300px !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">داشبورد ادمین</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12">
            <div class="row">
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">موجودی کل کاربران</p>
                                    <h5 class="mb-0"><?php echo e(number_format($result->WalletTotal)); ?> <span class="small text-muted">تومان</span></h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-primary font-size-20">
                                        <i class="bx bxs-wallet"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">مبلغ کل خرید ها</p>
                                    <h5 class="mb-0"><?php echo e(number_format($result->BuyAmountTotal)); ?> <span class="small text-muted">تومان</span></h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-primary font-size-20">
                                        <i class="bx bxs-shopping-bag"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">مبلغ کل فروش ها</p>
                                    <h5 class="mb-0"><?php echo e(number_format($result->SellAmountTotal)); ?> <span class="small text-muted">تومان</span></h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-primary font-size-20">
                                        <i class="bx bxs-up-arrow-circle"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">مبلغ کل سفارشات</p>
                                    <h5 class="mb-0"><?php echo e(number_format($result->OrderAmountTotal)); ?> <span class="small text-muted">تومان</span></h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-primary font-size-20">
                                        <i class="bx bxs-calculator"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12">
            <div class="row">
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">تعداد کل کاربران</p>
                                    <h5 class="mb-0"><?php echo e($result->UserTotal); ?></h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-primary font-size-20">
                                        <i class="bx bxs-user"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">تعداد کل خریدها</p>
                                    <h5 class="mb-0"><?php echo e($result->BuyTotal); ?></h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-primary font-size-20">
                                        <i class="bx bxs-shopping-bag"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">تعداد کل فروش ها</p>
                                    <h5 class="mb-0"><?php echo e($result->SellTotal); ?></h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-primary font-size-20">
                                        <i class="bx bxs-up-arrow-circle"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">تعداد کل سفارشات</p>
                                    <h5 class="mb-0"><?php echo e($result->OrderTotal); ?></h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-primary font-size-20">
                                        <i class="bx bxs-calculator"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card">
            <div class="card-body">
                <h4 class="card-title">آمار کلی سایت</h4>
                <div class="table-responsive">
                    <table class="table mb-0">
                        <thead class="table-light">
                        <tr>
                            <th>عنوان</th>
                            <th>امروز</th>
                            <th>دیروز</th>
                            <th>هفته جاری</th>
                            <th>ماه جاری</th>
                            <th>سال جاری</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <th scope="row">تعداد سفارشات</th>
                            <td><?php echo e($result->Today->CountOrders); ?></td>
                            <td><?php echo e($result->Yesterday->CountOrders); ?></td>
                            <td><?php echo e($result->Week->CountOrders); ?></td>
                            <td><?php echo e($result->Month->CountOrders); ?></td>
                            <td><?php echo e($result->Year->CountOrders); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ سفارشات</th>
                            <td><?php echo e(number_format($result->Today->AmountOrders)); ?></td>
                            <td><?php echo e(number_format($result->Yesterday->AmountOrders)); ?></td>
                            <td><?php echo e(number_format($result->Week->AmountOrders)); ?></td>
                            <td><?php echo e(number_format($result->Month->AmountOrders)); ?></td>
                            <td><?php echo e(number_format($result->Year->AmountOrders)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">تعداد فروش</th>
                            <td><?php echo e(($result->Today->CountOrdersSell)); ?></td>
                            <td><?php echo e(($result->Yesterday->CountOrdersSell)); ?></td>
                            <td><?php echo e(($result->Week->CountOrdersSell)); ?></td>
                            <td><?php echo e(($result->Month->CountOrdersSell)); ?></td>
                            <td><?php echo e(($result->Year->CountOrdersSell)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ فروش</th>
                            <td><?php echo e(number_format($result->Today->AmountOrdersSell)); ?></td>
                            <td><?php echo e(number_format($result->Yesterday->AmountOrdersSell)); ?></td>
                            <td><?php echo e(number_format($result->Week->AmountOrdersSell)); ?></td>
                            <td><?php echo e(number_format($result->Month->AmountOrdersSell)); ?></td>
                            <td><?php echo e(number_format($result->Year->AmountOrdersSell)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">تعداد خرید</th>
                            <td><?php echo e(($result->Today->CountOrdersBuy)); ?></td>
                            <td><?php echo e(($result->Yesterday->CountOrdersBuy)); ?></td>
                            <td><?php echo e(($result->Week->CountOrdersBuy)); ?></td>
                            <td><?php echo e(($result->Month->CountOrdersBuy)); ?></td>
                            <td><?php echo e(($result->Year->CountOrdersBuy)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ خرید</th>
                            <td><?php echo e(number_format($result->Today->AmountOrdersBuy)); ?></td>
                            <td><?php echo e(number_format($result->Yesterday->AmountOrdersBuy)); ?></td>
                            <td><?php echo e(number_format($result->Week->AmountOrdersBuy)); ?></td>
                            <td><?php echo e(number_format($result->Month->AmountOrdersBuy)); ?></td>
                            <td><?php echo e(number_format($result->Year->AmountOrdersBuy)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">کاربر جدید</th>
                            <td><?php echo e(($result->Today->CountUser)); ?></td>
                            <td><?php echo e(($result->Yesterday->CountUser)); ?></td>
                            <td><?php echo e(($result->Week->CountUser)); ?></td>
                            <td><?php echo e(($result->Month->CountUser)); ?></td>
                            <td><?php echo e(($result->Year->CountUser)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ بیشترین فروش</th>
                            <td><?php echo e(number_format($result->Today->AmountMaxSell)); ?></td>
                            <td><?php echo e(number_format($result->Yesterday->AmountMaxSell)); ?></td>
                            <td><?php echo e(number_format($result->Week->AmountMaxSell)); ?></td>
                            <td><?php echo e(number_format($result->Month->AmountMaxSell)); ?></td>
                            <td><?php echo e(number_format($result->Year->AmountMaxSell)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ بیشترین خرید</th>
                            <td><?php echo e(number_format($result->Today->AmountMaxBuy)); ?></td>
                            <td><?php echo e(number_format($result->Yesterday->AmountMaxBuy)); ?></td>
                            <td><?php echo e(number_format($result->Week->AmountMaxBuy)); ?></td>
                            <td><?php echo e(number_format($result->Month->AmountMaxBuy)); ?></td>
                            <td><?php echo e(number_format($result->Year->AmountMaxBuy)); ?></td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12">
            <div class="row">
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">تعداد کل تیکت ها</p>
                                    <h5 class="mb-0"><?php echo e($result->TicketTotal); ?> </h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-success font-size-20">
                                        <i class="bx bxs-message"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">معرفی شدگان</p>
                                    <h5 class="mb-0"><?php echo e($result->UserInvitation); ?> </h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-warning font-size-20">
                                        <i class="bx bxs-group"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">کارتهای بانکی</p>
                                    <h5 class="mb-0"><?php echo e($result->CardBankTotal); ?> </h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-primary font-size-20">
                                        <i class="bx bxs-credit-card"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">کاربران فعال</p>
                                    <h5 class="mb-0"><?php echo e($result->UsersActive); ?> </h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-dark font-size-20">
                                        <i class="bx bxs-user"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-12">
            <div class="row">
                <div class="col-lg-6">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">تراکنش های کیف پول</p>
                                    <h5 class="mb-0"><?php echo e($result->FinanceTotal); ?> </h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-success font-size-20">
                                        <i class="bx bx-sort-down"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex flex-wrap">
                                <div class="me-3">
                                    <p class="text-muted mb-2">کاربران دارای موجودی</p>
                                    <h5 class="mb-0"><?php echo e($result->UserWallet); ?> </h5>
                                </div>
                                <div class="avatar-sm ms-auto">
                                    <div class="avatar-title bg-light rounded-circle text-warning font-size-20">
                                        <i class="bx bxs-wallet"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card o-hidden">
                <div class="card-body">
                    <div class="card-title">نمودار وضعیت سیستم </div>
                    <div class="height-500 overflow-scroll">
                        <canvas id="area-chart"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card o-hidden">
            <div class="card-body">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <?php $i = $j = 0; ?>
                    <?php $__currentLoopData = $result->Currencys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <a class="nav-link <?php if($i==$j): ?>active <?php endif; ?>" data-bs-toggle="tab" href="#<?php echo e($Currency); ?>" role="tab">
                                <img src="<?php echo e(asset('')); ?>app-assets/images/currency/<?php echo e(strtolower($Currency)); ?>.svg" style="width: 35px;">
                            </a>
                        </li>
                        <?php $i++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <div class="tab-content pb-0" id="myTabContent">
                    <?php $i = 0; ?>
                    <?php $__currentLoopData = $result->Currencys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tab-pane fade show <?php if($i==$j): ?>active <?php endif; ?>" id="<?php echo e($Currency); ?>" role="tabpanel" aria-labelledby="<?php echo e($Currency); ?>-tab">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                    <tr>
                                        <th scope="col"> ارز: <?php echo e($Currency); ?></th>
                                        <th scope="col">امروز</th>
                                        <th scope="col">دیروز</th>
                                        <th scope="col">هفته جاری</th>
                                        <th scope="col">ماه جاری</th>
                                        <th scope="col">سال جاری</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <th scope="row">تعداد سفارشات</th>
                                        <td><?php echo e($result->$Currency->Today->CountOrders); ?></td>
                                        <td><?php echo e($result->$Currency->Yesterday->CountOrders); ?></td>
                                        <td><?php echo e($result->$Currency->Week->CountOrders); ?></td>
                                        <td><?php echo e($result->$Currency->Month->CountOrders); ?></td>
                                        <td><?php echo e($result->$Currency->Year->CountOrders); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row">مبلغ سفارشات</th>
                                        <td><?php echo e($result->$Currency->Today->AmountOrders); ?></td>
                                        <td><?php echo e($result->$Currency->Yesterday->AmountOrders); ?></td>
                                        <td><?php echo e($result->$Currency->Week->AmountOrders); ?></td>
                                        <td><?php echo e($result->$Currency->Month->AmountOrders); ?></td>
                                        <td><?php echo e($result->$Currency->Year->AmountOrders); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row">تعداد خریدها</th>
                                        <td><?php echo e($result->$Currency->Today->CountOrdersBuy); ?></td>
                                        <td><?php echo e($result->$Currency->Yesterday->CountOrdersBuy); ?></td>
                                        <td><?php echo e($result->$Currency->Week->CountOrdersBuy); ?></td>
                                        <td><?php echo e($result->$Currency->Month->CountOrdersBuy); ?></td>
                                        <td><?php echo e($result->$Currency->Year->CountOrdersBuy); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row">تعداد فروش ها</th>
                                        <td><?php echo e(($result->$Currency->Today->CountOrdersSell)); ?></td>
                                        <td><?php echo e(($result->$Currency->Yesterday->CountOrdersSell)); ?></td>
                                        <td><?php echo e(($result->$Currency->Week->CountOrdersSell)); ?></td>
                                        <td><?php echo e(($result->$Currency->Month->CountOrdersSell)); ?></td>
                                        <td><?php echo e(($result->$Currency->Year->CountOrdersSell)); ?></td>
                                    </tr>
                                    <tr>
                                        <th scope="row">مبلغ کل خریدها</th>
                                        <td><?php echo e(number_format($result->$Currency->Today->AmountOrdersBuy)); ?> ($<?php echo e($result->$Currency->Today->dollarBuy); ?>)</td>
                                        <td><?php echo e(number_format($result->$Currency->Yesterday->AmountOrdersBuy)); ?> ($<?php echo e($result->$Currency->Yesterday->dollarBuy); ?>)</td>
                                        <td><?php echo e(number_format($result->$Currency->Week->AmountOrdersBuy)); ?> ($<?php echo e($result->$Currency->Week->dollarBuy); ?>)</td>
                                        <td><?php echo e(number_format($result->$Currency->Month->AmountOrdersBuy)); ?> ($<?php echo e($result->$Currency->Month->dollarBuy); ?>)</td>
                                        <td><?php echo e(number_format($result->$Currency->Year->AmountOrdersBuy)); ?> ($<?php echo e($result->$Currency->Year->dollarBuy); ?>)</td>
                                    </tr>
                                    <tr>
                                        <th scope="row">مبلغ کل فروش ها</th>
                                        <td><?php echo e(number_format($result->$Currency->Today->AmountOrdersSell)); ?> ($<?php echo e($result->$Currency->Today->dollarSell); ?>)</td>
                                        <td><?php echo e(number_format($result->$Currency->Yesterday->AmountOrdersSell)); ?> ($<?php echo e($result->$Currency->Yesterday->dollarSell); ?>)</td>
                                        <td><?php echo e(number_format($result->$Currency->Week->AmountOrdersSell)); ?> ($<?php echo e($result->$Currency->Week->dollarSell); ?>)</td>
                                        <td><?php echo e(number_format($result->$Currency->Month->AmountOrdersSell)); ?> ($<?php echo e($result->$Currency->Month->dollarSell); ?>)</td>
                                        <td><?php echo e(number_format($result->$Currency->Year->AmountOrdersSell)); ?> ($<?php echo e($result->$Currency->Year->dollarSell); ?>)</td>
                                    </tr>
                                    <tr>
                                        <th scope="row">بیشترین خرید</th>
                                        <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->$Currency->Today->IDMaxBuy); ?>"><?php echo e(number_format($result->$Currency->Today->AmountMaxBuy)); ?></a></td>
                                        <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->$Currency->Yesterday->IDMaxBuy); ?>"><?php echo e(number_format($result->$Currency->Yesterday->AmountMaxBuy)); ?></a></td>
                                        <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->$Currency->Week->IDMaxBuy); ?>"><?php echo e(number_format($result->$Currency->Week->AmountMaxBuy)); ?></a></td>
                                        <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->$Currency->Month->IDMaxBuy); ?>"><?php echo e(number_format($result->$Currency->Month->AmountMaxBuy)); ?></a></td>
                                        <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->$Currency->Year->IDMaxBuy); ?>"><?php echo e(number_format($result->$Currency->Year->AmountMaxBuy)); ?></a></td>
                                    </tr>
                                    <tr>
                                        <th scope="row">بیشترین فروش</th>
                                        <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->$Currency->Today->IDMaxSell); ?>"><?php echo e(number_format($result->$Currency->Today->AmountMaxSell)); ?></a></td>
                                        <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->$Currency->Yesterday->IDMaxSell); ?>"><?php echo e(number_format($result->$Currency->Yesterday->AmountMaxSell)); ?></a></td>
                                        <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->$Currency->Week->IDMaxSell); ?>"><?php echo e(number_format($result->$Currency->Week->AmountMaxSell)); ?></a></td>
                                        <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->$Currency->Month->IDMaxSell); ?>"><?php echo e(number_format($result->$Currency->Month->AmountMaxSell)); ?></a></td>
                                        <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->$Currency->Year->IDMaxSell); ?>"><?php echo e(number_format($result->$Currency->Year->AmountMaxSell)); ?></a></td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <?php $i++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">نمودار ارز ها</div>
                    <div class="height-300">
                        <canvas id="polar-chart"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">نمودار طریقه سفارش</div>
                    <div class="height-300">
                        <canvas id="stackedPie"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row mb-5">
        <div class="card">
            <div class="card-body text-center">
                <div class="card-title text-start mb-2">اطلاعات ارزهای دیجیتال فعال</div>
                <?php
                    $Currencys = $result->Currencys;
                    $count = count((array)$result->Currencys);
                    $i = 0; $j = 0;
                ?>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap" id="myTable">
                        <thead class="table-light">
                        <tr>
                            <th>لوگو</th>
                            <th>نام ارز</th>
                            <th>قیمت خرید</th>
                            <th>قیمت فروش</th>
                            <th>موجودی</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $Currencys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($Currency != 'PMvoucher'): ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(asset('')); ?><?php echo e($Currency); ?>">
                                            <img src="<?php echo e(asset('')); ?>app-assets/images/currency/<?php echo e(strtolower($Currency)); ?>.svg" width="35px">
                                        </a>
                                    </td>
                                    <td><?php echo e($Currency); ?></td>
                                    <td>
                                        <span class="m-0 font-weight-bold text-muted" id="fee_buy_<?php echo e(($Currency)); ?>">
                                            <div class="font-medium-1 spinner-border spinner-border-sm"></div>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="m-0 font-weight-bold text-muted" id="fee_sell_<?php echo e(($Currency)); ?>">
                                            <div class="font-medium-1 spinner-border spinner-border-sm"></div>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="blue-grey lighten-2" id="stock_<?php echo e(($Currency)); ?>">
                                            <div class="font-medium-1 spinner-border"></div>
                                        </span>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <div class="position-fixed" style="bottom: 70px; right: 30px">
        <button type="button" class="btn btn-success waves-effect btn-label waves-light"  data-bs-toggle="modal" data-bs-target="#myModal"><i class="bx bx-time label-icon"></i> دسترسی سریع</button>
    </div>
    <div id="myModal" class="modal fade" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form autocomplete="off" method="post" class="needs-validation" novalidate action="">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel">منو دسترسی سریع</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>توسط این بخش می توانید در سریع ترین زمان ممکن قیمت های خدمات خود را مشخص کنید</p>
                        <div class="mb-3">
                            <div class="bg-light text-center">
                                <h5 class="text-muted mb-0 py-2">قیمت تتر</h5>
                            </div>
                            <div class="row">
                                <div class="col-md-6 form-group mt-2">
                                    <label>قیمت خرید تتر </label>
                                    <input type="text" name="USDT_price_buy" id="USDT_price_buy"
                                           class="form-control text-center ltr-dir comma"
                                           placeholder="قیمت تتر" required value="<?php echo e(getSetting('USDT_price_buy')); ?>"/>
                                    <div class="invalid-feedback">قیمت خرید تتر را درج کنید</div>
                                </div>
                                <div class="col-md-6 form-group mt-2">
                                    <label>قیمت فروش تتر </label>
                                    <input type="text" name="USDT_price_sell" id="USDT_price_sell"
                                           class="form-control text-center ltr-dir comma"
                                           placeholder="قیمت تتر" required value="<?php echo e(getSetting('USDT_price_sell')); ?>"/>
                                    <div class="invalid-feedback">قیمت فروش تتر را درج کنید</div>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="bg-light text-center">
                                <h5 class="text-muted mb-0 py-2">هزینه کارمزدهای سایت</h5>
                            </div>
                            <div class="row">
                                <div class="col-md-6 form-group mt-2">
                                    <label>کارمزد خرید</label>
                                    <input type="text" name="buy_order_fee" id="buy_order_fee"
                                           class="form-control text-center ltr-dir comma"
                                           placeholder="درصد کارمزد خرید" required value="<?php echo e(getSetting('buy_order_fee')); ?>"/>
                                    <div class="invalid-feedback">درصد کارمزد خرید را درج کنید</div>
                                </div>
                                <div class="col-md-6 form-group mt-2">
                                    <label>کارمزد فروش</label>
                                    <input type="text" name="sell_order_fee" id="sell_order_fee"
                                           class="form-control text-center ltr-dir comma"
                                           placeholder="درصد کارمزد فروش" required value="<?php echo e(getSetting('sell_order_fee')); ?>"/>
                                    <div class="invalid-feedback">درصد کارمزد فروش را درج کنید</div>
                                </div>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="bg-light text-center">
                                <h5 class="text-muted mb-0 py-2">قیمت ارسال محصولات</h5>
                            </div>
                            <div class="row">
                                <div class="form-group mt-2">
                                    <label>قیمت ارسال محصولات</label>
                                    <input type="text" name="delivery_price" id="delivery_price"
                                           class="form-control text-center ltr-dir comma"
                                           placeholder="قیمت ارسال محصول" required value="<?php echo e(getSetting('delivery_price')); ?>"/>
                                    <div class="invalid-feedback">قیمت ارسال محصولات را درج کنید</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-light waves-effect" data-bs-dismiss="modal">بستن</button>
                        <button type="submit" class="btn btn-success waves-effect waves-light">ذخیره تغییرات</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('')); ?>app-assets/vendors/js/charts/chart.min.js" type="text/javascript"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>

        $(window).on("load", function() {
                var o=$("#area-chart");
                new Chart(o, {
                        type:"line", options: {
                            responsive:!0, maintainAspectRatio:!1,
                            legend: {
                                position: "bottom",
                                labels: {
                                    fontSize: 14,
                                    fontFamily: 'IRANSans',
                                }
                            }
                            , hover: {
                                mode: "label"
                            }
                            , scales: {
                                xAxes:[ {
                                    display:!0, gridLines: {
                                        color: "#f3f3f3", drawTicks: !0
                                    }
                                    , scaleLabel: {
                                        display: !1, labelString: "ماه",fontFamily: 'IRANSans'
                                    },
                                    ticks: {
                                        fontFamily: 'IRANSans',

                                    }
                                }
                                ], yAxes:[ {
                                    display:!0, gridLines: {
                                        color: "#f3f3f3", drawTicks: !1
                                    }
                                    , scaleLabel: {
                                        display: !0, labelString: "مقدار",fontFamily: 'IRANSans'
                                    }
                                }
                                ]
                            }
                            , title: {
                                display: !1, text: "نمودار خط Chart.js - افسانه"
                            },
                            tooltips: {
                                titleFontFamily: 'IRANSans',
                                bodyFontFamily: 'IRANSans',
                                titleMarginBottom: 10,
                                titleSpacing: 10
                            }
                        }
                        , data: {
                            labels:[<?php $__currentLoopData = $result->Label_CL; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> "<?php echo e($label); ?>", <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>],
                            datasets:[ {
                                label: "کاربر جدید",
                                data: [<?php $__currentLoopData = $result->UserAdd_CL; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($value); ?> , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>]
                                , backgroundColor: "rgba(209,212,219,.4)", borderColor: "transparent", pointBorderColor: "#D1D4DB", pointBackgroundColor: "#FFF", pointBorderWidth: 2, pointHoverBorderWidth: 2, pointRadius: 4
                            }
                                , {
                                    label: "مبلغ خرید(میلیون تومان)",
                                    data: [<?php $__currentLoopData = $result->AmountBuy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($value); ?> , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>]
                                    , backgroundColor: "rgba(255,113,103,0.6)", borderColor: "transparent", pointBorderColor: "#e01b07", pointBackgroundColor: "#FFF", pointBorderWidth: 2, pointHoverBorderWidth: 2, pointRadius: 4
                                }
                            , {
                                label: "مبلغ فروش(میلیون تومان)",
                                data: [<?php $__currentLoopData = $result->AmountSell; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($value); ?> , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>]
                            , backgroundColor: "rgba(0,43,255,0.6)", borderColor: "transparent", pointBorderColor: "#5175E0", pointBackgroundColor: "#FFF", pointBorderWidth: 2, pointHoverBorderWidth: 2, pointRadius: 4
                            }

                            ]
                        }
                    }
                )
            }

        );

        $(window).on("load", function() {
                var a=$("#polar-chart");
                new Chart(a, {
                        type:"pie",
                        options: {

                            responsive:!0, maintainAspectRatio:!1, responsiveAnimationDuration:500,
                            legend: {
                                position: "right",
                                labels: {
                                    fontSize: 14,
                                    fontFamily: 'IRANSans',
                                }
                            },
                            tooltips: {
                                titleFontFamily: 'IRANSans',
                                bodyFontFamily: 'IRANSans',
                                titleMarginBottom: 10,
                                titleSpacing: 10
                            }
                        }
                        , data: {
                            labels:[<?php $__currentLoopData = $result->PieCurrencyOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> "<?php echo e($Chart->orders_model); ?>", <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>], datasets:[ {
                                data: [<?php $__currentLoopData = $result->PieCurrencyOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>  <?php echo e($Chart->amount); ?> , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>],

                                backgroundColor: ["#fe9403", "#252525", "#009ddf", "#e6381c", "#aa1a03", "#fecc00" ,'#00cebe', '#7f2371' ,'#53ae94','#106db3'],
                            }
                            ]
                        }
                    }
                )
            }

        );



        $(window).on("load", function() {
                var a=$("#stackedPie");
                new Chart(a, {
                        type:"polarArea", options: {
                            responsive:!0, maintainAspectRatio:!1, responsiveAnimationDuration:500, legend: {
                                position: "top"
                            }
                            , title: {
                                display: !1, text: "Chart.js نمودار منطقه قطبی"
                            }
                            , scale: {
                                ticks: {
                                    beginAtZero: !0
                                }
                                , reverse:!1
                            }
                            , animation: {
                                animateRotate: !1
                            }
                        }
                        , data: {
                            labels:[<?php $__currentLoopData = $result->PieCurrencyVia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> "<?php echo e($Chart->via); ?>", <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>], datasets:[ {
                                data: [<?php $__currentLoopData = $result->PieCurrencyVia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($Chart->count); ?> , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>], backgroundColor: ["#639", "#63845", "#ebcb37", "#a1b968", "#0d94bc", "#135bba"]
                            }
                            ]
                        }
                    }
                )
            }

        );

        setTimeout(function(){
            $.post("<?php echo e(asset('').env('PanelPrefix')); ?>/stock",
                {_token: "<?php echo e(csrf_token()); ?>"},
                function(data){
                    var i=100;
                    $.each(data, function(k, v) {
                        $('#'+k).fadeOut(i,function() {
                            $('#'+k).html(v);
                            $('#'+k).fadeIn();
                        });
                        i = i+50;
                    });

                });
        }, 1000);

        $(document).ready(function () {
            $('form').ajaxForm({
                beforeSend: function () {
                    loading();
                },
                complete: function (data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            location.reload();
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    unloading();
                }
            });
        });

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>