<?php $__env->startSection('title', 'جزئیات سفارش '.$result->order->detail->type .' '. $result->order->detail->title); ?>
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <?php if($result->order->type == 'sell' && !isset($result->order->payment)): ?>
            <?php if($result->order->status == 'در حال پردازش'): ?>
                <div class="col-md-12 p-0">
                    <div class="alert alert-card alert-warning text-center" role="alert">
                        سفارش در انتظار بررسی شما و پرداخت میباشد.
                        <button onclick="confirm()" class="btn btn btn-info ml-1">پرداخت و تایید سفارش</button>
                        <button onclick="reject()" class="btn btn btn-danger ml-1">رد کردن سفارش</button>
                    </div>
                </div>
            <?php elseif($result->order->status == 'معلق'): ?>
                <div class="col-md-12 p-0">
                    <div class="alert alert-card alert-black text-center" role="alert">
                        این یک سفارش فروش معلق است اگر این سفارش را بررسی کردید میتوانید حذف نمایید.
                        <button onclick="remove()" class="btn btn btn-danger ml-1">حذف</button>
                    </div>
                </div>
            <?php else: ?>
                <div class="col-md-12 p-0">
                    <div class="alert alert-card alert-danger text-center" role="alert">
                        این سفارش را قبلا رد کرده اید و در صورت نیاز میتواننید تایید کنید
                        <button onclick="confirm()" class="btn btn btn-info ml-1">پرداخت و تایید سفارش</button>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <?php if($result->order->type == 'buy' && $result->order->status == 'در دست اقدام'): ?>
            <div class="col-md-12 p-0">
                <div class="alert alert-card alert-info text-center" role="alert">
                    این سفارش خرید محصول میباشد که اگر انجام شده است وضعیت را به انجام شده تغییر دهید.
                    <button onclick="done('انجام شده')" class="btn btn btn-success ml-1">انجام شده</button>
                </div>
            </div>
        <?php endif; ?>

        <?php if(($result->order->type == 'buy' || $result->order->type == 'buy-product') && $result->order->status == 'در حال انتقال ارز'): ?>
            <div class="col-md-12 p-0">
                <div class="alert alert-card alert-info text-center" role="alert">
                    این سفارش پرداخت شده است و خرید ارزی است که اتوماتیک منتقل نشده و بعد از انتقال دکمه منتقل شد را بزنید.
                    <button onclick="done('منتقل شده')" class="btn btn btn-success ml-1">منتقل شده</button>
                </div>
            </div>
        <?php endif; ?>

        <?php if(isset($result->order->payment) && $result->order->status == 'در حال بررسی پرداخت'): ?>
            <div class="alert alert-card alert-warning text-center" role="alert">
                سفارش از طریق ثبت فیش یا کارت به کارت پرداختش شده است و بعد از بررسی پرداخت در صورت صحت پرداخت را تایید و در غیر اینصورت رد کردن سفارش را بزنید.
                <button onclick="" data-toggle="modal" data-target="#transfer_dollar" class="btn btn btn-success ml-1 mt-1">تایید پرداخت</button>
                <button onclick="reject()" class="btn btn btn-danger ml-1 mt-1">رد کردن پرداخت</button>
            </div>
        <?php endif; ?>
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">جزییات سفارش <?php echo e($result->order->detail->type .' '. $result->order->detail->title); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(asset('')); ?>orders">سفارشات</a></li>
                        <li class="breadcrumb-item active">فاکتور</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card border ">
                <div class="card-body">
                    <div class="invoice-title">
                        <h4 class="float-end font-size-16">شماره سفارش # <?php echo e($result->order->id); ?></h4>
                        <div class="mb-4">
                            <img src="<?php echo e(asset('images/logo/logo-dark.svg')); ?>" alt="logo" height="20"/>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <p class="text-center">اطلاعاتی که در این صفحه میبینید متعلق به این سفارش می باشد</p>
                        <div class="col-sm-12">
                            <div class="my-2">
                                <strong>تاریخ ثبت:</strong>
                                <?php echo e($result->order->date); ?>

                            </div>
                            <div class="my-2">
                                <strong>مبلغ سفارش:</strong>
                                <?php echo e(number_format($result->order->amount)); ?> تومان
                            </div>
                            <div class="my-2">
                                <strong>وضعیت:</strong>
                                <?php if($result->order->status == 'پرداخت شده' || $result->order->status == 'انجام شده'|| $result->order->status == 'منتقل شده'): ?>
                                    <span class="badge bg-success font-weight-light"><?php echo e($result->order->status); ?></span>
                                <?php elseif($result->order->status == 'رد شده'): ?>
                                    <span class="badge bg-danger font-weight-light"><?php echo e($result->order->status); ?></span>
                                <?php elseif($result->order->status == 'در دست اقدام'): ?>
                                    <span class="badge bg-success font-weight-light">پرداخت شده</span>
                                    <span class="badge bg-info font-weight-light"><?php echo e($result->order->status); ?></span>
                                <?php elseif($result->order->status == 'در حال انتقال ارز'): ?>
                                    <span class="badge bg-success font-weight-light">پرداخت شده</span>
                                    <span class="badge bg-warning font-weight-light"><?php echo e($result->order->status); ?></span>
                                <?php elseif($result->order->status == 'معلق'): ?>
                                    <span class="badge bg-pill badge-dark font-weight-light">معلق</span>
                                <?php else: ?>
                                    <span class="badge bg-warning font-weight-light"><?php echo e($result->order->status); ?></span>
                                <?php endif; ?>
                            </div>
                            <?php if($result->order->type == 'sell'): ?>
                                <div class="my-2">
                                    <strong>پرداخت از طریق:</strong>
                                    <?php if(isset($result->order->id_cardbank)): ?>
                                        شماره کارت  <span dir="ltr"><?php echo e(substr_replace($result->order->cardbank->card_number, str_repeat("*", 6), 6, 6)); ?></span>
                                    <?php else: ?>
                                        کیف پول شما در <?php echo e(getSetting('app_name_farsi')); ?>

                                    <?php endif; ?>
                                </div>
                            <?php else: ?>
                                <div class="my-2">
                                    <strong>پرداخت از طریق:</strong>
                                    <?php echo e($result->order->payment_gateway); ?>

                                </div>
                            <?php endif; ?>
                            <?php if(isset($result->order->description)): ?>
                                <div class="my-2">
                                    <strong>توضیحات سفارش:</strong>
                                    <?php echo e($result->order->description); ?>

                                </div>
                            <?php endif; ?>
                            <div class="my-2">
                                <strong>سفارش از طریق:</strong>
                                <?php echo e($result->order->via); ?>

                            </div>
                            <div class="my-2">
                                <strong>سفارش از آی پی:</strong>
                                <?php echo e($result->order->ip ?? '----'); ?>

                            </div>
                            <?php if(isset($result->ticket)): ?>
                                <?php if($result->ticket->seen_admin == 1): ?>
                                    <div class="alert alert-secondary alert-dismissible fade show" role="alert">
                                        <i class="mdi mdi-chat me-2"></i>
                                        <strong class="text-capitalize">نکته!</strong> تیکتی در مورد این سفارش ایجاد شده است و جهت پیگیری سفارش و مشاهده تیکت به بخش تیکت ها مراجعه نمایید. <a href="<?php echo e(asset('')); ?>ticket/<?php echo e($result->ticket->id); ?>" class="amber"><i class="ft-link"></i> لینک تیکت </a>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                        <i class="mdi mdi-chat me-2"></i>
                                        <strong class="text-capitalize">نکته!</strong> تیکتی در مورد این سفارش ایجاد شده است که هنوز ندیده اید و لطفا جهت پیگیری سفارش و مشاهده تیکت به بخش تیکت ها مراجعه نمایید. <a href="<?php echo e(asset('')); ?>ticket/<?php echo e($result->ticket->id); ?>" class="typo_link text-primary"><i class="ft-link"></i> لینک تیکت </a>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                            <div class="my-4">
                                <span class="mb-3">مشخصات خریدار:</span>
                                <div class="table-responsive">
                                    <table class="table align-middle table-nowrap table-hover">
                                        <thead class="table-light">
                                        <tr>
                                            <th scope="col" style="width: 70px;">#</th>
                                            <th scope="col">نام و نام خانوادگی</th>
                                            <th scope="col">شماره تماس</th>
                                            <th scope="col">ایمیل</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <tr>
                                            <td>
                                                <div class="avatar-xs">
                                                    <img src="<?php echo e(asset('images/users/user.png')); ?>" width="30px">
                                                </div>
                                            </td>
                                            <td>
                                                <h5 class="font-size-14 mb-1"><?php echo e($result->user->name .' '.$result->user->family); ?></h5>
                                            </td>
                                            <td><?php echo e($result->user->mobile); ?></td>
                                            <td><?php echo e($result->user->email??'ثبت نشده است'); ?></td>
                                        </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php echo $__env->yieldContent('orders_model'); ?>
                    <div class="d-print-none d-block d-md-flex justify-content-between">
                        <div class="mb-3 text-center">
                            <button type="button" href="" class="btn btn-info" data-bs-toggle="modal" data-bs-target=".bs-example-modal-lg"><i class="ft-message-square"></i> ایجاد تیکت برای این سفارش </button>
                        </div>
                        <div class="text-center">
                            <a href="javascript:window.print()" class="btn btn-success waves-effect waves-light me-1"><i class="fa fa-print"></i></a>
                            <a href="<?php echo e(asset('')); ?>orders" class="btn btn-light w-md waves-effect waves-light">بازگشت به سفارشات</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myLargeModalLabel">ثبت درخواست جدید</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form autocomplete="off" method="post" class="needs-validation" novalidate action="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->order->id); ?>/ticket" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row col-md-12 col-12 m-md-auto m-0 p-0">
                            <div class="col-md-6 p-0 pe-md-1 form-group">
                                <label for="firstName1">موضوع</label>
                                <input type="text" class="form-control" name="subject" id="subject" placeholder="موضوع خود را درج کنید" required>
                                <div class="invalid-feedback">موضوع خود را انتخاب کنید</div>
                            </div>
                            <div class="col-md-6 p-0 ps-md-1 form-group">
                                <label for="picker1">واحد</label>
                                <select class="form-control" name="unit" id="unit" required>
                                    <option value='' disabled selected>واحد را انتخاب کنید</option>
                                    <option value="پیگیری سفارش">پیگیری سفارش</option>
                                    <option value="احراز هویت">احراز هویت</option>
                                    <option value="مالی">مالی</option>
                                    <option value="سایر">سایر</option>
                                </select>
                                <div class="invalid-feedback">واحد را انتخاب کنید</div>
                            </div>

                            <div class="col-md-12 p-0 form-group mb-1 text-left">
                                <label>توضیحات</label>
                                <textarea rows="5"  name="message" maxlength="350" id="message" required class="form-control" placeholder="پیغام خود را درج کنید"></textarea>
                                <div class="invalid-feedback">پیغام خود را درج کنید</div>
                            </div>

                            <div class="col-md-12 p-0 form-group mb-1 text-left">
                                <label for="credit1">فایل پیوست</label>
                                <fieldset class="form-group">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="file" type="file"
                                               accept="image/*,.doc,.docx,.pdf,application/zip,.rar">
                                        <label class="custom-file-label" for="file">انتخاب فایل</label>
                                    </div>
                                    <small>پسوندهای مجاز: jpg, jpeg, png, pdf, doc, docx, zip, rar</small>
                                    <small class="text-left mr-3">حداکثر حجم فایل 5 مگابایت</small>
                                </fieldset>
                            </div>
                            <div class="progress mb-2 w-100" style="display:none ">
                                <div class="progress-bar bg-info progress-bar-striped progress-bar-animated" role="progressbar"
                                     aria-valuemax="100" style="width:0%">
                                    0%
                                </div>
                            </div>
                            <div class="col-md-5 m-auto">
                                <button type="submit" class="btn btn-primary btn-block">ثبت درخواست</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('')); ?>app-assets/vendors/js/digitbox.min.js"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>

        function reject(){
            swal.fire({
                title: "از رد کردن اطمینان دارید؟",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#d22346",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.ajax({
                        url: "<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->order->id); ?>/status",
                        type: 'put',
                        data: {_token: "<?php echo e(csrf_token()); ?>",status:'رد شده'},
                    });
                }
            }).then((data) => {
                if(data.value.status==true){
                    swal({
                        title:'انجام شد!',
                        type: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.reload();
                    });
                }
                else{
                    swal("خطا",  data.value.messege  , "error");
                }
            });
        }


        function done(status){
            swal.fire({
                title: "از تغییر وضعیت اطمینان دارید؟",
                text:'تغییر وضعیت بعد از رد امکان پذیر نیست',
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#238c26",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.ajax({
                        url: "<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->order->id); ?>/status",
                        type: 'put',
                        data: {_token: "<?php echo e(csrf_token()); ?>",status:status},
                    });
                }
            }).then((data) => {
                if(data.value.status==true){
                    swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.reload();
                    });
                }
                else{
                    swal("خطا",  data.value.messege  , "error");
                }
            });
        }


        function confirm(){

            Swal.fire({
                title: "از تایید اطمینان دارید؟",
                icon:'question',
                html:
                    'بعد از تایید سفارش امکان رد کردن آن وجود ندارد! همچنین میتوانید مبلغ پرداختی را تغییر دهید. و اگر تیک اتوماتیک را نزده باشید میبایست ابتدا به صورت دستی مبلغ را به حساب کاربر واریز نمایید و سپس تایید کنید' +
                    '<input id="swal-input1" class="swal2-input comma text-center ltr-dir" maxlength="50" required placeholder="مبلغ پرداخت شده؟">'+
                        <?php if(isset($result->order->id_cardbank)): ?>
                            '<fieldset><div class="vs-checkbox-con vs-checkbox-primary"><input type="checkbox" value="true" id="swal-input2">'+
                    '<label class="" for="swal-input2"> <span class="mx-1">اتوماتیک از api واریز شود؟</span> </label></div></fieldset>',
                <?php else: ?>
                '',
                <?php endif; ?>

                inputAttributes: {
                    autocapitalize: 'off'
                },
                showCancelButton: true,
                confirmButtonText: 'تایید',
                showLoaderOnConfirm: true,
                onOpen: () => {
                    $('.comma').digitbox({grouping: 1, separator: ',', truevalue: 1});
                    $('#swal-input1').val($('#amount').html());
                },
                preConfirm: () => {
                    if($('#swal-input1').val() == '')
                        Swal.showValidationMessage('مبلغ پرداختی باید درج شود');

                    return $.ajax({
                        url: "<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->order->id); ?>/status",
                        type: 'put',
                        data: {_token: "<?php echo e(csrf_token()); ?>",status:'پرداخت شده',payment:$('#swal-input1').val()},
                    });
                }
            }).then((data) => {
                if(data.value.status == true){
                    Swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.message,
                    }).then(function () {
                        location.reload();
                    });
                }
                else{
                    Swal.fire("Error",  data.value.message  , "error");
                    unloading();
                }
            });
        }


        $(document).ready(function () {
            // bind 'myForm' and provide a simple callback function
            var bar = $('.progress-bar');
            var percent = $('.progress-bar');

            $('form').ajaxForm({
                beforeSend: function (xhr, opts) {
                    if($('#file').val()!=""){
                        var file = $('#file')[0].files[0];
                        if(file.size>=5300000) {
                            swal.fire({
                                icon: 'warning',
                                title: "توجه",
                                html: 'حداکثر مجاز حجم فایل 5 مگابایت است.',
                                confirmButtonText: "تایید",
                            });
                            xhr.abort();
							return false;
                        }
                    }
                    $('form button').attr('disabled','disabled');
                    $('form').addClass('disable-block');

                    if($('#file').val()!="")
                        $('.progress').fadeIn();

                    var percentVal = '0%';
                    bar.css('width',percentVal+'%');
                    percent.html(percentVal);
                },
                uploadProgress: function (event, position, total, percentComplete) {
                    var percentVal = percentComplete-3 + '%';
                    bar.width(percentVal);
                    percent.html(percentVal);
                },
                complete: function (data) {
                    bar.css('width','100%');
                    percent.html(100);

                    data = data.responseJSON;
                    $('form').removeClass('disable-block');
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                            onClose: () => {
                                location.href= "<?php echo e(asset('').env('PanelPrefix')); ?>/ticket/"+data.id;
                            }
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                        $('.progress').fadeOut();
                    }
                    $('form button').removeAttr('disabled');
                }
            });
        });

        function remove(){
            Swal.fire({
                title: "از حدف اطمینان دارید؟",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#d22346",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.ajax({
                        url: url + "/orders/<?php echo e($result->order->id); ?>/remove",
                        type: 'DELETE',
                        data: {_token: "<?php echo e(csrf_token()); ?>"},
                    });
                }
            }).then((data) => {
                if(data.value.status==true){
                    Swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.href = url+"/orders";
                    });
                }
                else{
                    Swal.fire("خطا",  data.value.messege  , "error");
                }
            });
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/admin/orders/single.blade.php ENDPATH**/ ?>