
<?php $__env->startSection('title', 'ورود'); ?>

<?php $__env->startSection('head'); ?>
    <script src='https://www.google.com/recaptcha/api.js?hl=fa'></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6 col-xl-5">
            <div class="card overflow-hidden">
                <div class="row pt-5 pb-3 text-center">
                    <h3>ورود به حساب کاربری</h3>
                </div>
                <div class="card-body pt-0">
                    <div class="text-center mb-1"><small>لطفا مطمئن شوید آدرس مرورگرتان منطبق با آدرس زیر باشد.</small></div>
                    <div class="text-center mb-4">
                        <span class="border border-1 py-1 px-4 rounded-pill">
                            <span class="text-success">https://</span><?php echo e(getSetting('app_url')); ?><i class="mdi mdi-lock font-size-16 text-success ms-1"></i>
                        </span>
                    </div>
                    <?php if(Session::has('Error')): ?>
                        <div class="alert alert-warning alert-dismissible" role="alert">
                            <i class="mdi mdi-alert-outline me-2"></i>
                            <?php echo e(Session::get('Error')); ?>

                            <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">
                            </button>
                        </div>
                    <?php endif; ?>
                    <div class="p-2">
                        <form method="POST" autocomplete="off" id="loginform" class="form-horizontal needs-validation" action="" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="username" class="form-label">شماره موبایل</label>
                                <input type="text" class="form-control"
                                       required="required"
                                       name="mobile" id="mobile"
                                       maxlength="11" minlength="11"/>
                                <div class="invalid-feedback">
                                    شماره موبایل را بدرستی وارد کنید
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">کلمه عبور</label>
                                <div class="input-group auth-pass-inputgroup">
                                    <input type="password" class="form-control"
                                           id="Password"
                                           minlength="6" name="password" required="required">
                                    <button class="btn btn-light " type="button" id="password-addon"><i class="mdi mdi-eye-outline"></i></button>
                                    <div class="invalid-feedback">
                                        رمز عبور را وارد کنید
                                    </div>
                                </div>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="remember-check" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="remember-check">
                                    مرا به خاطر بسپار
                                </label>
                            </div>
                            <div class="form-group text-center my-3">
                                <div class="g-recaptcha d-flex justify-content-center" data-sitekey="<?php echo e(env('NOCAPTCHA_SITEKEY')); ?>"></div>
                                <?php if($errors->has('g-recaptcha-response')): ?>
                                    <span class="invalid-feedback" style="display: block;">
                                        <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="mt-3 d-grid">
                                <button type="submit" class="btn btn-primary waves-effect waves-light" onclick="onSubmitloginform($(this))" id="BtnRegister">ورود</button>
                            </div>
                            <div class="mt-4 text-center">
                                <a href="<?php echo e(route("ForgetPassword")); ?>" class="text-muted"><i class="mdi mdi-lock me-1"></i>کلمه عبور خود را فراموش کرده‌اید؟</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="mt-5 text-center">
                <div>
                    <p>حساب ندارید؟ <a href="<?php echo e(route("Register")); ?>" class="fw-medium text-primary"> همین حالا ثبت نام کن </a> </p>
                    <p>© <script>document.write(new Date().getFullYear())</script> ساخته شده با <i class="mdi mdi-heart text-danger"></i> توسط تیم <?php echo e(getSetting('app_name_farsi')); ?></p>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.login.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/webcore-heydari/Downloads/platform/resources/views/user/auth/login.blade.php ENDPATH**/ ?>