<?php $__env->startSection('title', 'گزارش کاربران'); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('')); ?>app-assets/vendors/css/tables/datatable/datatables.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('')); ?>app-assets/css/plugins/persian-datepicker.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="card mb-4 w-100">
            <div class="card-body">
                <div class="card-title mb-0">کاربران</div>
                <p class="text-small text-muted">لیست کاربران کل سیستم را مشاهده میکنید.</p>


                <div class="col-12">
                    <div class="row">
                        <div class="col-md-2 form-group ms-auto">
                            <label>نوع ارز</label>
                            <select class="form-control" id="currency">
                                <option value="" selected>همه ارزها</option>
                                <option value="PSVouchers">ووچرز</option>
                                <option value="perfectmoney">پرفکت مانی</option>
                                <option value="PMvoucher">ووچر پرفکت مانی</option>
                                <option value="bitcoin">بیت کوین</option>
                                <option value="ethereum">اتریوم</option>
                                <option value="ripple">ریپل</option>
                                <option value="tether">تتر</option>
                                <option value="paypal">پی پل</option>
                                <option value="skrill">اسکریل</option>
                                <option value="webmoney">وب مانی</option>
                            </select>
                        </div>
                        <div class="col-md-2 form-group me-auto">
                            <label>مرتب سازی بر اساس</label>
                            <select class="form-control" id="sort">
                                <option value="" selected>بیشترین خرید و فروش</option>
                                <option value="Buy">بیشترین خرید</option>
                                <option value="Sell">بیشترین فروش</option>
                                <option value="AmountBuySell">بیشترین مبلغ خرید و فروش</option>
                                <option value="AmountBuy">بیشترین مبلغ خرید</option>
                                <option value="AmountSell">بیشترین مبلغ فروش</option>
                                <option value="CommissionCount">بیشترین پورسانت</option>
                                <option value="CommissionAmount">بیشترین مبلغ پورسانت</option>
                                <option value="Invitation">بیشترین معرفی کننده</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3 mx-auto mt-3">
                        <button class="btn btn-primary" onclick="search()">فیلتر</button>
                    </div>
                </div>

                <table class="table table-striped table-bordered alt-pagination selection-deletion-row dataex-fixh-basic w-100">
                    <thead>
                    <tr>
                        <th class="text-center w-1">#</th>
                        <th class="text-center">نام و فامیل</th>
                        <th class="text-center">کد ملی</th>
                        <th class="text-center">موبایل</th>
                        <th class="text-center">عضویت</th>
                        <th class="text-center">مقدار</th>
                        <th class="text-center">وضعیت</th>
                        <th class="text-center">جزئیات</th>
                    </tr>
                    </thead>
                    <tbody  class="text-center">

                    </tbody>

                </table>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('')); ?>js/tables/datatable/datatables.min.js" type="text/javascript"></script>
    <script src="<?php echo e(asset('')); ?>app-assets/vendors/js/persian-date.min.js" type="text/javascript"></script>
    <script src="<?php echo e(asset('')); ?>app-assets/vendors/js/persian-datepicker.min.js" type="text/javascript"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>

        $('#date1').persianDatepicker({
            altField: '#date_start',
            altFormat: 'YYYY/MM/DD HH:mm',
            initialValue: false,
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            timePicker: {
                enabled: true,
                second:{
                    enabled: false,
                }
            }
        });

        $('#date2').persianDatepicker({
            altField: '#date_stop',
            altFormat: 'YYYY/MM/DD HH:mm',
            initialValue: false,
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            timePicker: {
                enabled: true,
                second:{
                    enabled: false,
                }
            }
        })

        $('.alt-pagination').DataTable({
            "pagingType": "full_numbers",
            "scrollX": true,
            "language": {
                "url": "<?php echo e(asset('')); ?>app-assets/vendors/js/datatable-Persian.json",
            },
            "ajax": '<?php echo e(asset('').env('PanelPrefix')); ?>/reports/users/list',
            "processing": true,
            "columns": [
                { "data": "0"},
                { "data": '1'},
                { "data": "2"},
                { "data": "3" },
                { "data": "4"},
                { "data": "5" },
                { "data": "6" },
                { "data": "7", "orderable":false },
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "searchable": false,
                    "orderable": true,
                    "data": null,
                    "render": function (data, type, full, meta) {
                        return meta.settings._iDisplayStart + meta.row + 1;
                    }
                }
            ],
            "displayLength": 25,
            dom: "<'top'><'row'<'col-md-5 col-12 mt-1'B><'col-md-7 col-12 d-flex ltr-dir'<'mx-1 mt-1'l><'rtl-dir'f>>><'bottom'>rt<'row'<'col-md-5 col-12'i><'col-md-7 col-12'p>><'clear'>",
            buttons: [
                {
                    extend: 'print',
                    text: '<i class="ft-printer"></i> Print',
                    className: 'btn btn-outline-secondary',
                    title: '',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                },
                {
                    extend: 'excel',
                    text: '<i class="ft-save"></i> Exel',
                    className: 'btn btn-outline-secondary',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                }
            ],
            "initComplete":function(){
                page = $('.alt-pagination').DataTable().page.info()['page'];
                if (page ==0 && $('.alt-pagination tr').length < 25) {
                    $('.dataTables_paginate,.dataTables_info').hide();
                }else
                    $('.dataTables_paginate,.dataTables_info').show();

            }
        });

        var tableselectionDelete = $('.alt-pagination').DataTable();
        $('.selection-deletion-row tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                tableselectionDelete.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }
        });


        function search(){
            var tbl = $('.alt-pagination').DataTable();
            tbl.ajax.url("<?php echo e(asset('').env('PanelPrefix')); ?>/reports/users/list?sort="+ $("#sort").val() + "&currency=" + $("#currency").val() + "&date_start="+ $("#date_start").val() + "&date_stop="+ $("#date_stop").val() ).load();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\arzlan\platform\resources\views/admin/reports/users.blade.php ENDPATH**/ ?>