<?php $__env->startSection('title', 'معرفی و درآمد از '.getSetting('app_name_farsi')); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('')); ?>app-assets/vendors/css/tables/datatable/datatables.min.css">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">زیرمجموعه گیری</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(asset('')); ?>">داشبورد</a></li>
                        <li class="breadcrumb-item active">زیرمجموعه-گیری</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-xl-4">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">کسب درآمد</h4>
                    <div class="row">
                        <div class="col-sm-6">
                            <p class="text-muted">مبلغ کل پورسانت</p>
                            <h3><?php echo e(number_format($result->amount)); ?> <small class="text-muted">تومان</small></h3>
                            <p class="text-muted"><span class="text-success me-2"> <i class="mdi mdi-arrow-up"></i></span></p>

                            <div class="mt-4">
                                <a href="javascript: void(0);" class="btn btn-primary waves-effect waves-light btn-sm">اطلاعات بیشتر <i class="mdi mdi-arrow-left ms-1"></i></a>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="mt-4 mt-sm-0">
                                <div id="radialBar-chart" class="apex-charts"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body p-4">
                    <div class="text-center">
                        <div class="avatar-md mx-auto mb-4">
                            <div class="avatar-title bg-light rounded-circle text-primary h1">
                                <i class="bx bx-smile"></i>
                            </div>
                        </div>

                        <div class="row justify-content-center">
                            <div class="col-xl-10">
                                <h4 class="text-primary">معرفی و درآمد از <?php echo e(getSetting('app_name_farsi')); ?></h4>
                                <p class="text-muted font-size-14 mb-4">با معرفی <?php echo e(getSetting('app_name_farsi')); ?> به دوستان خود از هر بار خرید دوستانتان پورسانت دریافت کنید.</p>

                                <div class="input-group bg-light rounded">
                                    <div class="form-control bg-transparent border border-warning text-center mouse-pointer" data-toggle="tooltip"
                                         data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                        <span><?php echo e(asset('')); ?>ref/<?php echo e(Auth::user()->id + 15000); ?></span></div>
                                    <button class="btn btn-warning" type="button" value="<?php echo e(asset('')); ?>ref/<?php echo e(Auth::user()->id + 15000); ?>" id="button-addon2" onclick="copyToClipboard(this)">
                                        <i class="bx bxs-copy"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card card-body border border-primary">
                <p class="text-center"></i>تا این لحظه <span class="purple font-weight-bold font-medium-2"> <?php echo e(count($result->invitationUser)); ?> </span> نفر معرفی کرده اید.</p>
                <button type="button" data-toggle="modal" data-bs-toggle="modal" data-bs-target="#staticBackdrop" class="btn btn-primary waves-effect waves-light">لیست دوستان معرفی شده</button>
            </div>
        </div>
        <div class="col-xl-8">
            <div class="row">
                <div class="col-md-4">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="flex-grow-1">
                                    <p class="text-muted fw-medium"> تعداد کاربر معرفی شده </p>
                                    <h4 class="mb-0"><?php echo e(count($result->invitationUser)); ?></h4>
                                </div>

                                <div class="flex-shrink-0 align-self-center">
                                    <div class="mini-stat-icon avatar-sm rounded-circle bg-primary">
                                        <span class="avatar-title">
                                            <i class="bx bx-group font-size-24"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="flex-grow-1">
                                    <p class="text-muted fw-medium"> تعداد کل سفارشات</p>
                                    <h4 class="mb-0"><?php echo e($result->orders); ?></h4>
                                </div>
                                <div class="flex-shrink-0 align-self-center">
                                    <div class="avatar-sm rounded-circle bg-primary mini-stat-icon">
                                        <span class="avatar-title rounded-circle bg-primary">
                                            <i class="bx bx-archive-in font-size-24"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card mini-stats-wid">
                        <div class="card-body">
                            <div class="d-flex">
                                <div class="flex-grow-1">
                                    <p class="text-muted fw-medium"> میانگین پورسانت هر سفارش </p>
                                    <h4 class="mb-0"><?php echo e($result->amount ? number_format($result->amount / $result->orders) : 0); ?> <small class="text-muted">تومان</small></h4>
                                </div>

                                <div class="flex-shrink-0 align-self-center">
                                    <div class="avatar-sm rounded-circle bg-primary mini-stat-icon">
                                        <span class="avatar-title rounded-circle bg-primary">
                                            <i class="bx bx-purchase-tag-alt font-size-24"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <div class="d-sm-flex flex-wrap">
                        <h5 class="mt-4 mb-3">جدول خرید های دوستان معرفی شده توسط شما</h5>
                        <table class="table table-striped table-bordered alt-pagination selection-deletion-row dataex-fixh-basic w-100"
                               id="table_category">
                            <thead class='iransensbold'>
                            <tr>
                                <th class="text-center">#</th>
                                <th class="text-center ">نام و فامیل</th>
                                <th class="text-center">پورسانت شما</th>
                                <th class="text-center">تاریخ و ساعت ثبت</th>
                            </tr>
                            </thead>
                            <tbody class="text-center">

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>


    
    <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" role="dialog" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">لیست دوستان معرفی شده</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="thead-default">

                            <tr>
                                <th class="text-center">#</th>
                                <th class="text-center">نام و فامیل</th>
                                <th class="text-center">عضویت</th>
                                <th class="text-center">تعداد خرید</th>
                            </tr>
                            </thead>
                            <tbody class="text-center">
                            <?php $i=1; ?>
                            <?php $__currentLoopData = $result->invitationUser; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td scope="row" class="sans-serif"><?php echo e($i); ?></td>
                                    <td><?php echo e($user->name); ?> <?php echo e($user->family); ?></td>
                                    <td><?php echo e($user->date); ?></td>
                                    <td><?php echo e($user->order); ?></td>
                                </tr>
                                <?php $i++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">بستن</button>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="exampleModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">لیست دوستان معرفی شده</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="بستن">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">بستن</button>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('')); ?>js/tables/datatable/datatables.min.js" type="text/javascript"></script>
    <script src="<?php echo e(asset('libs/apexcharts/apexcharts.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('libs/apexcharts/dashboard.init.js')); ?>" type="text/javascript"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>

        function copyToClipboard(element)
        {
            var $temp = $('<input>');
            $('body').append($temp);
            if($(element).val()!="")
                $temp.val($(element).val()).select();
            else
                $temp.val($(element).find('span').html()).select();
            document.execCommand('copy');
            $temp.remove();
            $(element).attr('data-original-title','کپی شد!');
            $('.tooltip-inner').html('کپی شد!');
        }


        $('.alt-pagination').DataTable({
            "pagingType": "full_numbers",
            "scrollX": true,
            "language": {
                "url": "<?php echo e(asset('')); ?>js/tables/datatable/datatable-Persian.json"
            },
            "ajax": '<?php echo e(asset('')); ?>invitation/list',
            "columns": [
                { "data": "1" },
                { "data": "2" },
                { "data": "3" },
                { "data": "4" },
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "searchable": false,
                    "orderable": true,
                    "data": null,
                    "render": function (data, type, full, meta) {
                        return meta.settings._iDisplayStart + meta.row + 1;
                    }
                }
            ],
            "displayLength": 25,
            dom: "<'top'><'row'<'col-md-5 col-12 mt-1'B><'col-md-7 col-12'f>><'bottom'>rt<'row'<'col-md-5 col-12'i><'col-md-7 col-12'p>><'clear'>",
            buttons: [
                {
                    extend: 'print',
                    text: '<i class="ft-printer"></i> Print',
                    className: 'btn round btn-outline-secondary',
                    title: '',
                    exportOptions: {
                        columns: [0,1,2,3,4,5, {'data': 'batch_notes', "render": function ( data, type, row, meta ) { return data },}]
                    }
                },
                {
                    extend: 'excel',
                    text: '<i class="ft-save"></i> Exel',
                    className: 'btn round btn-outline-secondary',
                    exportOptions: {
                        columns: [1,2,3,4,5, {'data': 'batch_notes', "render": function ( data, type, row, meta ) { return data },}]
                    }
                }
            ],
            "initComplete":function(){
                page = $('.alt-pagination').DataTable().page.info()['page'];
                if (page ==0 && $('.alt-pagination tr').length < 25) {
                    $('.dataTables_paginate,.dataTables_info').hide();
                }else
                    $('.dataTables_paginate,.dataTables_info').show();

            }
        });

        var tableselectionDelete = $('.alt-pagination').DataTable();
        $('.selection-deletion-row tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                tableselectionDelete.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }
        });

        $(document).ready(function () {
            $(function () {
                $('[data-toggle="tooltip"]').tooltip()
            })
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/user/invitation.blade.php ENDPATH**/ ?>