<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="rtl">
<!-- BEGIN: Head-->
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="description" content="">
    <meta name="_token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title'); ?></title>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('images/logo/SVGFLAT.svg')); ?>">
    <link href="https://fonts.googleapis.com/css?family=Muli:300,300i,400,400i,600,600i,700,700i%7CComfortaa:300,400,700" rel="stylesheet">

    <!-- Bootstrap Css -->
    <link href="<?php echo e(asset('css/bootstrap-rtl.min.css')); ?>" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('/assets/libs/sweetalert2/sweetalert2.min.css')); ?>" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <link href="<?php echo e(asset('libs/toastr.min.css')); ?>" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="<?php echo e(asset('css/icons.min.css')); ?>" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="<?php echo e(asset('css/app-rtl.min.css')); ?>" id="app-style" rel="stylesheet" type="text/css" />
    <!-- Fonts Css-->
    <link href="<?php echo e(asset('css/font_iransans.css')); ?>" id="app-style" rel="stylesheet" type="text/css" />
    <?php echo $__env->yieldContent('head'); ?>
</head>

<body style="font-family: IRANSans !important;">
    <header>
        <div class="bg-white">
            <div class="container py-3 d-flex justify-content-between">
                <div class="my-auto">
                    <img src="<?php echo e(asset('images/logo/logo-dark.svg')); ?>" width="100rem" alt="">
                </div>
                <div class="my-auto">
                    <a href="" class="btn btn-light text-dark">ورود به پرتال اصلی</a>
                </div>
            </div>
        </div>
    </header>
    <div class="account-pages my-5 pt-sm-5">
        <div class="container">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </div>

    <!-- JAVASCRIPT -->
    <script src="<?php echo e(asset('js/jquery.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('js/bootstrap.bundle.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('js/metisMenu.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('js/simplebar.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('js/waves.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('js/sweetalert2.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('js/jquery.form.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('libs/jquery.blockUI.js')); ?>"></script>
    <script src="<?php echo e(asset('libs/toastr.min.js')); ?>"></script>

    <!-- App js -->
    <script src="<?php echo e(asset('js/app.js')); ?>"></script>
    <script src="<?php echo e(asset('js/arzland.js')); ?>"></script>

    <?php echo $__env->yieldContent('js'); ?>
    <?php echo $__env->yieldContent('script'); ?>
    <?php echo NoCaptcha::renderJs(); ?>


    <?php if(Session::has('Success')): ?>
        <script>
            if(!$(".alert-card").length)
                toastr.success("<?php echo e(Session::get('Success')); ?>", "انجام شد!", {
                    positionClass: "toast-top-center",
                    progressBar: !0,
                    timeOut:6000,closeButton:!0
                })
        </script>
    <?php endif; ?>
    <?php if(Session::has('Error')): ?>
        <script>
            if(!$(".alert-card").length)
                toastr.error("<?php echo e(Session::get('Error')); ?>", "خطا!", {
                    positionClass: "toast-top-center",
                    progressBar: !0,
                    timeOut:10000,closeButton:!0
                })
        </script>
    <?php endif; ?>
    <?php if(Session::has('Info')): ?>
        <script>
            if(!$(".alert-card").length)
                toastr.info("<?php echo e(Session::get('Info')); ?>", "در دست بررسی!", {
                    positionClass: "toast-top-center",
                    opacity:1,
                    progressBar: !0,
                    timeOut:6000,closeButton:!0
                })
        </script>
    <?php endif; ?>

</body>
</html>
<?php /**PATH E:\arzlan\platform\resources\views/user/login/master.blade.php ENDPATH**/ ?>