<?php
    error_reporting(0);
?>

<?php $__env->startSection('title', 'تنظیمات ارزهای دیجیتال'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <form id="setting_coin" autocomplete="off" method="post" class="needs-validation" novalidate action="">
            <?php echo csrf_field(); ?>
            <div class="tab-content p-3 text-muted">
                <div class="tab-pane active" id="cryptocurrency" role="tabpanel">
                    <div class="card">
                        <div class="card-body">
                            <h5>تنظیمات کلی خرید / فروش ارزدیجیتال</h5>
                            <div class="row col-md-9 col-lg-7 mx-auto p-0">
                                <div class="my-3">
                                    <labe>نوع سیستم خرید / فروش</labe>
                                    <select name="default_exchanger" class="form-select">
                                        <option value="binance" <?php echo e(@$result->default_exchanger == 'binance' ? 'selected' : ''); ?>>بایننس</option>
                                        <option value="coinex" <?php echo e(@$result->default_exchanger == 'coinex' ? 'selected' : ''); ?>>کوینکس</option>
                                        <option value="kucoin" <?php echo e(@$result->default_exchanger == 'kucoin' ? 'selected' : ''); ?>>کوکوین</option>
                                        <option value="manual_binance" <?php echo e(@$result->default_exchanger == 'manual_binance' ? 'selected' : ''); ?>>حالت دستی بایننس</option>
                                        <option value="manual_coinex" <?php echo e(@$result->default_exchanger == 'manual_coinex' ? 'selected' : ''); ?>>حالت دستی کوینکس</option>
                                        <option value="manual_kucoin" <?php echo e(@$result->default_exchanger == 'manual_kucoin' ? 'selected' : ''); ?>>حالت دستی کوکوین</option>
                                    </select>
                                </div>
                                <div class="col-md-6 form-group mt-2">
                                    <label>قیمت خرید تتر </label>
                                    <input type="text" name="USDT_price_buy" id="USDT_price_buy"
                                           class="form-control  text-center ltr-dir comma"
                                           placeholder="قیمت تتر" required value="<?php echo e($result->USDT_price_buy); ?>"/>
                                    <div class="invalid-feedback">قیمت خرید تتر را درج کنید</div>
                                </div>
                                <div class="col-md-6 form-group mt-2">
                                    <label>قیمت فروش تتر </label>
                                    <input type="text" name="USDT_price_sell" id="USDT_price_sell"
                                           class="form-control  text-center ltr-dir comma"
                                           placeholder="قیمت تتر" required value="<?php echo e(number_format($result->USDT_price_sell)); ?>"/>
                                    <div class="invalid-feedback">قیمت فروش تتر را درج کنید</div>
                                </div>
                                <div class="col-md-6 form-group mt-4">
                                    <label>کارمزد خرید </label>
                                    <input type="text" name="buy_order_fee" id="buy_order_fee"
                                           class="form-control  text-center ltr-dir comma"
                                           placeholder="درصد کارمزد" required value="<?php echo e($result->buy_order_fee); ?>"/>
                                    <div class="invalid-feedback">کارمزد خرید را درج کنید</div>
                                </div>
                                <div class="col-md-6 form-group mt-4">
                                    <label>کارمزد فروش </label>
                                    <input type="text" name="sell_order_fee" id="sell_order_fee"
                                           class="form-control  text-center ltr-dir comma"
                                           placeholder="درصد کارمزد" required value="<?php echo e($result->sell_order_fee); ?>"/>
                                    <div class="invalid-feedback">کارمزد فروش را درج کنید</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card border border-warning">
                                <div class="card-body">
                                    <div class="card-title"><img class="me-2" src="<?php echo e(asset('images/brands/binance.svg')); ?>" width="25px">تنظیمات api بایننس</div>
                                    <div class="col-md-12 form-group mt-3">
                                        <label>apikey بایننس</label>
                                        <input type="text" name="binance_apikey" id="binance_apikey"
                                               class="form-control  text-center ltr-dir"
                                               placeholder="apikey" value="<?php echo e($result->binance_apikey); ?>"/>
                                        <div class="invalid-feedback">apikey را درج کنید</div>
                                    </div>
                                    <div class="col-md-12 form-group mt-2">
                                        <label>seckey بایننس</label>
                                        <input type="text" name="binance_seckey" id="binance_seckey"
                                               class="form-control  text-center ltr-dir"
                                               placeholder="seckey" value="<?php echo e($result->binance_seckey); ?>"/>
                                        <div class="invalid-feedback">seckey را درج کنید</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card border border-info">
                                <div class="card-body">
                                    <div class="card-title"><img class="me-2" src="<?php echo e(asset('images/brands/coinex.svg')); ?>" width="25px">تنظیمات api کوینکس</div>
                                    <div class="col-md-12 form-group mt-3">
                                        <label>apikey کوینکس</label>
                                        <input type="text" class="form-control text-center ltr-dir"
                                               placeholder="apikey" name="coinex_apikey" id="coinex_apikey"
                                               value="<?php echo e($result->coinex_apikey); ?>"/>
                                        <div class="invalid-feedback">apikey را درج کنید</div>
                                    </div>
                                    <div class="col-md-12 form-group mt-2">
                                        <label>seckey کوینکس</label>
                                        <input type="text" class="form-control text-center ltr-dir"
                                               placeholder="seckey" name="coinex_seckey" id="coinex_seckey"
                                               value="<?php echo e($result->coinex_seckey); ?>"/>
                                        <div class="invalid-feedback">seckey را درج کنید</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card border border-info">
                                <div class="card-body">
                                    <div class="card-title"><img class="me-2" src="<?php echo e(asset('images/brands/kucoin.svg')); ?>" width="25px">تنظیمات api کوکوین</div>
                                    <div class="col-md-12 form-group mt-3">
                                        <label>apikey کوکوین</label>
                                        <input type="text" class="form-control text-center ltr-dir"
                                               placeholder="apikey" name="kucoin_apikey" id="kucoin_apikey"
                                               value="<?php echo e($result->kucoin_apikey); ?>"/>
                                        <div class="invalid-feedback">apikey را درج کنید</div>
                                    </div>
                                    <div class="col-md-12 form-group mt-2">
                                        <label>apisec کوکوین</label>
                                        <input type="text" class="form-control text-center ltr-dir"
                                               placeholder="seckey" name="kucoin_apisec" id="kucoin_apisec"
                                               value="<?php echo e($result->kucoin_apisec); ?>"/>
                                        <div class="invalid-feedback">apisec را درج کنید</div>
                                    </div>
                                    <div class="col-md-12 form-group mt-2">
                                        <label>passphare کوکوین</label>
                                        <input type="text" class="form-control text-center ltr-dir"
                                               placeholder="passphare" name="kucoin_passphare" id="kucoin_passphare"
                                               value="<?php echo e($result->kucoin_passphare); ?>"/>
                                        <div class="invalid-feedback">passphare را درج کنید</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="text-center mb-3">
                <button type="submit" class="btn btn-primary btn-block btn" id="ScrollButton">ثبت تغییرات</button>
            </div>
        </form>
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="d-flex justify-content-between mb-4">
                        <div class="card-title mb-0">ارزهای دیجیتال</div>
                        <button type="button" class="btn btn-light" data-bs-toggle="modal" data-bs-target=".bs-example-modal-lg">اضافه کردن ارز جدید</button>
                    </div>
                    <div class="table-responsive">
                        <div class="col-md-12">
                            <div class="row justify-content-between">
                                <div class="col-md-3 d-flex">
                                    <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="در بین ارزها حست و جو کنید">
                                </div>
                            </div>
                        </div>

                        <table class="table align-middle mb-0 table-nowrap" id="myTable">
                            <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>نام فارسی ارز</th>
                                <th>لوگو</th>
                                <th>نام خارجی ارز</th>
                                <th>نماد</th>
                                <th>حداقل خرید</th>
                                <td class="center">عملیات</td>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $cryptocurrencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cryptocurrency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($cryptocurrency->id); ?></td>
                                    <td><?php echo e($cryptocurrency->name_fa); ?></td>
                                    <td>
                                        <img class="me-1" src="<?php echo e(asset('')); ?>app-assets/images/currency/<?php echo e($cryptocurrency->name); ?>.svg" width="25px">
                                    </td>
                                    <td><?php echo e($cryptocurrency->name); ?></td>
                                    <td><?php echo e($cryptocurrency->symbol); ?></td>
                                    <td><?php echo e($cryptocurrency->min_buy); ?></td>
                                    <td>
                                        <button type="button" data-bs-toggle="modal" data-bs-target=".coin-<?php echo e($cryptocurrency->id); ?>-edit" class="btn btn-info">ویرایش</button>
                                        <button type="button" data-bs-toggle="modal" data-bs-target=".coin-<?php echo e($cryptocurrency->id); ?>-settings" class="btn btn-primary btn-block btn">تنظمات</button>
                                        <button type="button" onclick="remove(<?php echo e($cryptocurrency->id); ?>)" class="btn btn-danger">حذف</button>
                                    </td>
                                </tr>
                                <div class="modal fade coin-<?php echo e($cryptocurrency->id); ?>-settings" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="myLargeModalLabel"> <img class="me-2" src="<?php echo e(asset('')); ?>app-assets/images/currency/<?php echo e($cryptocurrency->name); ?>.svg" style="width: 30px"> تنظمات <?php echo e($cryptocurrency->name_fa); ?> </h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <form id="<?php echo e($cryptocurrency->id); ?>" autocomplete="off" method="post" class="needs-validation"
                                                      novalidate action="?coin_id=<?php echo e($cryptocurrency->id); ?>" >
                                                    <?php echo csrf_field(); ?>
                                                    <div class="card-body">
                                                        <h5 class="">بخش کیف پول</h5>
                                                        <div class="row mx-auto p-0">
                                                            <div class="tab-content text-muted mt-4 mt-md-0">

                                                                <div class="col-md-8 form-group">
                                                                    <label>آدرس کیف پول</label>
                                                                    <input type="text" name="address_wallet" class="form-control text-center"
                                                                           placeholder="آدرس کیف پول" value="از api دریافت میشود" disabled/>
                                                                    <div class="invalid-feedback">آدرس کیف پول را درج کنید</div>
                                                                </div>
                                                                <?php if($cryptocurrency->destination_tag == 1): ?>
                                                                    <div class="col-md-12 form-group mt-3">
                                                                        <label>تگ آدرس کیف پول</label>
                                                                        <input type="text" name="address_wallet" id="<?php echo e($cryptocurrency->name); ?>_address_id"
                                                                               class="form-control  text-center"
                                                                               placeholder="تگ آدرس کیف پول" value="از api دریافت میشود" disabled/>
                                                                        <div class="invalid-feedback">تگ آدرس کیف پول را درج کنید</div>
                                                                    </div>
                                                                <?php endif; ?>
                                                                <div class="col-md-8 form-group mb-1 mt-3">
                                                                    <label for="firstName1">وضعیت خرید کاربر از شما</label>
                                                                    <div class="mx-2 mt-1 d-xl-flex d-sm-flex d-block d-md-block">
                                                                        <label class="radio radio-outline-primary me-1">
                                                                            <input type="radio" name="buy_status" value="1" <?php if($result->{$cryptocurrency->name . '_buy_status'}=='true'): ?>checked=""<?php endif; ?>>
                                                                            <span>فعال</span>
                                                                            <span class="checkmark"></span>
                                                                        </label>
                                                                        <label class="radio radio-outline-primary ms-1">
                                                                            <input type="radio" name="buy_status" value="0" <?php if($result->{$cryptocurrency->name . '_buy_status'}=='false'): ?>checked=""<?php endif; ?>>
                                                                            <span>غیرفعال</span>
                                                                            <span class="checkmark"></span>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6 form-group mb-1 mt-3">
                                                                    <label for="firstName1">وضعیت فروش کاربر به شما</label>
                                                                    <div class="mx-2 mt-1 d-xl-flex d-sm-flex d-block d-md-block">
                                                                        <label class="radio radio-outline-primary me-1">
                                                                            <input type="radio" name="sell_status" value="1" <?php if($result->{$cryptocurrency->name . '_sell_status'}=='true'): ?>checked=""<?php endif; ?>>
                                                                            <span>فعال</span>
                                                                            <span class="checkmark"></span>
                                                                        </label>
                                                                        <label class="radio radio-outline-primary ms-1">
                                                                            <input type="radio" name="sell_status" value="0" <?php if($result->{$cryptocurrency->name . '_sell_status'}=='false'): ?>checked=""<?php endif; ?>>
                                                                            <span>غیرفعال</span>
                                                                            <span class="checkmark"></span>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="card-body">
                                                        <h5 class="">بخش موجودی</h5>
                                                        <div class="row mx-auto p-0">
                                                            <div class="row col-md-10 mx-auto p-0 p-md-2">
                                                                <div class="col-md-4 col-6 form-group">
                                                                    <label>وضعیت API برای موجودی</label>
                                                                    <br>
                                                                    <fieldset class="mt-1">
                                                                        <input type='hidden' value='off' name='stock_api'>
                                                                        <div class="custom-control custom-checkbox">
                                                                            <input type="checkbox" class="custom-control-input" onclick="disableToggle(this,'stock_<?php echo e($cryptocurrency->name); ?>')" name="stock_api" id="stock_<?php echo e($cryptocurrency->name); ?>_api" <?php if($result->{'stock_' . $cryptocurrency->name . '_api'} == 'on'): ?> checked <?php endif; ?>>
                                                                            <label class="custom-control-label" for="stock_<?php echo e($cryptocurrency->name); ?>_api">api روشن</label>
                                                                        </div>
                                                                    </fieldset>
                                                                </div>
                                                                <div class="col-md-8 col-6 form-group">
                                                                    <label>موجودی</label>
                                                                    <input type="text" name="stock" id="stock_<?php echo e($cryptocurrency->name); ?>" <?php if($result->{'stock_' . $cryptocurrency->name . '_api'} == 'on'): ?> readonly <?php endif; ?>
                                                                    class="form-control text-center ltr-dir"
                                                                           placeholder="موجودی" value="<?php echo e($result->{'stock_' . $cryptocurrency->name}); ?>"/>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="card-body">
                                                        <h5 class="">بخش پورسانت</h5>
                                                        <div class="row mx-auto p-0">
                                                            <div class="form-group mb-3 alert alert-info">
                                                                <span><strong>توجه:</strong> زیر 100 به معنی درصد و بالای صد به معنی مبلغ تومانی پورسانت است.</span>
                                                            </div>
                                                            <div class="col-md-9 mb-3">
                                                                <div class="form-group">
                                                                    <p class="w-100 font-weight-bold">پورسانت کوین</p>
                                                                </div>
                                                                <div class="form-group">
                                                                    <input type="text" name="percent_coin"  value="<?php echo e($cryptocurrency->percent_coin); ?>" class="form-control text-center ltr-dir" placeholder="پورسانت" required/>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="card-body">
                                                        <h5 class="">بخش کارمزد شبکه</h5>
                                                        <div class="row mx-auto p-0">
                                                            <div class="form-group mb-3 alert alert-info">
                                                                <span><strong>توجه:</strong> با خالی گذاشتن فیلد کارمزد شبکه برای هر ارز، کارمزد شبکه از api بصورت اتوماتیک دریافت میشود!</span>
                                                            </div>
                                                            <div class="col-md-9 mb-3">
                                                                <div class="form-group">
                                                                    <p class="w-100 font-weight-bold">درصد کوین</p>
                                                                </div>
                                                                <div class="form-group">
                                                                    <input type="text" name="transfer_fee" value="<?php echo e($cryptocurrency->transfer_fee); ?>" class="form-control text-center ltr-dir" placeholder="درصد" />
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit"  class="btn btn-primary btn-block btn" data-dismiss="modal">ثبت تغییرات</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal fade coin-<?php echo e($cryptocurrency->id); ?>-edit" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-lg">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="myLargeModalLabel"> ویرایش ارز <?php echo e($cryptocurrency->name->fa); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <form autocomplete="off" method="post" class="needs-validation"
                                                      novalidate action="?edit_coinId=<?php echo e($cryptocurrency->id); ?>" enctype="multipart/form-data">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="row col-md-6 col-12 m-md-auto m-0 p-0">
                                                        <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                                            <label for="name">نام انگلیسی ارز</label>
                                                            <input type="text" class="form-control" name="name" value="<?php echo e($cryptocurrency->name); ?>" id="name" placeholder="مثال: bitcoin" required>
                                                            <div class="invalid-feedback">نام انگلیسی ارز را وارد کنید</div>
                                                        </div>
                                                        <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                                            <label for="firstName1">نام فارسی ارز</label>
                                                            <input type="text" class="form-control" name="name_fa" value="<?php echo e($cryptocurrency->name_fa); ?>" id="name_fa" placeholder="مثال: بیت کوین" required />
                                                            <div class="invalid-feedback">نام فارسی ارز را وارد کنید</div>
                                                        </div>
                                                        <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                                            <label for="firstName1">نماد</label>
                                                            <input type="text" class="form-control" name="symbol" value="<?php echo e($cryptocurrency->symbol); ?>" id="symbol" placeholder="مثال: حروف بزرگ BTC" required />
                                                            <div class="invalid-feedback">نماد ارز را وارد کنید</div>
                                                        </div>
                                                        <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                                            <label for="firstName1">حداقل مقدار خرید</label>
                                                            <input type="text" class="form-control" name="min_buy" value="<?php echo e($cryptocurrency->min_buy); ?>" id="min_buy" placeholder="مثال: ۰.۰۰۵" required />
                                                            <div class="invalid-feedback">حداقل مقدار خرید ارز را وارد کنید</div>
                                                        </div>

                                                        <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                                            <label for="firstName1"> تگ آدرس کیف پول</label>
                                                            <select name="destination_tag" class="form-select">
                                                                <option value="0">ندارد</option>
                                                                <option value="1">دارد</option>
                                                            </select>
                                                        </div>
                                                        <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                                            <label for="firstName1">نمایش اعشار کوین</label>
                                                            <input type="text" class="form-control" value="<?php echo e($cryptocurrency->percent); ?>" name="percent" id="percent" required />
                                                            <div class="invalid-feedback">حداقل مقدار اعشار ارز را وارد کنید</div>
                                                        </div>
                                                        <div class="col-md-12 p-0 pe-md-1 form-group mb-3">
                                                            <label for="firstName1">لوگو ارز</label>
                                                            <input type="file" class="form-control" name="logo" id="logo" accept="image/svg+xml" />
                                                            <small>فرمت های مجاز: svg</small>
                                                        </div>
                                                        <input type="text" class="form-control" value="1" name="percent" id="percent" hidden required />

                                                        <div class="col-md-4 m-auto">
                                                            <button type="submit" class="btn btn-primary btn-block">ثبت درخواست
                                                            </button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myLargeModalLabel">اضافه کردن ارز جدید</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form autocomplete="off" method="post" class="needs-validation"
                          novalidate action="?_type=insert" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row col-md-6 col-12 m-md-auto m-0 p-0">
                            <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                <label for="name">نام انگلیسی ارز</label>
                                <input type="text" class="form-control" name="name" id="name" placeholder="مثال: bitcoin" required>
                                <div class="invalid-feedback">نام انگلیسی ارز را وارد کنید</div>
                            </div>
                            <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                <label for="firstName1">نام فارسی ارز</label>
                                <input type="text" class="form-control" name="name_fa" id="name_fa" placeholder="مثال: بیت کوین" required />
                                <div class="invalid-feedback">نام فارسی ارز را وارد کنید</div>
                            </div>
                            <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                <label for="firstName1">نماد</label>
                                <input type="text" class="form-control" name="symbol" id="symbol" placeholder="مثال: حروف بزرگ BTC" required />
                                <div class="invalid-feedback">نماد ارز را وارد کنید</div>
                            </div>
                            <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                <label for="firstName1">حداقل مقدار خرید</label>
                                <input type="text" class="form-control" name="min_buy" id="min_buy" placeholder="مثال: ۰.۰۰۵" required />
                                <div class="invalid-feedback">حداقل مقدار خرید ارز را وارد کنید</div>
                            </div>

                            <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                <label for="firstName1"> تگ آدرس کیف پول</label>
                                <select name="destination_tag" class="form-select">
                                    <option value="0">ندارد</option>
                                    <option value="1">دارد</option>
                                </select>
                            </div>
                            <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                <label for="firstName1">نمایش اعشار کوین</label>
                                <input type="text" class="form-control" value="1" name="percent" id="percent" required />
                                <div class="invalid-feedback">حداقل مقدار اعشار ارز را وارد کنید</div>
                            </div>
                            <div class="col-md-12 p-0 pe-md-1 form-group mb-3">
                                <label for="firstName1">لوگو ارز</label>
                                <input type="file" class="form-control" name="logo" id="logo" accept="image/svg+xml" required />
                                <small>فرمت های مجاز: svg</small>
                            </div>
                            <div class="col-md-4 m-auto">
                                <button type="submit" class="btn btn-primary btn-block">ثبت درخواست
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php
    $item_coin = null;
?>
<?php $__env->startSection('script'); ?>
    <script>

        function disableToggle(el,id) {
            if ($(el).is(':checked')) {
                $('#'+id).attr('readonly','readonly');
            }else
                $('#'+id).removeAttr('readonly');
        }


        $(document).ready(function () {
            $('form').ajaxForm({
                beforeSend: function () {
                    loading();
                },
                complete: function (data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            location.reload();
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    unloading();
                }
            });
        });

        function remove(id){
            swal.fire({
                title: "از حدف اطمینان دارید؟",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#d22346",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.ajax({
                        url: "<?php echo e(asset('').env('PanelPrefix')); ?>/crypto-settings",
                        type: 'DELETE',
                        data: {_token: "<?php echo e(csrf_token()); ?>",id:id},
                    });
                }
            }).then((data) => {
                if(data.value.status == true){
                    swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.reload()
                    });
                }
                else{
                    swal("خطا",  data.value.messege  , "error");
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/admin/settings/crypto-settings.blade.php ENDPATH**/ ?>