<?php $__env->startSection('title', 'ثبت اطلاعات'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-6 mx-auto">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">تکمیل ثبت نام</h5>
                    <p class="card-title-desc">اطلاعات زیر را با دقت پر نمایید. با تکمیل این بخش به داشبورد هدایت میشوید.</p>
                    <form method="POST" autocomplete="off" class="form-horizontal needs-validation" novalidate action="" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="name" class="form-control" required>
                                    <label for="floatingemailInput">نام</label>
                                    <div class="invalid-feedback">نام را درج کنید</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating mb-3">
                                    <input type="text" name="family" class="form-control" required>
                                    <label for="floatingemailInput">نام خانوادگی</label>
                                    <div class="invalid-feedback">نام خانوادگی را درج کنید</div>
                                </div>
                            </div>
                        </div>
                        <div class="form-floating mb-3">
                            <input type="text" class="form-control" name="email" id="email" required>
                            <label for="email">آدرس ایمیل</label>
                            <div class="invalid-feedback">ایمیل را بدرستی درج کنید</div>
                        </div>
                        <div class="form-floating mb-3">
                            <input type="password" name="password" id="password" class="form-control" minlength="6" required>
                            <label for="floatingnameInput">کلمه عبور</label>
                            <div class="invalid-feedback">کلمه عبور را بیش از 6 کاراکتر درج کنید</div>
                        </div>
                        <div class="form-floating mb-3">
                            <input type="password" name="password_confirmation" id="password_confirmation" class="form-control" minlength="6" required>
                            <label for="floatingnameInput">تکرار کلمه عبور</label>
                        </div>
                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="floatingCheck" required>
                                <label class="form-check-label" for="floatingCheck">
                                    <a href="https://towinex.com/terms-and-conditions/" target="blank">قوانین و مقررات</a> را قبول دارم
                                </label>
                            </div>
                        </div>
                        <div>
                            <button type="submit" class="btn btn-block btn-primary col-12" id="BtnRegister">تکمیل اطلاعات</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function () {
            $('form').ajaxForm({
                beforeSend: function() {
                    ElementBlock('#BtnRegister');
                },
                uploadProgress: function(event, position, total, percentComplete) {
                },
                complete: function(data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        Swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            if(data.redirect != null){
                                location.href = (data.redirect);
                                return false
                            }
                        });
                    } else {
                        Swal.fire({
                            icon: 'warning',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    ElementUnBlock('#BtnRegister');
                }
            });


        });
    </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('user.login.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/user/auth/profile.blade.php ENDPATH**/ ?>