<?php $__env->startSection('title', 'بازار ارزهای دیجیتال'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">بازار ارزهای دیجتال</h4>

                <div class="page-title-right">
                    <ul class="nav nav-pills nav-justified" role="tablist">
                        <li class="nav-item waves-effect waves-light">
                            <a class="nav-link active" data-bs-toggle="tab" href="#home-1" role="tab">
                                <span><i class="bx bx-table font-size-18"></i></span>
                            </a>
                        </li>
                        <li class="nav-item waves-effect waves-light">
                            <a class="nav-link" data-bs-toggle="tab" href="#profile-1" role="tab">
                                <span><i class="bx bx-list-ul font-size-20"></i></span>
                            </a>
                        </li>
                    </ul>
                </div>

            </div>
        </div>
    </div>
    <div class="row">
        <div class="tab-content p-3 text-muted">
            <div class="tab-pane active" id="home-1" role="tabpanel">
                <div class="row">
                    <div class="col-xl-4 col-sm-6">
                        <div class="card text-center">
                            <div class="card-body">
                                <div class="mb-4">
                                    <img class="rounded-circle avatar-sm" src="<?php echo e(asset('')); ?>app-assets/images/currency/iran.svg" alt="rial">
                                </div>
                                <h5 class="font-size-15 mb-1"><a href="javascript: void(0);" class="text-dark">واحد ریالی</a></h5>
                                <p class="text-muted">تومان</p>
                            </div>
                            <div class="card-footer bg-transparent border-top">
                                <div class="text-center">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="font-size-24 text-primary mb-1"><i class="bx bx-wallet"></i></div>
                                            <p class="text-muted mb-2">موجودی</p>
                                            <h5><?php echo e(number_format(Auth::user()->wallet)); ?> <small>تومان</small></h5>
                                        </div>
                                        <div class="col-sm-6">
                                            <div class="mt-4 mt-sm-0">
                                                <div class="mt-3">
                                                    <a href="<?php echo e(asset('')); ?>wallet" class="btn btn-primary btn-sm w-md">شارژ</a>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-sm-6">
                                            <div>
                                                <div class="mt-3">
                                                    <a href="<?php echo e(asset('')); ?>wallet/withdraw" class="btn btn-primary btn-sm w-md">برداشت</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php $__currentLoopData = $cryptocurrencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cryptocurrency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-xl-4 col-sm-6">
                            <div class="card text-center">
                                <div class="card-body">
                                    <div class="mb-4">
                                        <img class="rounded-circle avatar-sm" src="<?php echo e(asset('')); ?>app-assets/images/currency/<?php echo e($cryptocurrency->name); ?>.svg" alt="<?php echo e($cryptocurrency->name); ?>">
                                    </div>
                                    <h5 class="font-size-15 mb-1"><a href="javascript: void(0);" class="text-dark"><?php echo e($cryptocurrency->name_fa); ?></a></h5>
                                    <p class="text-muted"><?php echo e($cryptocurrency->symbol); ?></p>
                                </div>
                                <div class="card-footer bg-transparent border-top">
                                    <div class="text-center">
                                        <div class="row">
                                            <div class="col-sm-6">
                                                <div class="mt-4 mt-sm-0">
                                                    <div class="font-size-24 text-primary mb-2"><i class="bx bx-import"></i></div>
                                                    <p class="text-muted mb-2">قیمت خرید</p>
                                                    <h5><?php echo e($result['fee_buy_'.$cryptocurrency->name]); ?></h5>
                                                    <div class="mt-3">
                                                        <a href="<?php echo e(asset('')); ?><?php echo e($cryptocurrency->name); ?>" class="btn btn-primary btn-sm w-md">خرید</a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div>
                                                    <div class="font-size-24 text-primary mb-2"><i class="bx bx-send"></i></div>
                                                    <p class="text-muted mb-2">قیمت فروش</p>
                                                    <h5><?php echo e($result['fee_sell_'.$cryptocurrency->name]); ?></h5>
                                                    <div class="mt-3">
                                                        <a href="<?php echo e(asset('')); ?><?php echo e($cryptocurrency->name); ?>/sell" class="btn btn-primary btn-sm w-md">فروش</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="tab-pane" id="profile-1" role="tabpanel">
                <div class="card">
                    <div class="card-body">
                        <div class="col-md-3 d-flex">
                            <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                        </div>
                        <div class="table-responsive">
                            <div class="col-md-12">
                                <div class="row justify-content-between">

                                </div>
                            </div>

                            <table class="table align-middle mb-0 table-nowrap" id="myTable">
                                <thead class="table-light">
                                <tr>
                                    <th></th>
                                    <th>نام ارز</th>
                                    <th>نام انگلیسی ارز</th>
                                    <th>نماد</th>
                                    <th>قیمت خرید</th>
                                    <th>قیمت فروش</th>
                                    <th></th>
                                    <th></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $cryptocurrencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cryptocurrency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <img class="rounded-circle" src="<?php echo e(asset('')); ?>app-assets/images/currency/<?php echo e($cryptocurrency->name); ?>.svg" alt="<?php echo e($cryptocurrency->name); ?>" width="35px">
                                        </td>
                                        <td><?php echo e($cryptocurrency->name_fa); ?></td>
                                        <td><?php echo e($cryptocurrency->name); ?></td>
                                        <td><?php echo e($cryptocurrency->symbol); ?></td>
                                        <td><?php echo e($result['fee_buy_'.$cryptocurrency->name]); ?> <small>تومان</small></td>
                                        <td><?php echo e($result['fee_sell_'.$cryptocurrency->name]); ?> <small>تومان</small></td>
                                        <td><a href="<?php echo e(asset('')); ?><?php echo e($cryptocurrency->name); ?>" class="btn btn-success btn-sm w-md">خرید</a></td>
                                        <td><a href="<?php echo e(asset('')); ?><?php echo e($cryptocurrency->name); ?>/sell" class="btn btn-danger btn-sm w-md">فروش</a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/user/cripto/wallet.blade.php ENDPATH**/ ?>