<?php $__env->startSection('title', 'تیکت ها'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">تیکت‌ها</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-3">
            <div class="card mini-stats-wid">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3 align-self-center">
                            <i class="mdi mdi-message h2 text-success mb-0"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="text-muted mb-2">کل تیکت‌ها</p>
                            <h5 class="mb-0"><?php echo e(($result->total)); ?></h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-3">
            <div class="card mini-stats-wid">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3 align-self-center">
                            <i class="mdi mdi-message-alert h2 text-warning mb-0"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="text-muted mb-2">تیکت های باز</p>
                            <h5 class="mb-0"><?php echo e(($result->open)); ?></h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-3">
            <div class="card mini-stats-wid">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3 align-self-center">
                            <i class="mdi mdi-message-bulleted h2 text-info mb-0"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="text-muted mb-2">تیکت های در انتظار</p>
                            <h5 class="mb-0"><?php echo e(($result->pending)); ?></h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-3">
            <div class="card mini-stats-wid">
                <div class="card-body">
                    <div class="d-flex">
                        <div class="flex-shrink-0 me-3 align-self-center">
                            <i class="mdi mdi-message-cog h2 text-info mb-0"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="text-muted mb-2">تعداد کل پیام ها</p>
                            <h5 class="mb-0"><?php echo e(($result->totalMessage)); ?></h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title mb-0">تیکت‌ها کاربران</div>
                    <button type="button" class="btn btn-light" data-bs-toggle="modal" data-bs-target=".bs-example-modal-lg">ایجاد تیکت جدید برای کاربر</button>
                </div>
                <div class="col-md-12">
                    <div class="row justify-content-between">
                        <div class="col-md-3">
                            <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                        </div>
                        <div class="col-md-3 d-flex">
                            <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                            <button class="btn btn-success mb-3"><i class="dripicons-information font-size-14 d-flex"></i></button>
                        </div>
                    </div>
                </div>
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#home" role="tab">
                            <span>همه تیکت ها</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#unread" role="tab">
                            <span>خوانده نشده</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#waiting-for-answer" role="tab">
                            <span>در انتظار پاسخ</span>
                        </a>
                    </li>
                </ul>

                <!-- Tab panes -->
                <div class="tab-content p-3 text-muted">
                    <div class="tab-pane active" id="home" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0 table-nowrap" id="myTable">
                                <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>موضوع</th>
                                    <th>نام کاربر</th>
                                    <th>واحد پشتیبانی</th>
                                    <th>وضعیت</th>
                                    <th>تاریخ ایجاد</th>
                                    <th>آخرین بروزرسانی</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($ticket->id); ?></td>
                                        <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/ticket/<?php echo e($ticket->id); ?>"><?php echo e($ticket->title); ?></a></td>
                                        <td>
                                            <span><?php echo e($ticket->name.' '.$ticket->family); ?></span>
                                            <br><small class="text-muted"><?php echo e($ticket->mobile); ?></small>
                                        </td>
                                        <td><?php echo e($ticket->unit); ?></td>
                                        <td>
                                            <?php if($ticket->status == 0): ?>
                                                <span class="badge badge-soft-warning">منتظر پاسخ</span>
                                            <?php elseif($ticket->status == 1): ?>
                                                <span class="badge badge-soft-success">پاسخ داده شده</span>
                                            <?php else: ?>
                                                <span class="badge badge-soft-danger">بسته</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($ticket->created_at); ?></td>
                                        <td><?php echo e($ticket->updated_at); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table><?php echo e($tickets->links()); ?>

                        </div>
                    </div>
                    <div class="tab-pane" id="unread" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0 table-nowrap" id="myTable">
                                <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>موضوع</th>
                                    <th>نام کاربر</th>
                                    <th>واحد پشتیبانی</th>
                                    <th>وضعیت</th>
                                    <th>تاریخ ایجاد</th>
                                    <th>آخرین بروزرسانی</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($ticket->seen_admin == 0): ?>
                                        <tr>
                                            <td><?php echo e($ticket->id); ?></td>
                                            <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/ticket/<?php echo e($ticket->id); ?>"><?php echo e($ticket->title); ?></a></td>
                                            <td>
                                                <span><?php echo e($ticket->name.' '.$ticket->family); ?></span>
                                                <br><small class="text-muted"><?php echo e($ticket->mobile); ?></small>
                                            </td>
                                            <td><?php echo e($ticket->unit); ?></td>
                                            <td>
                                                <?php if($ticket->status == 0): ?>
                                                    <span class="badge badge-soft-warning">منتظر پاسخ</span>
                                                <?php elseif($ticket->status == 1): ?>
                                                    <span class="badge badge-soft-success">پاسخ داده شده</span>
                                                <?php else: ?>
                                                    <span class="badge badge-soft-danger">بسته</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($ticket->created_at); ?></td>
                                            <td><?php echo e($ticket->updated_at); ?></td>
                                        </tr>
                                    <?php else: ?>


                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table><?php echo e($tickets->links()); ?>

                        </div>
                    </div>
                    <div class="tab-pane" id="waiting-for-answer" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0 table-nowrap" id="myTable">
                                <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>موضوع</th>
                                    <th>نام کاربر</th>
                                    <th>واحد پشتیبانی</th>
                                    <th>وضعیت</th>
                                    <th>تاریخ ایجاد</th>
                                    <th>آخرین بروزرسانی</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($ticket->status == 0): ?>
                                        <tr>
                                            <td><?php echo e($ticket->id); ?></td>
                                            <td><a href="<?php echo e(asset('').env('PanelPrefix')); ?>/ticket/<?php echo e($ticket->id); ?>"><?php echo e($ticket->title); ?></a></td>
                                            <td>
                                                <span><?php echo e($ticket->name.' '.$ticket->family); ?></span>
                                                <br><small class="text-muted"><?php echo e($ticket->mobile); ?></small>
                                            </td>
                                            <td><?php echo e($ticket->unit); ?></td>
                                            <td>
                                                <?php if($ticket->status == 0): ?>
                                                    <span class="badge badge-soft-warning">منتظر پاسخ</span>
                                                <?php elseif($ticket->status == 1): ?>
                                                    <span class="badge badge-soft-success">پاسخ داده شده</span>
                                                <?php else: ?>
                                                    <span class="badge badge-soft-danger">بسته</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($ticket->created_at); ?></td>
                                            <td><?php echo e($ticket->updated_at); ?></td>
                                        </tr>
                                    <?php else: ?>

                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table><?php echo e($tickets->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myLargeModalLabel">ثبت درخواست جدید</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form autocomplete="off" method="post" class="needs-validation"
                          novalidate action="" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row col-md-6 col-12 m-md-auto m-0 p-0">
                            <div class="col-md-6 p-0 pe-md-1 form-group mb-3">
                                <label for="firstName1">موضوع</label>
                                <input type="text" class="form-control" name="subject" id="subject" required>
                                <div class="invalid-feedback">موضوع خود را انتخاب کنید</div>
                            </div>
                            <div class="col-md-6 p-0 ps-md-1 form-group mb-3">
                                <label for="picker1">واحد</label>
                                <select class="form-control" name="unit" id="unit" required>
                                    <option value='' disabled selected>واحد را انتخاب کنید</option>
                                    <option value="پیگیری سفارش">پیگیری سفارش</option>
                                    <option value="احراز هویت">احراز هویت</option>
                                    <option value="مالی">مالی</option>
                                    <option value="سایر">سایر</option>
                                </select>
                                <div class="invalid-feedback">واحد را انتخاب کنید</div>
                            </div>
                            <div class="col-md-12 p-0 form-group mb-3">
                                <label>شماره تماس کاربر</label>
                                <input type="text" class="form-control numbers text-center ltr-dir" name="mobile" id="mobile" required>
                                <div class="invalid-feedback">موبایل کاربر را درج کنید</div>
                            </div>
                            <div class="col-md-12 p-0 form-group mb-3">
                                <label for="phone">توضیحات</label>
                                <textarea rows="5" name="message" id="message" required class="form-control"></textarea>
                                <div class="invalid-feedback">پیغام خود را درج کنید</div>
                            </div>
                            <div class="col-md-12 p-0 form-group mb-3">
                                <label for="credit1">فایل پیوست(اختیاری)</label>
                                <fieldset class="form-group">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" id="file" type="file" accept="image/*,.doc,.docx,.pdf,application/zip,.rar">
                                        <label class="custom-file-label" for="file">انتخاب فایل</label>
                                    </div>
                                    <small>پسوندهای مجاز: jpg, jpeg, png, pdf, doc, docx, zip, rar</small>
                                    <small class="text-left mr-3">حداکثر حجم فایل 5 مگابایت</small>
                                </fieldset>
                            </div>
                            <div class="progress mb-2 w-100" style="display:none ">
                                <div class="progress-bar bg-info progress-bar-striped progress-bar-animated"
                                     role="progressbar"
                                     aria-valuemax="100" style="width:0%">
                                    0%
                                </div>
                            </div>
                            <div class="col-md-4 m-auto">
                                <button type="submit" class="btn btn-primary btn-block">ثبت درخواست</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>

    <script>
        $(document).ready(function () {
            // bind 'myForm' and provide a simple callback function
            var bar = $('.progress-bar');
            var percent = $('.progress-bar');

            $('form').ajaxForm({
                beforeSend: function (xhr, opts) {
                    if ($('#file').val() != "") {
                        var file = $('#file')[0].files[0];
                        if (file.size >= 5300000) {
                            swal.fire({
                                icon: 'warning',
                                title: "توجه",
                                html: 'حداکثر مجاز حجم فایل 5 مگابایت است.',
                                confirmButtonText: "تایید",
                            });
                            xhr.abort();
                            return false;
                        }
                    }
                    $('form button').attr('disabled', 'disabled');
                    $('form').addClass('disable-block');

                    if ($('#file').val() != "")
                        $('.progress').fadeIn();

                    var percentVal = '0%';
                    bar.css('width', percentVal + '%');
                    percent.html(percentVal);
                },
                uploadProgress: function (event, position, total, percentComplete) {
                    var percentVal = percentComplete - 3 + '%';
                    bar.width(percentVal);
                    percent.html(percentVal);
                },
                complete: function (data) {
                    bar.css('width', '100%');
                    percent.html(100);

                    data = data.responseJSON;
                    $('form').removeClass('disable-block');
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                            onClose: () => {
                                location.href = "<?php echo e(asset('').env('PanelPrefix')); ?>/ticket/" + data.id;
                            }
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                        $('.progress').fadeOut();
                    }
                    $('form button').removeAttr('disabled');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/admin/ticket.blade.php ENDPATH**/ ?>