        <?php $__env->startSection('orders_model'); ?>
        <p>فهرست محصولات / خدمات درخواستی</p>
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead class="">

                <tr>
                    <th class="text-center">#</th>
                    <th class="text-center w-60">شرح</th>
                    <th class="text-center">مقدار / تعداد</th>
                    <th class="text-center">قیمت واحد</th>
                    <th class="text-center">مبلغ کل</th>
                </tr>
                </thead>
                <tbody class="text-center">
                    <tr>
                        <td scope="row" class="sans-serif">1</td>
                        <td><?php echo e($result->order->detail->type .' '. $result->order->detail->title); ?></td>
                        <td><?php echo e($result->order->detail->amount_dollar); ?><?php echo e($result->order->detail->dollar); ?> </td>
                        <td><?php echo e(number_format($result->orders_model->fee)); ?></td>
                        <td><?php echo e(number_format($result->orders_model->amount_ir - $result->orders_model->transfer_fee_amount)); ?></td>
                    </tr>
                    <?php if($result->orders_model->type =='buy'): ?>
                    <tr>
                        <td scope="row" class="sans-serif">2</td>
                        <td>هزینه انتقال</td>
                        <td><?php echo e($result->orders_model->transfer_fee); ?><?php echo e($result->order->detail->dollar); ?> </td>
                        <td><?php echo e(number_format($result->orders_model->fee)); ?></td>
                        <td><?php echo e(number_format($result->orders_model->transfer_fee_amount)); ?></td>
                    </tr>
                    <tr>
                        <td colspan="4" class="sans-serif border-0"></td>
                        <td><?php echo e(number_format($result->orders_model->amount_ir)); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr class="border-0">
                        <th class="border-0"></th>
                    </tr>
                    <?php if($result->orders_model->type =='buy'): ?>
                    <tr>
                        <th class="w-60">آدرس  کیف پول گیرنده</th>
                        <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                            <i class="feather icon-copy"></i>  <span><?php echo e($result->orders_model->destination); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th class="w-60">شبکه</th>
                        <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                            <i class="feather icon-copy"></i>  <span><?php echo e($result->order->network); ?></span>
                        </td>
                    </tr>
                    <tr>
                        <th class="w-60">کارمزد سایت</th>
                        <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                            <i class="feather icon-copy"></i>  <span><?php echo e(number_format($result->order->buy_order_fee)); ?> تومان</span>
                        </td>
                    </tr>
                    <?php else: ?>
                        <tr>
                            <th class="w-60">TxID</th>
                            <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                <i class="feather icon-copy"></i>  <span><?php echo e($result->orders_model->TxID); ?></span>
                            </td>
                        </tr>
                        <tr>
                            <th class="w-60">کارمزد سایت</th>
                            <td colspan="4" class="sans-serif cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                <i class="feather icon-copy"></i>  <span><?php echo e(number_format($result->order->sell_order_fee)); ?> تومان</span>
                            </td>
                        </tr>
                    <?php endif; ?>
                    <?php if(isset($result->orders_model->destination_tag)): ?>
                        <tr>
                            <td class="border-0"></td>
                            <th scope="row">تگ</th>
                            <td colspan="4" class="sans-serif">
                                <span><?php echo e($result->orders_model->destination_tag); ?></span>
                            </td>
                        </tr>
                    <?php endif; ?>
                    <?php if(isset($result->order->payment_tracking)): ?>
                        <tr>
                            <td class="border-0"></td>
                            <th scope="row">کد پیگیری درگاه پرداخت</th>
                            <td colspan="4" class="sans-serif">
                                <span><?php echo e($result->order->payment_tracking); ?></span>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="transfer_dollar" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
             aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">تایید پرداخت و انتقال ارز به کاربر</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <p>اگر تیک انتقال اتوماتیک را بزنید از طریق api باینسس بصورت اتوماتیک منتقل میشود و در غیر این صورت میبایست دستی منتقل کنید و سپس تایید را بزنید!</p>

                        <form id="Crypto" autocomplete="off" method="post" class="needs-validation" novalidate>
                            <?php echo csrf_field(); ?>

                            <div class="row col-md-12 col-12 m-md-auto m-0 p-0">
                                <div class="col-md-6 p-0 pr-md-1 form-group">
                                    <label for="firstName1">قیمت هر ارز هنگام ثبت سفارش</label>
                                    <input type="text" class="form-control text-center ltr-dir"
                                           value="<?php echo e(number_format($result->orders_model->fee)); ?>" disabled>
                                </div>
                                <div class="col-md-6 p-0 pr-md-1 form-group">
                                    <label for="total_amount">کل مبلغ پرداختی</label>
                                    <input type="text" class="form-control text-center ltr-dir" name="total_amount" id="total_amount"
                                           placeholder="مبلغ کل پرداختی" value="<?php echo e(number_format($result->order->amount)); ?>"
                                           required>
                                    <div class="invalid-feedback">کل مبلغ پرداختی را درج کنید</div>
                                </div>
                                <div class="col-md-12 p-0 pr-md-1 form-group">
                                    <label for="amount_dollar">ارز معادل مبلغ پرداخت جهت انتقال</label>
                                    <input type="text" class="form-control text-center ltr-dir" name="amount_dollar" id="amount_dollar"
                                           placeholder="ارز معادل مبلغ پرداخت" value="<?php echo e($result->order->detail->amount_dollar); ?>" required>
                                    <div class="invalid-feedback">ارز معادل مبلغ پرداخت را درج کنید</div>
                                </div>

                                <div class="col-md-12 p-0 form-group ">
                                    <label for="firstName1">نحوه انتقال</label>
                                    <div class="mr-2 d-xl-flex d-sm-flex d-block d-md-block">

                                        <label class="radio radio-outline-primary mx-1 m-xl-0">
                                            <input type="radio" name="send_method" value="1">
                                            <span>اتوماتیک و از طریق api</span>
                                            <span class="checkmark"></span>
                                        </label>
                                        <label class="radio radio-outline-primary mx-1">
                                            <input type="radio" name="send_method" value="0" checked>
                                            <span>غیر اتوماتیک</span>
                                            <span class="checkmark"></span>
                                        </label>
                                    </div>
                                </div>

                                <div class="col-md-5 m-auto">
                                    <button type="button" onclick="transfer_crypto()" class="btn btn-primary btn-block">ثبت درخواست</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <script>
        $('#total_amount').digitbox({grouping:1, separator:',', truevalue:1});

        $('#total_amount,#amount_dollar').keyup(function() {
            var price_dollar = <?php echo e($result->orders_model->fee); ?>;
            if($(this).attr('name')=='total_amount' ){
                var total_amount = $('#total_amount').val().split(',').join('');
                $('#amount_dollar').val(total_amount / price_dollar);

            }else if($(this).attr('name')=='amount_dollar' ){
                var amount_dollar = $('#amount_dollar').val();
                $('#total_amount').val(amount_dollar * price_dollar);
            }
        });

        function transfer_crypto() {
            swal({
                title: "از تایید اطمینان دارید؟",
                text:'تغییر وضعیت بعد از تایید دیگر امکان پذیر نیست',
                type: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor: "#04d216",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.ajax({
                        url: "<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->order->id); ?>/CryptoTransfer",
                        type: 'put',
                        data: $("#Crypto").serialize(),
                    });
                }
            }).then((data) => {
                if (data.value.status == true) {
                    swal({
                        title: 'انجام شد!',
                        type: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.reload();
                    });
                } else {
                    swal("خطا", data.value.messege, "error");
                }
            });
        }

    </script>

    <?php echo \Illuminate\View\Factory::parentPlaceholder('script'); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.orders.single', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/admin/orders/single-cryptocurrency.blade.php ENDPATH**/ ?>