<?php $__env->startSection('title', 'کارت بانکی های در انتظار تایید'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">کارت بانکی های در انتظار تایید</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title mb-0">کارت بانکی های در انتظار تایید</div>
                </div>
                <div class="col-md-12">
                    <div class="row justify-content-between">
                        <div class="col-md-3">
                            <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                        </div>
                        <div class="col-md-3 d-flex">
                            <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap" id="myTable">
                        <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>نام کاربر</th>
                            <th>شماره کارت</th>
                            <th>شماره حساب</th>
                            <th>نام بانک</th>
                            <th>تاریخ و ساعت ثبت</th>
                            <th>وضعیت</th>
                            <th>جزئیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($card->id); ?></td>
                                <td><?php echo e($card->name .' '. $card->family); ?></td>
                                <td><?php echo e($card->card_number); ?></td>
                                <td><?php echo e($card->account_number); ?></td>
                                <td><?php echo e($card->bank_name); ?></td>
                                <td><?php echo e($card->created_at); ?></td>
                                <td>
                                    <?php if($card->status == 0): ?>
                                        <span class="badge badge-soft-warning">در انتظار تایید</span>
                                    <?php elseif($card->status == 1): ?>
                                        <span class="badge badge-soft-success">تایید شده</span>
                                    <?php else: ?>
                                        <span class="badge badge-soft-danger">رد شده</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a class="btn btn-light" href="<?php echo e(asset('').env('PanelPrefix')); ?>/users/<?php echo e($card->id_user); ?>">جزییات</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table><?php echo e($cards->links()); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/admin/actions/cardbank.blade.php ENDPATH**/ ?>