<?php $__env->startSection('title', 'فروشگاه محصولات'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">سفارش پول دیجیتال</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#all" role="tab">
                            <span>سفارش خرید</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#completed" role="tab">
                            <span>سفارش ها فروش</span>
                        </a>
                    </li>
                </ul>

                <div class="tab-content p-3 text-muted">
                    <div class="tab-pane active" id="all" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0 table-nowrap" id="myTable">
                                <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>لوکو ارز</th>
                                    <th>نام ارز</th>
                                    <th>قیمت خرید</th>
                                    <th>وضعیت</th>
                                    <th>تاریخ سفارش</th>
                                    <th>مشاهده جزییات</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if( isset($orders_buy) ): ?>
                                    <?php $__currentLoopData = $orders_buy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($order->id); ?></td>
                                            <td>
                                                <img src="<?php echo e(asset($order->digitalMoney->logo)); ?>" width="25px" />
                                            </td>
                                            <td><?php echo e($order->digitalMoney->name_fa); ?></td>
                                            <td><?php echo e(number_format($order->final_price)); ?><small class="ms-1">تومان</small></td>
                                            <td>
                                                <?php if( $order->status == 'pending' ): ?>
                                                    <span class="badge badge-pill badge-soft-warning font-size-12">در انتظار پرداخت</span>
                                                <?php elseif($order->status == 'confirm' ): ?>
                                                    <span class="badge badge-pill badge-soft-success font-size-12">تکمیل شده</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($order->updated_at); ?></td>
                                            <td>
                                                <button type="button" data-bs-toggle="modal" data-bs-target=".order-<?php echo e($order->id); ?>" class="btn btn-primary btn-sm btn-rounded">
                                                    مشاهده
                                                </button>

                                                <div class="modal fade order-<?php echo e($order->id); ?>" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog  modal-lg" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id=myLargeModalLabel">جزییات سفارش</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="row">
                                                                    <div class="col-lg-12">
                                                                        <div class="card border">
                                                                            <?php if( isset($order) ): ?>
                                                                                <div class="card-body">
                                                                                    <div class="invoice-title">
                                                                                        <h4 class="float-end font-size-16">کد پیگیری  <span class="badge badge-pill badge-soft-warning"><?php echo e($order->tracking_code); ?></span></h4>
                                                                                        <div class="mb-4">
                                                                                            <img src="<?php echo e(asset('images/logo/logo-dark.svg')); ?>" alt="logo" height="20"/>
                                                                                        </div>
                                                                                    </div>
                                                                                    <hr>
                                                                                    <div class="row">
                                                                                        <p class="text-center">اطلاعاتی که در این صفحه میبینید متعلق به این سفارش می باشد</p>
                                                                                        <div class="col-sm-12">
                                                                                            <div class="my-2">
                                                                                                <strong>تاریخ ثبت:</strong>
                                                                                                <?php echo e($order->updated_at); ?>

                                                                                            </div>
                                                                                            <div class="my-2">
                                                                                                <?php if( in_array($order->status, ['confirm'])): ?>
                                                                                                    <strong>مبلغ پرداخت شده:</strong>
                                                                                                    <?php echo e(number_format($order->final_price)); ?> تومان
                                                                                                <?php elseif( $order->status == 'payment-pending'): ?>
                                                                                                    <strong>مبلغ قابل پرداخت :</strong>
                                                                                                    <?php echo e(number_format($order->final_price)); ?> تومان
                                                                                                <?php endif; ?>
                                                                                            </div>
                                                                                            <div class="my-2">
                                                                                                <strong>وضعیت:</strong>
                                                                                                <?php if( $order->status == 'pending' ): ?>
                                                                                                    <span class="badge badge-pill badge-soft-warning font-size-12">در انتظار پرداخت</span>
                                                                                                <?php elseif($order->status == 'confirm' ): ?>
                                                                                                    <span class="badge badge-pill badge-soft-success font-size-12">تکمیل شده</span>
                                                                                                <?php endif; ?>
                                                                                            </div>
                                                                                            <div class="my-2"> <strong> آدرس کیف پول:</strong> <span class="badge badge-pill badge-soft-warning font-size-14"><?php echo e($order->wallet_currency); ?></span></div>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="py-2 mt-3">
                                                                                        <h3 class="font-size-15 fw-bold">جزئیات سفارش</h3>
                                                                                    </div>

                                                                                    <div class="table-responsive">
                                                                                        <table class="table table-bordered">
                                                                                            <thead class="">
                                                                                            <tr>
                                                                                                <th class="text-center">#</th>
                                                                                                <th class="text-center w-60">نام ارز</th>
                                                                                                <th class="text-center">مقدار / تعداد</th>
                                                                                                <th class="text-center">قیمت واحد</th>
                                                                                                <th class="text-center">نوع پرداخت</th>
                                                                                                <th class="text-center">مبلغ کل</th>
                                                                                            </tr>
                                                                                            </thead>
                                                                                            <tbody class="text-center">
                                                                                            <tr>
                                                                                                <td scope="row" class="sans-serif">1</td>
                                                                                                <td><?php echo e($order->digitalMoney->name_fa); ?></td>
                                                                                                <td><?php echo e($order->quantity); ?></td>
                                                                                                <td><?php echo e(number_format($order->currency_price)); ?> تومان</td>
                                                                                                <td><?php echo e($order->payment_type == 'wallet' ? 'با کیف پول' : 'کارت به کارت'); ?></td>
                                                                                                <td><?php echo e(number_format($order->final_price)); ?> تومان</td>
                                                                                            </tr>
                                                                                            <tr class="border-0">
                                                                                                <th class="border-0"></th>
                                                                                            </tr>
                                                                                            <tr>
                                                                                                <td class="border-0"></td>
                                                                                                <th scope="row">توضیحات بخش پشتیبانی</th>
                                                                                                <td colspan="4" class="sans-serif">
                                                                                                    <span><?php echo e($order->admin_note ?? '-'); ?></span>
                                                                                                </td>
                                                                                            </tr>
                                                                                            </tbody>
                                                                                        </table>
                                                                                    </div>
                                                                                </div>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                </tbody>
                            </table>
                            <?php echo e($orders_buy->fragment('all')->links()); ?>

                        </div>
                    </div>
                    <div class="tab-pane" id="completed" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table align-middle mb-0 table-nowrap" id="myTable">
                                <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>لوکو ارز</th>
                                    <th>نام ارز</th>
                                    <th>قیمت خرید</th>
                                    <th>وضعیت</th>
                                    <th>تاریخ سفارش</th>
                                    <th>مشاهده جزییات</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if( isset($orders_sell) ): ?>
                                    <?php $__currentLoopData = $orders_sell; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($order->id); ?></td>
                                            <td>
                                                <img src="<?php echo e(asset($order->digitalMoney->logo)); ?>" width="25px"/>
                                            </td>
                                            <td><?php echo e($order->digitalMoney->name_fa); ?></td>
                                            <td><?php echo e(number_format($order->final_price)); ?><small class="ms-1">تومان</small></td>
                                            <td>
                                                <?php if( $order->status == 'pending' ): ?>
                                                    <span class="badge badge-pill badge-soft-warning font-size-12">در انتظار پرداخت</span>
                                                <?php elseif($order->status == 'confirm' ): ?>
                                                    <span class="badge badge-pill badge-soft-success font-size-12">تکمیل شده</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($order->updated_at); ?></td>
                                            <td>
                                                <button type="button" data-bs-toggle="modal" data-bs-target=".order-<?php echo e($order->id); ?>" class="btn btn-primary btn-sm btn-rounded">
                                                    مشاهده
                                                </button>

                                                <div class="modal fade order-<?php echo e($order->id); ?>" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog  modal-lg" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id=myLargeModalLabel">جزییات سفارش</h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="row">
                                                                    <div class="col-lg-12">
                                                                        <div class="card border">
                                                                            <?php if( isset($order) ): ?>
                                                                                <div class="card-body">
                                                                                    <div class="invoice-title">
                                                                                        <h4 class="float-end font-size-16">کد پیگیری  <span class="badge badge-pill badge-soft-warning"><?php echo e($order->tracking_code); ?></span></h4>
                                                                                        <div class="mb-4">
                                                                                            <img src="<?php echo e(asset('images/logo/logo-dark.svg')); ?>" alt="logo" height="20"/>
                                                                                        </div>
                                                                                    </div>
                                                                                    <hr>
                                                                                    <div class="row">
                                                                                        <p class="text-center">اطلاعاتی که در این صفحه میبینید متعلق به این سفارش می باشد</p>
                                                                                        <div class="col-sm-12">
                                                                                            <div class="my-2">
                                                                                                <strong>تاریخ ثبت:</strong>
                                                                                                <?php echo e($order->updated_at); ?>

                                                                                            </div>
                                                                                            <div class="my-2">
                                                                                                <?php if( in_array($order->status, ['confirm'])): ?>
                                                                                                    <strong>مبلغ پرداخت شده:</strong>
                                                                                                    <?php echo e(number_format($order->final_price)); ?> تومان
                                                                                                <?php elseif( $order->status == 'payment-pending'): ?>
                                                                                                    <strong>مبلغ قابل پرداخت :</strong>
                                                                                                    <?php echo e(number_format($order->final_price)); ?> تومان
                                                                                                <?php endif; ?>
                                                                                            </div>
                                                                                            <div class="my-2">
                                                                                                <strong>وضعیت:</strong>
                                                                                                <?php if( $order->status == 'pending' ): ?>
                                                                                                    <span class="badge badge-pill badge-soft-warning font-size-12">در انتظار پرداخت</span>
                                                                                                <?php elseif($order->status == 'confirm' ): ?>
                                                                                                    <span class="badge badge-pill badge-soft-success font-size-12">تکمیل شده</span>
                                                                                                <?php endif; ?>
                                                                                            </div>
                                                                                            <div class="my-2"> <strong> آدرس کیف پول:</strong> <span class="badge badge-pill badge-soft-warning font-size-14"><?php echo e($order->wallet_currency); ?></span></div>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="py-2 mt-3">
                                                                                        <h3 class="font-size-15 fw-bold">جزئیات سفارش</h3>
                                                                                    </div>

                                                                                    <div class="table-responsive">
                                                                                        <table class="table table-bordered">
                                                                                            <thead class="">
                                                                                            <tr>
                                                                                                <th class="text-center">#</th>
                                                                                                <th class="text-center w-60">نام ارز</th>
                                                                                                <th class="text-center">مقدار / تعداد</th>
                                                                                                <th class="text-center">قیمت واحد</th>
                                                                                                <th class="text-center">نوع پرداخت</th>
                                                                                                <th class="text-center">مبلغ کل</th>
                                                                                            </tr>
                                                                                            </thead>
                                                                                            <tbody class="text-center">
                                                                                            <tr>
                                                                                                <td scope="row" class="sans-serif">1</td>
                                                                                                <td><?php echo e($order->digitalMoney->name_fa); ?></td>
                                                                                                <td><?php echo e($order->quantity); ?></td>
                                                                                                <td><?php echo e(number_format($order->currency_price)); ?> تومان</td>
                                                                                                <td><?php echo e($order->payment_type == 'wallet' ? 'با کیف پول' : 'کارت به کارت'); ?></td>
                                                                                                <td><?php echo e(number_format($order->final_price)); ?> تومان</td>
                                                                                            </tr>
                                                                                            <tr class="border-0">
                                                                                                <th class="border-0"></th>
                                                                                            </tr>
                                                                                            <tr>
                                                                                                <td class="border-0"></td>
                                                                                                <th scope="row">توضیحات بخش پشتیبانی</th>
                                                                                                <td colspan="4" class="sans-serif">
                                                                                                    <span><?php echo e($order->admin_note ?? '-'); ?></span>
                                                                                                </td>
                                                                                            </tr>
                                                                                            </tbody>
                                                                                        </table>
                                                                                    </div>
                                                                                </div>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                                </tbody>
                            </table>
                            <?php echo e($orders_sell->fragment('completed')->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {

            var url = document.location.toString();
            if (url.match('#')) {
                $('.nav-tabs a[href="#' + url.split('#')[1] + '"]')[0].click();
            }

            //To make sure that the page always goes to the top
            setTimeout(function () {
                window.scrollTo(0, 0);
            },200);

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/webcore-heydari/Downloads/platform/resources/views/user/currency/order.blade.php ENDPATH**/ ?>