<?php $__env->startSection('title', 'فروشگاه محصولات'); ?>

<?php $__env->startSection('css'); ?>
    <link href="<?php echo e(asset('libs/bootstrap-touchspin/jquery.bootstrap-touchspin.min.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div id="app">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                    <h4 class="mb-sm-0 font-size-18">فاکتور</h4>
                </div>
            </div>
        </div>
        <!-- end page title -->
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php if(session()->get('success')): ?>
            <div class="pt-2 pb-4">
                <span class="alert alert-success"><?php echo e(session()->get('success')); ?></span>
            </div>
        <?php endif; ?>


        <form method="POST" action="<?php echo e(asset('')); ?>shopping">
            <?php echo csrf_field(); ?>
            <input type="text" name="order_id" value="<?php echo e($order->id); ?>" hidden>

            <div class="row">
                <div class="col-xl-8">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table align-middle mb-0 table-nowrap">
                                    <thead class="table-light">
                                        <tr>
                                            <th>محصول</th>
                                            <th>عنوان محصول</th>
                                            <th>قیمت</th>
                                            <th>تعداد</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <img src="<?php echo e(asset($order->product->image)); ?>" alt="product-img" title="product-img" class="avatar-md" />
                                            </td>
                                            <td>
                                                <a href="#" class="text-dark"><h5 class="font-size-14 text-truncate"><?php echo e($order->product->title); ?></h5></a>
                                            </td>
                                            <td><?php echo e(number_format($order->product->product_price)); ?> تومان</td>
                                            <td>
                                                <div style="width: 120px;">
                                                    <div class="input-group  bootstrap-touchspin bootstrap-touchspin-injected">
                                                        <div class="input-group-btn-vertical">
                                                            <a class="btn btn-primary bootstrap-touchspin-up" @click="counter('plus')">+</a>
                                                            <a class="btn btn-primary bootstrap-touchspin-down" @click="counter('minus')">-</a>
                                                        </div>
                                                        <input class="ltr-dir form-control text-left rounded-1" value="<?php echo e(old('quantity')); ?>" v-model="quantity" type="text" name="quantity" readonly>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="card-title mb-3">خلاصه سفارش</h4>

                            <div class="table-responsive">
                                <table class="table mb-0">
                                    <tbody>
                                    <tr>
                                        <td>قیمت سفارش</td>
                                        <td>{{ numberFormat(product_price) }} تومان</td>
                                    </tr>
                                    <tr>
                                        <td>هزینه ارسال</td>
                                        <td><?php echo e($order->delivery_price ? (number_format($order->delivery_price) . ' تومان') : 'رایگان'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>مجموع</th>
                                        <th>{{ numberFormat(final_price) }} تومان</th>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <!-- end table-responsive -->

                            <div>
                                <h4 class="card-title py-4">روش پرداخت</h4>

                                <div class="row">









                                    <div class="col-xl-12">
                                        <label class="card-radio-label mb-3">
                                            <input type="radio" name="pay-method" id="pay-methodoption3" class="card-radio-input" value="wallet" checked>
                                            <div class="card-radio d-flex justify-content-between">
                                                <div>
                                                    <i class="fas fa-wallet font-size-24 text-primary align-middle me-2"></i>
                                                    <span>کیف پول</span>
                                                </div>
                                                <div>موجودی: <?php echo e(number_format(Auth::user()->wallet)); ?><small>تومان</small></div>
                                            </div>
                                        </label>
                                    </div>
                                </div>

                                <div class="row mt-4">
                                    <div class="col-sm-6">
                                        <a href="<?php echo e(asset('')); ?>products" class="btn btn-light"><i class="mdi mdi-arrow-right me-1"></i> بازگشت به فروشگاه </a>
                                    </div>
                                    <div class="col-sm-6">
                                        <div class="text-sm-end mt-2 mt-sm-0">
                                            <button type="submit" class="btn btn-success"><i class="mdi mdi-cart-arrow-right me-1"></i>تایید و پرداخت</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end card -->
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('js/vue.min.js')); ?>"></script>
    <script>
        const vue = new Vue({
            el: '#app',
            data: {
                quantity: 1,
                product_price: 0,
                final_price: 0
            },
            watch: {
                quantity: function () {
                    this.calculate();
                }
            },
            methods: {
                counter(mode) {
                    if(mode === 'plus') {
                        if(this.quantity < <?php echo $order->product->quantity ?>)
                            this.quantity++;
                    }else {
                        if(this.quantity > 1)
                        this.quantity--;
                    }
                },
                calculate() {
                    this.product_price  = <?php echo $order->product->product_price ?> * this.quantity;
                    this.final_price    = <?php echo $order->delivery_price ?> + this.product_price;
                },
                numberFormat(number){
                    return number.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                }
            },
            mounted() {
                this.calculate(this.final_price);
            }
        })
    </script>
    <script>
        $(document).ready(function () {
            $('form').ajaxForm({
                complete: function (data) {
                    data = data.responseJSON;
                    if(data != undefined) {
                        $('form').removeClass('disable-block');
                        if (data.status == true) {
                            swal.fire({
                                icon: 'success',
                                title: "انجام شد",
                                html: data.message,
                                confirmButtonText: "تایید",
                                onClose: () => {
                                    location.href = "<?php echo e(asset('')); ?>product-orders";
                                }
                            });
                        } else {
                            swal.fire({
                                icon: 'error',
                                title: "توجه",
                                html: data.message,
                                confirmButtonText: "تایید",
                                onClose: () => {
                                    location.href = data.url;
                                }
                            })
                            $('.progress').fadeOut();
                        }
                        $('form button').removeAttr('disabled');
                    }
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\arzlan\platform\resources\views/user/ecommerce/checkout.blade.php ENDPATH**/ ?>