<?php $__env->startSection('title', 'خرید پرفکت مانی'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18"> فروش <?php echo e($digital->name_fa); ?></h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);"><?php echo e($digital->name_fa); ?></a></li>
                        <li class="breadcrumb-item active">فروش</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <div class="row">
        <div class="mb-2">
            <div class="row">
                <a class="col-xl-3 col-sm-4" href="<?php echo e(route('currency.buy', ['name' => $digital->name])); ?>">
                    <div class="mb-3">
                        <label class="card-radio-label mb-2">
                            <div class="card-radio">
                                <div class="mb-3">
                                    <img src="<?php echo e($digital->logo); ?>" width="28px">
                                    <span class="font-size-14"> خرید <?php echo e($digital->name_fa); ?></span>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <p class="text-muted mb-1">قیمت</p>
                                    <span class="text-muted"><?php echo e($digital->buy_money); ?></span>
                                </div>
                            </div>
                        </label>
                    </div>
                </a>
                <a class="col-xl-3 col-sm-4" href="<?php echo e(route('currency.sell', ['name' => $digital->name])); ?>">
                    <div class="mb-3">
                        <label class="card-radio-label mb-2">
                            <div class="card-radio border-success">
                                <div class="mb-3">
                                    <img src="<?php echo e($digital->logo); ?>" width="28px">
                                    <span class="font-size-14"> فروش <?php echo e($digital->name_fa); ?></span>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <p class="text-muted mb-1">قیمت</p>
                                    <span class="text-muted"><?php echo e($digital->sell_money); ?></span>
                                </div>
                            </div>
                        </label>
                    </div>
                </a>
            </div>
        </div>
    </div>


    <div class="row">
        <div class="col-lg-7">
            <div class="card">
                <div class="card-body">
                    <div class="crypto-buy-sell-nav">
                        <div class="p-4">
                            <form autocomplete="off" id="buy" method="POST" action="?currency_id=<?php echo e($digital->id); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="mb-3">
                                    <label>مقدار</label>
                                    <div class="row">
                                        <div class="col-sm-12">
                                            <div class="input-group mb-2">
                                                <span class="input-group-text">مقدار فروش</span>
                                                <input type="text" id="currency" name="quantity" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-sm-12">
                                            <div class="input-group mb-2">
                                                <span class="input-group-text"> قیمت دلار</span>
                                                <input type="text" name="currency_money" value="<?php echo e($digital->sell_money); ?>" class="form-control" disabled>
                                            </div>
                                        </div>
                                        <div class="currency-value"></div>
                                        <div class="col-sm-12">
                                            <div class="input-group mb-2">
                                                <input type="text" id="rial" name="final_price" class="form-control text-sm-end" disabled>
                                                <span class="input-group-text">معادل ریالی</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label>حساب <?php echo e($digital->name_fa); ?></label>
                                    <input type="text" name="wallet_currency" id="wallet_currency" value="<?php echo e($digital->wallet); ?>" class="form-control" disabled>
                                </div>
                                <div class="my-4">
                                    <h5 class="font-size-14 mb-2">آیا اکانت شما وریفای شده است:</h5>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="radio" name="account_verification" value="1" id="formRadios1" checked="">
                                        <label class="form-check-label" for="formRadios1">
                                            بلی
                                        </label>
                                    </div>
                                    <div class="form-check mb-2">
                                        <input class="form-check-input" type="radio" name="account_verification" value="0" id="formRadios2">
                                        <label class="form-check-label" for="formRadios2">
                                            خیر
                                        </label>
                                    </div>
                                </div>
                                <div class="mb-5">
                                    <label>توضیحات</label>
                                    <textarea class="form-control" rows="4" name="description"></textarea>
                                </div>


                                <div class="col-sm-12">
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">انتخاب نوع تسویه حساب</span>
                                        <select type="text" name="pay_method" class="form-control">
                                            <option value="wallet">کیف پول</option>
                                            <option value="cart">کارت به کارت</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="card border border-success my-4">
                                    <div class="text-center py-3">مبلغ دریافتی: <span id="payment">0</span></div>
                                </div>

                                <div class="text-center mt-4">
                                    <button type="submit" class="btn btn-success"> فروش <?php echo e($digital->name_fa); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="card">
                <div class="card-body">
                    <div class="card-title">توضیحات فروش</div>
                    <hr>
                    <P><?php echo e($digital->description); ?></P>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>

        $(document).ready(function() {
            $('#buy').submit(function (e) {
                e.preventDefault();
                if (validation()) {
                    const form = $(this);
                    $.ajax({
                        type: form.attr('method'),
                        url: form.attr('action'),
                        data: form.serialize(),
                        beforeSend: function () {
                            loading();
                        },
                        success: function (data) {
                            if (data.message) {
                                swal.fire({
                                    icon: 'success',
                                    title: "انجام شد",
                                    html: data.message,
                                    confirmButtonText: "تایید",
                                }).then(function () {
                                    location.reload();
                                });
                            }
                        },
                        error: function (data) {
                            swal.fire({
                                icon: 'error',
                                title: "توجه",
                                html: data.message,
                                confirmButtonText: "تایید",
                            }).then(function () {
                                if (!data.currency)
                                    location.href = '/'
                            })
                        },
                    });
                }

            })

            $("#buy")[0].reset();

            $("#currency").keyup(function() {
                this.value = this.value.replace(/[^0-9\.]/g,'');
                let currency = document.getElementById($(this).attr("id"))
                currency.classList.remove('border-danger');
                currency.classList.add('border-success')
                setTimeout(function() {
                    let quantity = $('input:text[name=quantity]');
                    const finalMoney = parseInt(quantity.val())  * parseInt(<?php echo e($digital->sell_money); ?>);
                    let dollarUSLocale = Intl.NumberFormat('en-EN');
                    $('input:text[name=final_price]').val(dollarUSLocale.format(finalMoney * 1000));
                    $('#payment').text(dollarUSLocale.format(finalMoney * 1000));
                }, 0);
            });
        });

        function validation() {
            var elements = document.getElementsByTagName("INPUT");
            let validation = true
            for (var i = 0; i < elements.length; i++) {
                if (elements[i].id === 'currency') {
                    if (elements[i].value === '') {
                        elements[i].classList.add('border-danger')
                        validation = false;
                    }
                }
            }
            return validation;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/webcore-heydari/Downloads/platform/resources/views/user/currency/sell.blade.php ENDPATH**/ ?>